% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascat.runAscat.R
\name{runASCAT}
\alias{runASCAT}
\title{runASCAT}
\usage{
runASCAT(
  lrr,
  baf,
  lrrsegmented,
  bafsegmented,
  gender,
  SNPpos,
  chromosomes,
  chrnames,
  sexchromosomes,
  failedqualitycheck = F,
  distancepng = NA,
  copynumberprofilespng = NA,
  nonroundedprofilepng = NA,
  aberrationreliabilitypng = NA,
  gamma = 0.55,
  rho_manual = NA,
  psi_manual = NA,
  pdfPlot = F,
  y_limit = 5,
  circos = NA,
  min_ploidy = 1.5,
  max_ploidy = 5.5,
  min_purity = 0.1,
  max_purity = 1.05,
  X_nonPAR = NULL
)
}
\arguments{
\item{lrr}{(unsegmented) log R, in genomic sequence (all probes), with probe IDs}

\item{baf}{(unsegmented) B Allele Frequency, in genomic sequence (all probes), with probe IDs}

\item{lrrsegmented}{log R, segmented, in genomic sequence (all probes), with probe IDs}

\item{bafsegmented}{B Allele Frequency, segmented, in genomic sequence (only probes heterozygous in germline), with probe IDs}

\item{gender}{a vector of gender for each cases ("XX" or "XY"). Default = NULL: all female ("XX")}

\item{SNPpos}{position of all SNPs}

\item{chromosomes}{a list containing c vectors, where c is the number of chromosomes and every vector contains all probe numbers per chromosome}

\item{chrnames}{a vector containing the names for the chromosomes (e.g. c(1:22,"X"))}

\item{sexchromosomes}{a vector containing the names for the sex chromosomes}

\item{failedqualitycheck}{did the sample fail any previous quality check or not?}

\item{distancepng}{if NA: distance is plotted, if filename is given, the plot is written to a .png file}

\item{copynumberprofilespng}{if NA: possible copy number profiles are plotted, if filename is given, the plot is written to a .png file}

\item{nonroundedprofilepng}{if NA: copy number profile before rounding is plotted (total copy number as well as the copy number of the minor allele), if filename is given, the plot is written to a .png file}

\item{aberrationreliabilitypng}{aberration reliability score is plotted if filename is given}

\item{gamma}{technology parameter, compaction of Log R profiles (expected decrease in case of deletion in diploid sample, 100\% aberrant cells; 1 in ideal case, 0.55 of Illumina 109K arrays)}

\item{rho_manual}{optional argument to override ASCAT optimization and supply rho parameter (not recommended)}

\item{psi_manual}{optional argument to override ASCAT optimization and supply psi parameter (not recommended)}

\item{pdfPlot}{Optional flag if nonrounded plots and ASCAT profile in pdf format are desired. Default=F}

\item{y_limit}{Optional parameter determining the size of the y axis in the nonrounded plot and ASCAT profile. Default=5}

\item{circos}{Optional file to output the non-rounded values in Circos track format. Default=NA}

\item{min_ploidy}{a numerical parameter determining the minimum boundary of the ploidy solution search space. Default=1.5}

\item{max_ploidy}{a numerical parameter determining the maximum boundary of the ploidy solution search space. Default=5.5}

\item{min_purity}{a numerical parameter determining the minimum boundary of the purity solution search space. Default=0.1}

\item{max_purity}{a numerical parameter determining the maximum boundary of the purity solution search space. Default=1.05}

\item{X_nonPAR}{Optional vector containing genomic coordinates (start & stop) of nonPAR region on X. Default=NULL}
}
\value{
list containing optimal purity and ploidy
}
\description{
the ASCAT main function
}
\keyword{internal}
