% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/killNode.R
\name{killNode}
\alias{killNode}
\title{Terminate one or more cluster nodes using process signaling}
\usage{
killNode(x, signal = tools::SIGTERM, ...)
}
\arguments{
\item{x}{cluster or cluster node to terminate.}

\item{signal}{An integer that specifies the signal level to be sent
to the parallel R process.
It's only \code{tools::SIGINT} (2) and \code{tools::SIGTERM} (15) that are
supported on all operating systems (i.e. Unix, macOS, and MS Windows).
All other signals are platform specific, cf. \code{\link[tools:pskill]{tools::pskill()}}.

With the exception for MS Windows, as explained below, using \code{SIGINT}
will trigger an R \code{\link[base:conditions]{interrupt}} condition that
can be caught with \code{\link[=tryCatch]{tryCatch()}} and \code{\link[=withCallingHandlers]{withCallingHandlers()}} using an
\code{interrupt} calling handler.

When using \code{SIGTERM}, there will be no \code{interrupt} condition signaled,
meaning your parallel R code does \emph{not} have a chance to exit gracefully.
Instead, the R process terminates rather abruptly, leaving behind its
temporary folder.

Importantly, contrary to Linux and macOS, it is not possible to get a
cluster node running on MS Windows to exit gracefully. For example,
despite using \code{SIGINT}, there is no \code{interrupt} condition signaled.
As a matter of fact, on MS Windows, \code{SIGINT} works identically to
\code{SIGTERM}, where they both terminate the cluster node abruptly without
giving the R process a chance to exit gracefully. This means that R will
\emph{not} clean up after itself, e.g. there its temporary directory will
remain also after R terminates.}

\item{\ldots}{Not used.}
}
\value{
TRUE if the signal was successfully applied, FALSE if not, and NA if
signaling is not supported on the specific cluster or node.
\emph{Warning}: With R (< 3.5.0), NA is always returned. This is due to a
bug in R (< 3.5.0), where the signaling result cannot be trusted.
}
\description{
Terminate one or more cluster nodes using process signaling
}
\details{
Note that the preferred way to terminate a cluster is via
\code{\link[parallel:makeCluster]{parallel::stopCluster()}}, because it terminates the cluster nodes
by kindly asking each of them to nicely shut themselves down.
Using \code{killNode()} is a much more sever approach. It abruptly
terminates the underlying R process, possibly without giving the
parallel worker a chance to terminate gracefully.  For example,
it might get terminated in the middle of writing to file.
\code{\link[tools:pskill]{tools::pskill()}} is used to send the signal to the R process hosting
the parallel worker.

If \code{signal = tools::SIGTERM} is used and success, this function
will also close any existing socket connection to the node, if they
exist. Moreover, if the node is running on the local host, this
function will also attempt to remove the node's temporary directory,
which is done because the node's R process might not have been exited
gracefully.
}
\section{Known limitations}{

This function works only with cluster nodes of class \code{RichSOCKnode},
which were created by \code{\link[=makeClusterPSOCK]{makeClusterPSOCK()}}.  It does not work when
using \code{\link[parallel:makeCluster]{parallel::makeCluster()}} and friends.
}

\examples{
\dontshow{if ((interactive() || .Platform[["OS.type"]] != "windows")) withAutoprint(\{ # examplesIf}
cl <- makeClusterPSOCK(2)
print(isNodeAlive(cl))  ## [1] TRUE TRUE

res <- killNode(cl)
print(res)

## It might take a moment before the background
## workers are shutdown after having been signaled
Sys.sleep(1.0)

print(isNodeAlive(cl))  ## [1] FALSE FALSE
\dontshow{\}) # examplesIf}
}
\seealso{
Use \code{\link[=isNodeAlive]{isNodeAlive()}} to check whether one or more cluster nodes are alive.
}
