/***************************************************************************
                          odindialog_idea.h  -  description
                             -------------------
    begin                : Fri Mar 9 21:30:11 CEST 2007
    copyright            : (C) 2003 by Thies H. Jochimsen
    email                : jochimse@cns.mpg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ODINDIALOG_IDEA_H
#define ODINDIALOG_IDEA_H

// Qt related headers first to avoid ambiguity with 'debug'
#include <qobject.h>
#include <odinqt/jdxwidget.h>

#include <odinpara/jdxblock.h>
#include <odinpara/jdxtypes.h>
#include <odinpara/jdxnumbers.h>


#include "odinconf.h"

struct IdeaOpts : JcampDxBlock {

  IdeaOpts();

  void set_defaults(const OdinConf& conf, QWidget *parent);

  STD_string get_vxworks_postfix() const;
  STD_string get_vxworks_ext() const;
  STD_string get_vxworks_Makefile() const;
  STD_string get_vxworks_cxx() const {return odindir+"/bin/cxxwrapper.exe";}

  STD_string get_ideadir_slash() const {return replaceStr(ideadir,"\\","/");}
  STD_string get_odindir_slash() const {return replaceStr(odindir,"\\","/");}


  JDXfileName arch;

  JDXfileName ideadir;
  JDXfileName odindir;

  JDXfileName msvcdir;

  JDXfileName seqdir;
  JDXstring odin2idea_label;

  JDXfileName icedir;

  JDXenum vxworks_cpu;
  JDXint vxworks_heap_size;
  JDXbool debug_vxworks_host;

  JDXint make_jobs;
  JDXbool make_clean;



  // read-only settings
  JDXfileName vxworks_dir;
  JDXstring vxworks_flags;
  JDXstring vxworks_opts;
  JDXfileName vxworks_path;
  JDXfileName win_cxx;
  JDXstring hostd_flags;
  JDXstring host_flags;

};


///////////////////////////////////////////////////////


class IdeaDialog :  public QObject, public GuiDialog {
 Q_OBJECT

 public:
  IdeaDialog(QWidget *parent, IdeaOpts& opts, const OdinConf& conf);
  ~IdeaDialog();

 signals:
  void changed();

 private slots:
  void cancel();
  void defaults();
  void compile();
  void update();

 private:
  void do_compile();
  void error_msg(const STD_string& msg);
  int find_in_alternatives(const STD_string& findstr, const STD_list<STD_string>& alternatives);
  bool execute_make(const STD_string& make, const STD_string& target);
  STD_string hosttarget(bool debug, const STD_string& build_includes, const STD_string& global_conf, const STD_string& mprefix, const STD_string& make_install) const;
  static STD_string errcodes_src(const STD_string& msgfile);



  IdeaOpts& opts_cache;
  const OdinConf& conf_cache;
  GuiGridLayout* grid;
  GuiButton* pb_cancel;
  GuiButton* pb_defaults;
  GuiButton* pb_compile;
  JDXwidget* optswidget;

};

///////////////////////////////////////////////////////

class IdeaMethodDialog : public QObject, public GuiDialog {
 Q_OBJECT

 public:
  IdeaMethodDialog(const STD_string& methdir, sarray& selectedMethods, const STD_string& install_prefix, const IdeaOpts& ideaopts, QWidget *parent);
  ~IdeaMethodDialog();


 private slots:
  void make();
  void emitDone();

 private:

  GuiButton* pb_make;
  GuiButton* pb_cancel;
  GuiGridLayout* grid;

  GuiListView* method_list;
  STD_list<GuiListItem*> method_checks;

  sarray& selMeth;
  STD_string methrootdir;
  STD_string install_dir;

  const IdeaOpts& ideaopts_cache;
};



#endif
