// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeFix_HeaderFile
#define _ShapeFix_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Boolean.hxx>
#include <Standard_Real.hxx>
#include <Handle_Message_ProgressIndicator.hxx>
#include <Handle_ShapeExtend_BasicMsgRegistrator.hxx>
#include <Handle_ShapeBuild_ReShape.hxx>
class TopoDS_Shape;
class Message_ProgressIndicator;
class ShapeExtend_BasicMsgRegistrator;
class ShapeBuild_ReShape;
class ShapeFix_Root;
class ShapeFix_EdgeProjAux;
class ShapeFix_Edge;
class ShapeFix_Wire;
class ShapeFix_Face;
class ShapeFix_FixSmallFace;
class ShapeFix_FixSmallSolid;
class ShapeFix_WireVertex;
class ShapeFix_Wireframe;
class ShapeFix_FreeBounds;
class ShapeFix_FaceConnect;
class ShapeFix_Shell;
class ShapeFix_Solid;
class ShapeFix_ShapeTolerance;
class ShapeFix_Shape;
class ShapeFix_EdgeConnect;
class ShapeFix_ComposeShell;
class ShapeFix_SplitCommonVertex;
class ShapeFix_WireSegment;
class ShapeFix_IntersectionTool;
class ShapeFix_SplitTool;
class ShapeFix_SequenceOfWireSegment;
class ShapeFix_DataMapOfShapeBox2d;
class ShapeFix_SequenceNodeOfSequenceOfWireSegment;
class ShapeFix_DataMapNodeOfDataMapOfShapeBox2d;
class ShapeFix_DataMapIteratorOfDataMapOfShapeBox2d;


//! This package provides algorithms for fixing
//! problematic (violating Open CASCADE requirements) shapes.
//! Tools from package ShapeAnalysis are used for detecting the problems. The
//! detecting and fixing is done taking in account various
//! criteria implemented in BRepCheck package.
//! Each class of package ShapeFix deals with one
//! certain type of shapes or with some family of problems.
class ShapeFix 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Runs SameParameter from BRepLib with these adaptations :
  //! <enforce> forces computations, else they are made only on
  //! Edges with flag SameParameter false
  //! <preci>, if not precised, is taken for each EDge as its own
  //! Tolerance
  //! Returns True when done, False if an exception has been raised
  //! In case of exception anyway, as many edges as possible have
  //! been processed. The passed progress indicator allows user
  //! to consult the current progress stage and abort algorithm
  //! if needed.
  Standard_EXPORT static   Standard_Boolean SameParameter (const TopoDS_Shape& shape, const Standard_Boolean enforce, const Standard_Real preci = 0.0, const Handle(Message_ProgressIndicator)& theProgress = 0, const Handle(ShapeExtend_BasicMsgRegistrator)& theMsgReg = 0) ;
  
  //! Runs EncodeRegularity from BRepLib taking into account
  //! shared components of assemblies, so that each component
  //! is processed only once
  Standard_EXPORT static   void EncodeRegularity (const TopoDS_Shape& shape, const Standard_Real tolang = 1.0e-10) ;
  
  //! Removes edges which are less than given tolerance from shape
  //! with help of ShapeFix_Wire::FixSmall()
  Standard_EXPORT static   TopoDS_Shape RemoveSmallEdges (TopoDS_Shape& shape, const Standard_Real Tolerance, Handle(ShapeBuild_ReShape)& context) ;
  
  //! Fix position of the vertices having tolerance more tnan specified one.;
  Standard_EXPORT static   Standard_Boolean FixVertexPosition (TopoDS_Shape& theshape, const Standard_Real theTolerance, const Handle(ShapeBuild_ReShape)& thecontext) ;
  
  //! Calculate size of least edge;
  Standard_EXPORT static   Standard_Real LeastEdgeSize (TopoDS_Shape& theshape) ;




protected:





private:




friend class ShapeFix_Root;
friend class ShapeFix_EdgeProjAux;
friend class ShapeFix_Edge;
friend class ShapeFix_Wire;
friend class ShapeFix_Face;
friend class ShapeFix_FixSmallFace;
friend class ShapeFix_FixSmallSolid;
friend class ShapeFix_WireVertex;
friend class ShapeFix_Wireframe;
friend class ShapeFix_FreeBounds;
friend class ShapeFix_FaceConnect;
friend class ShapeFix_Shell;
friend class ShapeFix_Solid;
friend class ShapeFix_ShapeTolerance;
friend class ShapeFix_Shape;
friend class ShapeFix_EdgeConnect;
friend class ShapeFix_ComposeShell;
friend class ShapeFix_SplitCommonVertex;
friend class ShapeFix_WireSegment;
friend class ShapeFix_IntersectionTool;
friend class ShapeFix_SplitTool;
friend class ShapeFix_SequenceOfWireSegment;
friend class ShapeFix_DataMapOfShapeBox2d;
friend class ShapeFix_SequenceNodeOfSequenceOfWireSegment;
friend class ShapeFix_DataMapNodeOfDataMapOfShapeBox2d;
friend class ShapeFix_DataMapIteratorOfDataMapOfShapeBox2d;

};







#endif // _ShapeFix_HeaderFile
