/* $Id: Suspect_rule_set.cpp 467165 2015-05-11 13:55:19Z kachalos $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'macro.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/macro/Suspect_rule_set.hpp>

// for default organelle and product rules files
#include "organelle_products.inc"
#include "product_rules.inc"
#include <util/util_misc.hpp>
#include <util/line_reader.hpp>
#include <serial/enumvalues.hpp>
#include <serial/serialimpl.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

static bool  s_OrganelleProductRulesInitialized = false;
DEFINE_STATIC_FAST_MUTEX(s_OrganelleProductRulesMutex);
static CRef<CSuspect_rule_set> s_OrganelleProductRules;

static bool  s_ProductRulesInitialized = false;
DEFINE_STATIC_FAST_MUTEX(s_ProductRulesMutex);
static CRef<CSuspect_rule_set> s_ProductRules;


// destructor
CSuspect_rule_set::~CSuspect_rule_set(void)
{
}


static void s_InitializeOrganelleProductRules(const string& name)
{
    CFastMutexGuard GUARD(s_OrganelleProductRulesMutex);
    if (s_OrganelleProductRulesInitialized) {
        return;
    }
    s_OrganelleProductRules.Reset(new CSuspect_rule_set());
    string file = name.empty() ? g_FindDataFile("organelle_products.prt") : name;

    if ( !file.empty() ) {
        auto_ptr<CObjectIStream> in;
        in.reset(CObjectIStream::Open(file, eSerial_AsnText));
        string header = in->ReadFileHeader();
        in->Read(ObjectInfo(*s_OrganelleProductRules), CObjectIStream::eNoFileHeader);    
    }
    if (!s_OrganelleProductRules->IsSet()) {
        size_t num_lines = sizeof (s_Defaultorganelleproducts) / sizeof (char *);     
        string all_rules = "";
        for (size_t i = 0; i < num_lines; i++) {
            all_rules += s_Defaultorganelleproducts[i];
        }
        CNcbiIstrstream istr(all_rules.c_str());
        istr >> MSerial_AsnText >> *s_OrganelleProductRules;
    }

    s_OrganelleProductRulesInitialized = true;
}


static void s_InitializeProductRules(const string& name)
{
    CFastMutexGuard GUARD(s_ProductRulesMutex);
    if (s_ProductRulesInitialized) {
        return;
    }
    s_ProductRules.Reset(new CSuspect_rule_set());
    string file = name.empty() ? g_FindDataFile("product_rules.prt") : name;

    if ( !file.empty() ) {
        auto_ptr<CObjectIStream> in;
        in.reset(CObjectIStream::Open(file, eSerial_AsnText));
        string header = in->ReadFileHeader();
        in->Read(ObjectInfo(*s_ProductRules), CObjectIStream::eNoFileHeader);    
    }
    if (!s_ProductRules->IsSet()) {
        size_t num_lines = sizeof (s_Defaultproductrules) / sizeof (char *);     
        string all_rules = "";
        for (size_t i = 0; i < num_lines; i++) {
            all_rules += s_Defaultproductrules[i];
        }
        CNcbiIstrstream istr(all_rules.c_str());
        istr >> MSerial_AsnText >> *s_ProductRules;
    }

    s_ProductRulesInitialized = true;
}


CConstRef<CSuspect_rule_set> CSuspect_rule_set::GetOrganelleProductRules(const string& name)
{
    s_InitializeOrganelleProductRules(name);
    return CConstRef<CSuspect_rule_set>(s_OrganelleProductRules.GetPointer());
}


CConstRef<CSuspect_rule_set> CSuspect_rule_set::GetProductRules(const string& name)
{
    s_InitializeProductRules(name);
    return CConstRef<CSuspect_rule_set>(s_ProductRules.GetPointer());
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1741, CRC32: b1125738 */
