/*
 * Copyright (c) 2025 Aurélien Berthier
 * <aurelien.berthier@ls2n.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "pappsomspp/core/processing/specpeptidoms/types.h"
#include "pappsomspp/export-import-config.h"

namespace pappso
{
namespace specpeptidoms
{
class PMSPP_LIB_DECL ScoreValues
{
  public:
  ScoreValues();
  ScoreValues(const ScoreValues &other);

  virtual ~ScoreValues();

  const ScoreValues &operator=(const ScoreValues &other);

  int get(ScoreType type) const;

  private:
  int m_scoreTable[10];
};
} // namespace specpeptidoms
} // namespace pappso
