/**
 * \file pappsomspp/processing/cbor/psm/cborscanmapbase.h
 * \date 13/07/2025
 * \author Olivier Langella
 * \brief Base class to handle scan cbor map
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include <QCborMap>
#include "pappsomspp/core/massspectrum/qualifiedmassspectrum.h"
#include "pappsomspp/core/processing/cbor/psm/psmproteinmap.h"

#include "pappsomspp/export-import-config.h"

namespace pappso
{
namespace cbor
{
namespace psm
{


class PsmFileScanProcess;
/**
 * @todo write docs
 */
class PMSPP_LIB_DECL CborScanMapBase : public QCborMap
{
  public:
  /**
   * Default constructor
   */
  CborScanMapBase(const PsmFileScanProcess &psm_file_scan_process);

  /**
   * Destructor
   */
  virtual ~CborScanMapBase();

  virtual void process();

  virtual void filterAndSortPsmList();
  
  void filterPsmListUniqueUniqueProforma();

  /** @brief add a new eval key and double values (from a vector) to each PSM
   */

  std::vector<double>::iterator addPsmEvalVectorDouble(const QString &eval_name,
                                                       const QString &eval_value_key,
                                                       std::vector<double>::iterator begin,
                                                       std::vector<double>::const_iterator end);
  QCborMap getCborScanId() const;
  QCborMap getCborScanPrecursor() const;
  QCborArray getCborPsmList() const;


  void populateProteinMapUsingOldProteinMap(const PsmProteinMap &old_protein_map,
                                            PsmProteinMap &new_protein_map) const;

  protected:
  pappso::QualifiedMassSpectrumSPtr getCurrentQualifiedMassSpectrumSPtr() const;

  protected:
  const PsmFileScanProcess &m_PsmFileScanProcess;
};

} // namespace psm
} // namespace cbor
} // namespace pappso
