/**
 * \file pappsomspp/core/processing/cbor/mzcbor/binarydataarray.h
 * \date 25/11/2025
 * \author Olivier Langella
 * \brief PSI BinaryDataArray object for mzML/mzCBOR
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once
#include <QString>
#include <QXmlStreamWriter>
#include <QXmlStreamReader>
#include "pappsomspp/core/processing/cbor/cborstreamreader.h"
#include "pappsomspp/core/processing/cbor/cborstreamwriter.h"

namespace pappso
{
namespace cbor
{
namespace mzcbor
{

struct BinaryDataArray
{
  void fromCbor(CborStreamReader &reader);
  void toCbor(CborStreamWriter &writer);
  void fromMzml(QXmlStreamReader &reader);
  void toMzml(QXmlStreamWriter &writer);

  void decodeVector(std::size_t estimated_length, std::vector<double> &double_list) const;
  bool isIntensity() const;
  bool isMz() const;

  quint8 bits      = 64;
  bool isInt       = false;
  QString compress = "zlib";
  QString unit;

  QByteArray byteArray;
};
} // namespace mzcbor
} // namespace cbor
} // namespace pappso
