/* ----- nG/merged25519, derived from supercop/crypto_nG/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <lib25519.h>
#include "lib25519_test.h"

#define fail ((ok = 0),printf)
static const char *nG_merged25519_checksums[] = {
  "a4e761839798a07817484e97605bd63215b4938934ed9ce01935bbced48155bc",
  "0a01c09fc8a8c7e8c18f841b2e1b2da9c156868737d194d223b03531cf2db731",
} ;

static void (*crypto_nG)(unsigned char *,const unsigned char *);
#define crypto_nG_SCALARBYTES lib25519_nG_merged25519_SCALARBYTES
#define crypto_nG_POINTBYTES lib25519_nG_merged25519_POINTBYTES

static void *storage_nG_merged25519_q;
static unsigned char *test_nG_merged25519_q;
static void *storage_nG_merged25519_n;
static unsigned char *test_nG_merged25519_n;
static void *storage_nG_merged25519_q2;
static unsigned char *test_nG_merged25519_q2;
static void *storage_nG_merged25519_n2;
static unsigned char *test_nG_merged25519_n2;

#define precomputed_nG_merged25519_NUM 204

static const unsigned char precomputed_nG_merged25519_q_0[] = {133,218,221,213,182,167,220,17,81,165,169,16,157,1,98,146,173,245,154,229,120,122,142,232,80,50,175,61,48,98,60,116};
static const unsigned char precomputed_nG_merged25519_n_0[] = {14,252,177,48,51,24,150,255,44,250,132,235,147,239,78,66,173,190,143,74,31,10,84,177,152,242,102,165,15,106,180,143};
static const unsigned char precomputed_nG_merged25519_q_1[] = {21,137,40,17,147,173,40,217,252,204,13,39,126,161,52,33,103,220,167,227,173,212,171,240,74,133,108,100,110,38,37,203};
static const unsigned char precomputed_nG_merged25519_n_1[] = {4,98,90,244,250,174,214,153,18,248,206,99,12,173,215,101,111,19,140,120,200,225,137,93,10,154,215,119,183,184,110,67};
static const unsigned char precomputed_nG_merged25519_q_2[] = {162,29,197,12,149,155,174,166,249,128,97,252,70,240,197,153,55,135,92,1,67,192,227,81,165,24,200,228,196,179,252,14};
static const unsigned char precomputed_nG_merged25519_n_2[] = {26,90,61,26,108,30,1,123,69,213,78,134,230,158,104,207,14,110,188,73,111,89,39,23,114,21,175,51,18,34,172,225};
static const unsigned char precomputed_nG_merged25519_q_3[] = {99,233,95,90,78,115,131,115,66,215,223,175,169,79,14,163,151,0,237,8,26,122,160,89,64,3,106,116,214,252,226,227};
static const unsigned char precomputed_nG_merged25519_n_3[] = {40,23,118,110,26,89,64,207,170,236,133,185,238,148,225,2,118,128,234,122,43,160,205,8,71,218,49,136,251,19,2,82};
static const unsigned char precomputed_nG_merged25519_q_4[] = {54,150,206,203,58,110,225,157,183,86,161,217,21,173,52,118,210,103,209,184,244,215,140,213,108,38,253,214,220,68,59,21};
static const unsigned char precomputed_nG_merged25519_n_4[] = {193,46,183,245,21,125,231,201,156,66,212,74,156,49,235,176,118,234,219,138,128,194,100,66,242,63,179,4,64,172,10,185};
static const unsigned char precomputed_nG_merged25519_q_5[] = {229,150,16,70,160,155,23,143,193,204,18,207,12,35,16,109,19,161,33,163,231,148,93,33,192,8,208,33,52,245,73,118};
static const unsigned char precomputed_nG_merged25519_n_5[] = {10,7,143,232,161,214,197,102,31,170,6,0,81,126,210,18,101,96,18,149,227,110,205,192,95,127,78,212,117,99,195,227};
static const unsigned char precomputed_nG_merged25519_q_6[] = {73,105,152,67,21,142,191,92,30,165,214,112,236,97,191,160,115,199,32,54,253,64,12,183,200,153,220,13,247,122,168,120};
static const unsigned char precomputed_nG_merged25519_n_6[] = {97,3,128,29,30,130,136,227,27,41,200,232,149,155,85,88,165,150,242,99,80,35,129,101,113,59,149,211,77,30,75,178};
static const unsigned char precomputed_nG_merged25519_q_7[] = {154,10,210,253,121,116,76,235,128,102,47,92,73,216,196,148,103,90,201,122,11,94,192,85,13,193,122,32,104,107,44,86};
static const unsigned char precomputed_nG_merged25519_n_7[] = {106,169,193,176,237,39,174,67,198,73,118,162,37,236,106,78,45,67,20,98,141,248,56,249,185,128,248,126,74,155,171,214};
static const unsigned char precomputed_nG_merged25519_q_8[] = {242,127,197,101,157,182,135,14,30,144,113,135,145,40,211,42,139,166,32,175,62,68,63,56,125,65,228,23,153,31,9,121};
static const unsigned char precomputed_nG_merged25519_n_8[] = {137,33,93,180,100,175,164,180,175,113,146,77,71,201,157,232,74,69,159,109,245,3,51,44,39,14,155,211,55,34,16,27};
static const unsigned char precomputed_nG_merged25519_q_9[] = {56,11,123,153,186,17,205,235,203,26,210,162,38,100,99,95,184,127,125,207,51,224,32,196,119,210,101,197,184,231,245,122};
static const unsigned char precomputed_nG_merged25519_n_9[] = {129,241,79,112,4,141,121,80,104,172,222,222,108,215,166,191,18,54,187,139,89,29,71,91,98,103,167,160,72,42,77,162};
static const unsigned char precomputed_nG_merged25519_q_10[] = {36,227,145,67,153,167,149,57,231,243,241,68,24,56,226,208,21,225,45,44,253,75,155,98,34,41,113,202,172,245,217,59};
static const unsigned char precomputed_nG_merged25519_n_10[] = {248,184,56,147,163,223,180,173,66,182,20,230,145,143,177,100,65,10,32,55,127,20,137,122,228,85,77,171,245,28,137,214};
static const unsigned char precomputed_nG_merged25519_q_11[] = {200,209,38,54,107,155,162,213,139,66,104,33,240,22,163,55,57,117,215,169,210,36,216,146,41,231,244,195,139,121,254,0};
static const unsigned char precomputed_nG_merged25519_n_11[] = {192,35,128,83,162,109,231,202,199,158,130,36,132,214,107,77,69,130,37,98,42,1,138,9,249,184,64,213,118,109,188,141};
static const unsigned char precomputed_nG_merged25519_q_12[] = {0,247,38,106,217,100,0,75,146,156,162,91,151,191,98,7,50,138,182,191,206,5,104,123,113,39,192,119,91,70,133,44};
static const unsigned char precomputed_nG_merged25519_n_12[] = {97,207,224,138,5,184,83,176,42,139,86,52,44,49,3,197,167,220,73,214,54,86,97,21,176,173,2,51,189,184,163,22};
static const unsigned char precomputed_nG_merged25519_q_13[] = {24,71,171,234,213,78,8,17,237,82,105,158,41,52,68,101,207,165,51,142,135,25,110,107,184,104,200,119,68,173,59,119};
static const unsigned char precomputed_nG_merged25519_n_13[] = {56,98,7,141,181,187,179,200,10,182,204,190,168,129,189,32,44,119,77,78,218,191,112,5,67,87,84,50,133,102,245,18};
static const unsigned char precomputed_nG_merged25519_q_14[] = {217,153,48,91,233,138,209,224,28,163,218,7,29,45,183,133,213,145,116,178,133,212,17,102,130,112,139,93,187,16,48,11};
static const unsigned char precomputed_nG_merged25519_n_14[] = {164,117,126,223,222,210,183,203,165,89,96,90,92,52,180,71,137,243,235,34,42,247,179,157,221,184,215,122,42,77,19,148};
static const unsigned char precomputed_nG_merged25519_q_15[] = {233,141,127,176,161,169,81,186,69,119,8,7,219,207,140,141,179,217,154,20,74,236,120,151,133,9,40,11,248,100,171,61};
static const unsigned char precomputed_nG_merged25519_n_15[] = {37,20,118,112,165,202,61,122,229,92,171,192,202,22,253,197,79,109,40,131,114,128,218,129,178,49,179,254,218,218,37,147};
static const unsigned char precomputed_nG_merged25519_q_16[] = {143,235,242,112,234,244,127,42,130,112,146,216,216,118,207,241,18,54,165,57,153,36,51,254,49,158,71,172,234,86,30,115};
static const unsigned char precomputed_nG_merged25519_n_16[] = {228,139,29,124,221,239,86,110,242,200,229,137,171,165,136,144,62,238,2,156,164,202,112,170,25,170,222,164,60,38,172,251};
static const unsigned char precomputed_nG_merged25519_q_17[] = {119,237,4,68,155,203,157,8,39,68,130,178,241,153,84,205,9,184,30,234,214,64,139,141,221,0,208,205,160,208,206,122};
static const unsigned char precomputed_nG_merged25519_n_17[] = {15,188,181,84,79,123,28,96,218,82,147,215,19,139,191,255,171,27,45,165,24,25,233,142,225,76,57,60,188,116,151,63};
static const unsigned char precomputed_nG_merged25519_q_18[] = {230,126,124,186,28,168,134,3,88,238,75,227,231,171,125,245,132,57,18,181,223,229,2,189,221,242,88,163,213,64,50,104};
static const unsigned char precomputed_nG_merged25519_n_18[] = {68,205,99,39,157,39,232,121,65,138,14,209,106,34,53,93,228,125,167,202,33,116,203,133,224,96,179,158,7,219,76,208};
static const unsigned char precomputed_nG_merged25519_q_19[] = {146,242,159,166,200,201,150,160,60,217,52,208,122,192,206,216,213,254,39,88,137,139,18,78,111,220,114,219,129,119,123,67};
static const unsigned char precomputed_nG_merged25519_n_19[] = {146,70,128,239,133,16,48,130,169,201,83,140,118,113,39,26,174,164,250,46,127,84,154,254,213,186,121,88,183,134,34,53};
static const unsigned char precomputed_nG_merged25519_q_20[] = {90,86,188,252,38,122,3,18,104,33,60,199,75,240,95,203,122,59,34,63,90,181,216,112,120,252,142,38,100,73,219,51};
static const unsigned char precomputed_nG_merged25519_n_20[] = {188,20,82,254,10,0,82,194,233,195,12,205,100,107,3,45,38,220,109,116,141,32,25,94,57,182,26,22,49,115,11,224};
static const unsigned char precomputed_nG_merged25519_q_21[] = {208,111,18,67,63,233,46,43,98,19,222,177,223,200,241,217,152,121,123,245,214,32,222,249,73,169,177,60,12,248,55,158};
static const unsigned char precomputed_nG_merged25519_n_21[] = {247,146,8,90,8,199,41,31,163,112,106,211,122,242,184,170,18,98,204,153,159,229,79,111,7,232,42,88,7,163,87,55};
static const unsigned char precomputed_nG_merged25519_q_22[] = {195,200,243,197,196,207,227,141,88,22,134,33,16,234,171,107,21,159,157,201,96,21,72,205,31,234,131,81,182,213,113,64};
static const unsigned char precomputed_nG_merged25519_n_22[] = {114,73,62,161,254,9,21,14,233,92,252,67,128,17,118,236,147,107,117,46,236,71,147,133,124,155,254,161,88,97,5,200};
static const unsigned char precomputed_nG_merged25519_q_23[] = {71,47,120,45,240,125,236,219,24,118,182,126,40,128,132,87,0,8,136,25,211,29,205,193,196,82,219,215,30,225,165,85};
static const unsigned char precomputed_nG_merged25519_n_23[] = {117,189,86,19,188,223,94,108,110,96,152,163,238,14,215,95,249,3,35,246,180,115,139,215,204,210,174,17,27,225,146,148};
static const unsigned char precomputed_nG_merged25519_q_24[] = {6,120,14,54,131,140,165,197,128,126,193,206,138,103,77,167,127,12,178,66,21,27,149,46,219,110,179,232,1,3,10,96};
static const unsigned char precomputed_nG_merged25519_n_24[] = {105,44,234,39,55,66,111,237,198,40,48,255,113,86,248,146,42,107,85,53,126,173,135,195,83,124,223,150,49,42,214,231};
static const unsigned char precomputed_nG_merged25519_q_25[] = {170,173,18,125,183,4,162,58,4,108,184,211,64,98,80,11,14,189,137,1,113,91,228,142,135,109,168,37,4,185,110,41};
static const unsigned char precomputed_nG_merged25519_n_25[] = {164,33,179,146,61,72,144,115,145,255,13,173,230,213,204,172,46,179,219,180,17,115,213,208,164,190,252,45,2,121,87,67};
static const unsigned char precomputed_nG_merged25519_q_26[] = {239,168,117,46,90,253,251,53,129,85,95,19,196,0,198,236,179,159,6,5,138,155,31,208,30,203,63,42,92,176,246,159};
static const unsigned char precomputed_nG_merged25519_n_26[] = {54,168,211,156,169,144,89,156,75,38,141,222,162,116,177,116,22,176,16,39,129,67,110,18,174,149,183,208,22,80,243,60};
static const unsigned char precomputed_nG_merged25519_q_27[] = {70,90,116,158,218,216,103,205,236,149,206,168,77,49,223,238,123,157,44,221,113,190,218,163,15,167,193,24,64,230,200,32};
static const unsigned char precomputed_nG_merged25519_n_27[] = {62,224,81,23,101,197,155,131,180,224,124,147,140,157,182,200,221,142,62,41,87,49,32,137,192,120,40,138,150,172,172,17};
static const unsigned char precomputed_nG_merged25519_q_28[] = {47,28,67,32,72,218,215,211,41,169,231,221,225,158,209,123,45,150,20,202,129,47,66,198,156,164,232,193,166,228,55,98};
static const unsigned char precomputed_nG_merged25519_n_28[] = {242,196,171,22,237,29,23,48,203,78,97,43,51,177,33,41,173,144,211,164,204,185,200,115,27,200,20,223,153,136,23,152};
static const unsigned char precomputed_nG_merged25519_q_29[] = {133,255,102,184,241,33,53,161,64,165,61,128,174,250,60,25,164,76,242,30,148,21,89,53,205,101,155,189,203,217,87,85};
static const unsigned char precomputed_nG_merged25519_n_29[] = {46,118,218,21,6,58,150,225,219,27,183,159,86,243,238,102,167,82,148,176,235,100,137,93,140,190,69,205,42,59,132,137};
static const unsigned char precomputed_nG_merged25519_q_30[] = {58,208,59,76,188,233,160,118,158,60,166,149,188,13,26,154,116,64,194,48,140,179,59,4,238,206,210,89,93,109,139,32};
static const unsigned char precomputed_nG_merged25519_n_30[] = {107,168,181,208,37,162,103,49,30,13,181,90,116,182,204,161,210,253,141,95,240,205,240,165,69,113,238,29,210,3,249,255};
static const unsigned char precomputed_nG_merged25519_q_31[] = {73,62,203,112,176,134,155,69,135,47,30,173,28,43,178,113,188,188,231,27,172,122,96,99,236,242,253,109,210,254,20,16};
static const unsigned char precomputed_nG_merged25519_n_31[] = {64,78,238,224,233,71,9,219,30,166,238,145,142,135,243,131,103,7,83,232,183,239,99,65,25,171,26,38,93,253,194,162};
static const unsigned char precomputed_nG_merged25519_q_32[] = {12,97,67,237,42,207,179,144,2,227,167,226,3,28,166,216,220,242,8,29,166,64,216,106,83,71,185,169,242,153,49,17};
static const unsigned char precomputed_nG_merged25519_n_32[] = {127,26,200,57,169,2,77,216,149,78,53,110,25,175,50,233,26,43,78,67,243,152,142,159,88,195,163,197,134,251,85,202};
static const unsigned char precomputed_nG_merged25519_q_33[] = {93,96,122,15,112,17,211,233,152,205,188,181,90,160,82,225,19,105,186,83,107,89,227,115,56,108,105,11,79,53,207,63};
static const unsigned char precomputed_nG_merged25519_n_33[] = {234,161,205,240,101,129,58,120,2,203,55,111,131,137,23,245,216,239,61,14,186,84,2,81,92,183,101,93,33,34,103,225};
static const unsigned char precomputed_nG_merged25519_q_34[] = {239,87,246,243,207,185,86,248,217,30,54,240,27,254,167,204,120,202,154,90,202,122,61,59,230,89,22,167,42,11,98,45};
static const unsigned char precomputed_nG_merged25519_n_34[] = {171,190,230,107,212,78,249,130,216,145,106,42,198,203,178,238,76,62,101,159,59,39,51,201,169,89,122,92,124,212,24,250};
static const unsigned char precomputed_nG_merged25519_q_35[] = {80,122,179,178,62,164,3,194,112,28,39,23,252,192,155,80,162,6,223,44,24,14,33,18,104,83,41,135,41,109,17,224};
static const unsigned char precomputed_nG_merged25519_n_35[] = {142,200,252,229,150,10,123,159,206,168,81,231,16,240,92,236,28,144,210,217,0,173,112,127,136,187,15,111,150,138,109,119};
static const unsigned char precomputed_nG_merged25519_q_36[] = {56,182,76,24,217,7,54,70,242,91,148,57,174,212,99,231,177,247,71,183,247,38,3,12,249,130,68,7,39,67,189,143};
static const unsigned char precomputed_nG_merged25519_n_36[] = {210,185,232,239,74,58,15,215,244,15,186,140,243,94,6,166,138,80,213,191,7,4,200,44,138,232,124,15,70,166,80,60};
static const unsigned char precomputed_nG_merged25519_q_37[] = {160,69,77,238,221,238,44,234,198,74,237,123,188,231,251,245,2,84,48,87,44,90,108,105,8,157,246,65,156,58,195,57};
static const unsigned char precomputed_nG_merged25519_n_37[] = {208,70,173,227,58,128,247,7,158,114,44,134,37,236,155,193,175,48,1,24,28,247,142,145,47,197,25,148,3,252,167,179};
static const unsigned char precomputed_nG_merged25519_q_38[] = {115,114,240,204,123,58,219,165,106,184,23,78,196,223,139,214,11,17,77,10,195,244,194,41,207,226,246,221,66,68,222,62};
static const unsigned char precomputed_nG_merged25519_n_38[] = {241,50,50,190,236,125,117,62,114,248,185,248,121,110,167,101,7,19,95,47,189,128,92,51,191,197,203,21,245,254,56,242};
static const unsigned char precomputed_nG_merged25519_q_39[] = {17,27,90,95,72,5,219,79,198,96,140,229,7,19,105,220,31,44,10,189,228,142,143,175,103,37,93,43,100,177,222,150};
static const unsigned char precomputed_nG_merged25519_n_39[] = {8,35,126,152,221,126,219,224,48,87,27,139,201,175,66,173,138,113,5,73,26,181,127,228,40,221,169,219,238,57,93,43};
static const unsigned char precomputed_nG_merged25519_q_40[] = {10,2,138,157,12,244,25,125,236,19,139,240,232,244,16,156,12,161,228,81,57,78,67,210,129,29,113,210,20,106,198,226};
static const unsigned char precomputed_nG_merged25519_n_40[] = {166,222,31,175,196,76,20,78,132,242,56,61,146,97,155,109,209,170,216,48,130,119,160,84,86,85,188,207,77,30,140,126};
static const unsigned char precomputed_nG_merged25519_q_41[] = {240,222,146,238,207,103,248,61,137,145,17,6,76,137,189,125,12,79,213,118,195,80,109,29,74,38,106,28,157,152,206,110};
static const unsigned char precomputed_nG_merged25519_n_41[] = {251,246,135,3,126,6,236,29,185,3,148,209,173,16,2,242,27,110,212,137,5,171,125,180,154,52,232,126,34,220,226,177};
static const unsigned char precomputed_nG_merged25519_q_42[] = {35,213,178,187,124,140,73,101,93,210,200,86,179,158,164,210,215,156,54,180,216,243,29,26,235,227,26,142,109,206,108,112};
static const unsigned char precomputed_nG_merged25519_n_42[] = {122,189,106,75,10,100,25,87,235,251,121,142,37,54,45,38,27,156,146,187,235,146,11,63,196,248,43,228,239,152,176,150};
static const unsigned char precomputed_nG_merged25519_q_43[] = {193,217,128,217,238,154,50,186,70,148,167,93,206,43,227,92,253,237,69,30,135,11,132,104,186,147,79,11,193,235,158,85};
static const unsigned char precomputed_nG_merged25519_n_43[] = {249,68,234,200,175,106,31,122,79,107,167,10,37,124,170,233,66,5,127,233,5,108,234,71,191,189,120,252,248,164,23,146};
static const unsigned char precomputed_nG_merged25519_q_44[] = {139,112,244,194,138,153,217,230,143,225,97,150,194,143,167,165,75,20,121,127,220,4,195,150,232,91,181,219,31,78,26,37};
static const unsigned char precomputed_nG_merged25519_n_44[] = {240,8,108,24,44,3,72,203,70,205,254,161,212,43,190,211,30,58,80,191,231,230,149,33,102,225,39,78,169,87,28,231};
static const unsigned char precomputed_nG_merged25519_q_45[] = {142,40,63,66,176,219,127,245,3,253,178,123,88,91,146,185,21,183,120,70,76,69,217,33,34,177,86,96,126,114,27,3};
static const unsigned char precomputed_nG_merged25519_n_45[] = {95,160,182,6,202,134,90,35,53,96,136,211,134,171,148,211,118,251,48,95,248,21,243,174,83,117,207,18,150,221,29,28};
static const unsigned char precomputed_nG_merged25519_q_46[] = {103,129,227,106,53,41,239,32,158,10,78,37,130,41,79,69,183,208,103,118,89,251,74,175,236,209,163,52,221,35,157,31};
static const unsigned char precomputed_nG_merged25519_n_46[] = {46,95,36,196,148,52,40,77,79,83,152,45,161,99,13,111,188,217,182,203,240,81,177,154,63,31,98,65,11,142,197,24};
static const unsigned char precomputed_nG_merged25519_q_47[] = {249,27,137,39,161,15,133,187,99,132,151,171,146,22,39,79,38,151,254,224,252,144,151,55,224,57,37,209,206,32,240,194};
static const unsigned char precomputed_nG_merged25519_n_47[] = {152,102,154,216,31,251,97,187,236,3,80,121,124,92,13,244,145,112,85,148,115,233,176,177,63,64,130,68,166,15,242,108};
static const unsigned char precomputed_nG_merged25519_q_48[] = {133,185,231,141,84,179,78,90,88,65,9,167,25,154,109,95,66,91,94,230,249,234,239,128,77,134,211,97,31,163,247,38};
static const unsigned char precomputed_nG_merged25519_n_48[] = {47,157,164,241,25,123,61,95,97,4,76,139,183,126,27,22,244,89,189,11,230,254,90,189,241,163,249,126,236,10,78,210};
static const unsigned char precomputed_nG_merged25519_q_49[] = {195,234,12,244,247,159,43,89,154,207,87,129,9,174,86,91,49,14,72,158,133,4,10,63,132,217,83,9,59,118,139,19};
static const unsigned char precomputed_nG_merged25519_n_49[] = {226,212,119,253,81,239,100,23,38,101,72,87,105,45,253,60,103,45,35,156,37,137,251,60,163,35,9,106,16,154,45,119};
static const unsigned char precomputed_nG_merged25519_q_50[] = {133,31,247,111,200,212,191,254,182,231,194,23,126,28,147,124,91,165,243,237,143,121,211,16,47,7,174,139,23,104,56,47};
static const unsigned char precomputed_nG_merged25519_n_50[] = {57,101,29,22,86,253,64,71,187,107,116,30,238,144,148,48,0,227,142,231,144,235,31,81,176,45,10,93,225,205,164,242};
static const unsigned char precomputed_nG_merged25519_q_51[] = {100,164,52,85,247,129,172,141,125,67,177,226,248,185,123,176,80,99,233,160,164,225,197,207,250,18,72,121,10,201,34,14};
static const unsigned char precomputed_nG_merged25519_n_51[] = {193,60,149,62,156,153,43,108,5,77,156,134,113,145,113,111,47,126,75,27,129,110,204,69,79,155,127,123,13,191,43,221};
static const unsigned char precomputed_nG_merged25519_q_52[] = {252,139,231,164,188,7,92,122,16,244,213,166,136,81,235,88,209,136,101,105,120,96,170,54,22,136,203,159,77,117,81,154};
static const unsigned char precomputed_nG_merged25519_n_52[] = {40,252,175,146,145,151,124,167,228,175,139,42,158,118,218,147,194,36,175,191,70,184,100,168,251,241,12,121,124,116,150,53};
static const unsigned char precomputed_nG_merged25519_q_53[] = {143,242,153,38,70,0,130,0,67,98,254,148,131,85,127,154,165,67,196,69,56,101,209,108,105,196,117,70,142,241,152,78};
static const unsigned char precomputed_nG_merged25519_n_53[] = {137,53,41,50,33,208,134,171,193,107,122,236,87,44,133,159,235,80,141,15,54,51,242,62,212,89,171,147,200,10,135,140};
static const unsigned char precomputed_nG_merged25519_q_54[] = {52,224,221,192,111,110,162,155,102,66,47,166,37,90,240,129,107,78,51,255,22,163,195,220,215,169,174,127,144,94,226,201};
static const unsigned char precomputed_nG_merged25519_n_54[] = {52,173,167,245,97,13,31,36,106,202,38,234,75,71,153,19,71,218,63,248,155,14,202,32,206,84,144,180,241,224,180,33};
static const unsigned char precomputed_nG_merged25519_q_55[] = {19,129,58,16,91,112,212,175,101,238,120,14,118,215,72,122,168,243,103,14,5,155,120,167,91,165,171,143,43,209,191,81};
static const unsigned char precomputed_nG_merged25519_n_55[] = {130,236,212,243,13,80,154,170,130,215,24,193,141,101,101,168,215,153,194,150,96,153,173,27,108,9,111,197,60,7,172,217};
static const unsigned char precomputed_nG_merged25519_q_56[] = {23,155,224,66,163,85,106,226,131,22,240,140,147,193,178,204,47,129,185,94,6,212,43,215,172,31,181,7,21,234,243,236};
static const unsigned char precomputed_nG_merged25519_n_56[] = {39,24,96,237,13,251,124,122,234,58,1,166,176,139,228,74,91,191,18,74,25,117,123,119,139,1,176,179,130,133,200,49};
static const unsigned char precomputed_nG_merged25519_q_57[] = {219,197,41,136,68,150,118,164,141,38,74,12,215,111,202,130,136,47,4,28,146,148,224,65,117,210,26,200,213,112,74,14};
static const unsigned char precomputed_nG_merged25519_n_57[] = {135,108,110,216,118,255,247,110,14,250,1,70,15,227,48,188,238,144,45,58,31,18,45,23,220,103,197,59,35,188,183,243};
static const unsigned char precomputed_nG_merged25519_q_58[] = {168,9,245,4,218,176,115,72,11,204,7,190,161,49,137,247,5,27,179,115,230,95,14,158,68,30,227,132,125,153,20,105};
static const unsigned char precomputed_nG_merged25519_n_58[] = {59,60,133,102,147,72,54,52,175,218,110,6,20,238,236,143,221,118,254,225,212,21,86,202,90,58,152,199,48,197,95,182};
static const unsigned char precomputed_nG_merged25519_q_59[] = {19,6,106,157,254,10,36,27,66,74,133,218,136,144,135,125,66,231,33,43,150,176,158,159,4,122,81,126,56,97,66,73};
static const unsigned char precomputed_nG_merged25519_n_59[] = {51,38,100,77,150,15,128,241,49,163,156,43,131,210,175,131,148,239,188,253,239,68,38,174,91,253,231,127,56,77,194,119};
static const unsigned char precomputed_nG_merged25519_q_60[] = {162,141,255,162,40,108,188,125,233,10,145,159,166,172,147,218,231,202,74,84,140,122,134,231,252,137,85,102,193,57,244,28};
static const unsigned char precomputed_nG_merged25519_n_60[] = {43,75,147,223,200,128,246,99,53,144,97,248,156,143,22,49,63,52,25,172,135,115,71,208,209,169,242,131,232,185,9,159};
static const unsigned char precomputed_nG_merged25519_q_61[] = {94,102,107,210,115,6,137,18,14,220,220,154,102,44,152,50,112,163,169,91,102,236,176,18,209,18,66,128,188,112,213,122};
static const unsigned char precomputed_nG_merged25519_n_61[] = {72,100,21,171,53,71,79,134,164,152,237,173,26,184,165,153,158,133,172,216,74,232,190,206,30,247,0,133,14,153,102,60};
static const unsigned char precomputed_nG_merged25519_q_62[] = {40,34,94,183,173,244,46,30,228,227,7,34,147,79,57,140,16,211,131,33,164,143,86,13,59,79,3,126,221,12,28,7};
static const unsigned char precomputed_nG_merged25519_n_62[] = {157,38,1,210,164,205,77,143,52,65,73,133,72,122,248,162,212,199,0,145,19,35,54,117,137,14,135,105,63,81,144,235};
static const unsigned char precomputed_nG_merged25519_q_63[] = {88,211,7,25,201,88,168,130,72,20,154,92,7,71,239,4,46,12,86,203,211,97,229,221,126,224,228,156,234,121,95,234};
static const unsigned char precomputed_nG_merged25519_n_63[] = {253,3,6,26,136,2,66,96,106,120,74,93,73,149,57,185,179,34,114,254,238,89,214,249,89,134,63,107,246,153,54,65};
static const unsigned char precomputed_nG_merged25519_q_64[] = {164,93,249,139,221,192,154,53,53,4,75,103,251,134,100,22,176,210,193,110,41,152,7,181,183,242,116,87,93,105,63,103};
static const unsigned char precomputed_nG_merged25519_n_64[] = {196,127,157,234,203,32,233,90,251,147,116,243,54,34,152,23,113,128,143,41,35,171,220,236,200,29,59,57,81,216,242,46};
static const unsigned char precomputed_nG_merged25519_q_65[] = {78,17,74,143,171,215,95,164,212,137,254,178,80,127,13,45,218,255,252,69,223,52,164,135,35,235,86,167,242,168,236,103};
static const unsigned char precomputed_nG_merged25519_n_65[] = {189,88,70,51,3,225,206,243,44,236,56,56,63,27,10,70,38,118,146,59,244,21,230,106,99,190,212,77,221,42,67,119};
static const unsigned char precomputed_nG_merged25519_q_66[] = {238,71,34,225,188,4,13,26,144,70,157,250,182,111,168,59,200,155,227,247,34,54,218,28,163,8,138,72,214,170,189,205};
static const unsigned char precomputed_nG_merged25519_n_66[] = {96,67,95,208,121,23,46,57,171,108,102,161,216,172,175,73,159,168,123,35,51,75,193,132,253,144,246,222,228,201,23,120};
static const unsigned char precomputed_nG_merged25519_q_67[] = {205,244,204,202,186,74,88,247,237,46,10,63,190,73,201,18,80,21,131,2,27,114,134,253,136,114,45,238,195,219,180,95};
static const unsigned char precomputed_nG_merged25519_n_67[] = {80,100,100,236,81,142,247,64,196,4,194,165,131,253,155,207,59,201,241,174,81,150,188,140,106,66,123,104,218,67,145,225};
static const unsigned char precomputed_nG_merged25519_q_68[] = {207,105,197,117,253,71,103,227,138,245,193,163,168,77,226,89,15,205,65,110,249,119,140,15,0,216,133,172,219,11,12,78};
static const unsigned char precomputed_nG_merged25519_n_68[] = {233,72,18,18,154,96,44,46,69,98,137,231,214,88,100,165,3,75,237,52,80,33,116,228,43,128,227,6,227,217,76,187};
static const unsigned char precomputed_nG_merged25519_q_69[] = {18,244,198,188,213,166,93,14,150,4,96,98,118,116,209,211,231,126,9,244,38,88,106,37,193,144,221,115,240,252,81,111};
static const unsigned char precomputed_nG_merged25519_n_69[] = {43,62,58,85,209,87,135,23,116,39,173,126,145,132,233,35,14,143,64,228,200,245,115,249,221,87,246,141,46,248,100,149};
static const unsigned char precomputed_nG_merged25519_q_70[] = {165,90,179,130,204,218,247,189,238,129,95,131,245,206,6,87,236,171,29,181,84,203,58,135,151,5,105,151,216,202,1,74};
static const unsigned char precomputed_nG_merged25519_n_70[] = {64,158,173,19,54,201,125,205,64,105,92,171,243,239,180,235,148,208,199,169,144,13,196,138,184,75,87,249,102,183,126,43};
static const unsigned char precomputed_nG_merged25519_q_71[] = {133,92,158,60,21,108,200,188,216,157,11,100,96,200,221,117,219,48,228,176,97,62,104,115,183,167,21,42,129,98,38,186};
static const unsigned char precomputed_nG_merged25519_n_71[] = {19,113,230,38,129,48,147,11,124,8,111,128,153,85,193,126,61,154,198,200,239,194,164,107,68,141,42,46,56,69,33,98};
static const unsigned char precomputed_nG_merged25519_q_72[] = {20,237,110,80,59,209,61,56,111,148,161,62,94,73,71,11,136,115,27,106,35,245,9,34,242,155,207,61,54,203,109,48};
static const unsigned char precomputed_nG_merged25519_n_72[] = {24,83,121,203,216,158,47,158,106,131,35,241,108,240,206,28,173,12,170,244,188,196,51,234,225,185,32,12,113,236,151,236};
static const unsigned char precomputed_nG_merged25519_q_73[] = {253,54,15,90,187,233,161,252,143,101,101,38,34,132,111,199,94,15,122,119,75,57,99,36,225,104,27,222,80,204,86,56};
static const unsigned char precomputed_nG_merged25519_n_73[] = {248,159,134,88,110,15,245,200,135,10,19,194,156,195,9,247,186,157,233,66,255,55,66,40,70,31,13,43,11,111,10,230};
static const unsigned char precomputed_nG_merged25519_q_74[] = {28,105,254,10,231,115,112,55,241,180,78,217,105,125,154,196,34,237,67,69,158,58,184,109,75,145,66,138,183,152,79,114};
static const unsigned char precomputed_nG_merged25519_n_74[] = {115,32,32,108,246,168,201,224,61,168,100,219,252,25,55,139,127,219,33,52,24,76,69,66,108,103,119,186,96,134,30,172};
static const unsigned char precomputed_nG_merged25519_q_75[] = {106,64,102,69,75,76,222,173,193,40,48,164,165,224,27,134,45,156,207,131,71,218,255,75,233,205,19,222,200,63,137,110};
static const unsigned char precomputed_nG_merged25519_n_75[] = {231,137,251,196,111,109,126,243,38,184,15,33,198,220,208,33,59,108,93,74,212,123,38,136,118,183,19,173,181,143,188,221};
static const unsigned char precomputed_nG_merged25519_q_76[] = {51,0,154,92,203,162,128,110,60,210,148,225,64,147,104,76,53,214,226,119,105,175,147,176,189,36,196,48,204,125,140,74};
static const unsigned char precomputed_nG_merged25519_n_76[] = {110,142,138,114,250,226,80,42,161,22,196,158,214,195,61,114,158,160,103,242,24,249,73,36,79,200,62,23,67,249,127,233};
static const unsigned char precomputed_nG_merged25519_q_77[] = {173,63,99,222,178,169,165,115,226,108,38,97,159,224,238,158,102,213,137,254,244,132,140,168,205,19,207,181,159,165,194,87};
static const unsigned char precomputed_nG_merged25519_n_77[] = {239,172,33,52,11,26,217,131,181,27,143,107,112,67,36,57,94,240,68,167,75,36,103,79,98,132,210,155,149,60,209,161};
static const unsigned char precomputed_nG_merged25519_q_78[] = {142,19,103,213,195,194,97,250,148,224,75,200,156,48,183,123,204,31,244,92,207,162,85,25,191,192,177,25,22,58,95,124};
static const unsigned char precomputed_nG_merged25519_n_78[] = {6,217,152,202,221,143,3,38,149,101,61,144,40,23,137,233,163,16,12,229,171,154,216,148,14,205,132,185,238,71,249,112};
static const unsigned char precomputed_nG_merged25519_q_79[] = {233,95,239,159,15,181,173,37,243,124,28,216,129,180,0,151,91,112,141,36,220,146,17,124,19,178,132,24,234,162,36,244};
static const unsigned char precomputed_nG_merged25519_n_79[] = {6,135,247,173,18,176,22,216,166,110,161,143,141,200,221,129,42,79,83,173,174,132,231,147,232,175,117,130,2,31,93,14};
static const unsigned char precomputed_nG_merged25519_q_80[] = {235,171,214,149,185,117,9,254,75,198,158,20,118,39,247,14,72,254,101,241,228,92,233,245,163,79,202,89,154,38,132,29};
static const unsigned char precomputed_nG_merged25519_n_80[] = {206,30,35,121,193,167,76,209,105,93,144,225,202,208,155,182,114,69,152,249,191,40,241,150,74,237,103,141,45,134,49,150};
static const unsigned char precomputed_nG_merged25519_q_81[] = {214,216,103,27,218,87,176,96,72,144,132,217,160,62,190,195,11,199,232,164,81,188,169,152,35,134,228,11,185,203,32,73};
static const unsigned char precomputed_nG_merged25519_n_81[] = {145,47,221,170,77,40,173,100,195,78,80,9,96,127,171,225,209,30,146,84,132,80,124,73,136,250,118,185,99,198,43,199};
static const unsigned char precomputed_nG_merged25519_q_82[] = {147,107,197,226,199,221,124,115,1,151,31,97,7,191,23,89,121,172,248,61,81,73,56,254,34,100,135,233,166,53,221,186};
static const unsigned char precomputed_nG_merged25519_n_82[] = {205,249,166,148,75,51,38,174,72,78,240,79,133,244,142,19,70,159,50,81,53,205,71,30,104,21,48,115,35,67,138,109};
static const unsigned char precomputed_nG_merged25519_q_83[] = {243,66,247,66,62,57,139,168,183,216,236,87,204,55,230,94,176,175,28,253,21,22,179,98,36,80,46,193,32,75,176,221};
static const unsigned char precomputed_nG_merged25519_n_83[] = {117,117,96,45,99,75,192,252,46,168,191,224,36,237,231,142,215,231,57,205,200,223,55,199,229,183,115,121,31,33,190,65};
static const unsigned char precomputed_nG_merged25519_q_84[] = {66,98,79,170,54,172,253,63,39,103,7,48,86,182,100,69,160,157,35,220,78,33,201,243,81,165,193,173,74,107,65,111};
static const unsigned char precomputed_nG_merged25519_n_84[] = {193,32,91,37,76,201,20,214,211,232,4,199,153,114,132,79,182,60,248,77,231,125,36,85,96,131,88,21,129,8,12,254};
static const unsigned char precomputed_nG_merged25519_q_85[] = {63,109,129,80,49,251,201,41,111,80,204,4,32,17,72,57,245,212,128,171,163,29,223,218,225,178,156,90,41,231,63,50};
static const unsigned char precomputed_nG_merged25519_n_85[] = {173,240,96,2,195,99,177,226,68,136,188,49,84,64,250,149,78,173,55,99,107,69,7,98,140,191,148,157,137,64,57,253};
static const unsigned char precomputed_nG_merged25519_q_86[] = {165,218,225,122,152,34,207,72,61,226,193,169,80,241,112,239,38,233,231,207,178,54,206,212,133,125,35,105,102,123,35,78};
static const unsigned char precomputed_nG_merged25519_n_86[] = {119,134,61,169,0,75,34,229,11,132,226,236,8,126,158,37,140,35,100,188,235,250,43,92,241,191,144,35,62,158,192,194};
static const unsigned char precomputed_nG_merged25519_q_87[] = {129,14,10,182,22,250,85,228,111,244,59,106,178,39,85,228,194,153,252,106,152,225,13,35,178,228,16,124,177,11,144,124};
static const unsigned char precomputed_nG_merged25519_n_87[] = {92,225,6,97,141,108,210,197,69,239,217,18,245,137,32,30,244,109,38,198,48,32,13,219,142,47,192,78,4,86,66,146};
static const unsigned char precomputed_nG_merged25519_q_88[] = {15,156,131,174,171,245,73,196,50,113,21,84,229,117,131,19,240,26,40,194,169,109,75,243,132,163,33,178,59,115,34,35};
static const unsigned char precomputed_nG_merged25519_n_88[] = {75,67,250,11,172,214,74,39,6,155,217,211,40,248,114,121,85,162,145,159,43,211,53,203,221,189,68,127,205,54,116,114};
static const unsigned char precomputed_nG_merged25519_q_89[] = {167,150,91,222,34,202,202,158,222,85,128,125,225,140,250,177,131,111,252,19,78,156,30,206,120,120,33,191,222,164,107,115};
static const unsigned char precomputed_nG_merged25519_n_89[] = {20,207,210,24,33,88,119,199,31,61,106,27,94,223,248,77,172,83,39,188,217,206,87,250,252,38,206,58,2,113,194,248};
static const unsigned char precomputed_nG_merged25519_q_90[] = {157,28,212,39,141,145,95,162,161,34,193,186,160,255,21,46,4,123,71,62,139,70,253,180,92,58,33,23,147,100,24,51};
static const unsigned char precomputed_nG_merged25519_n_90[] = {77,228,48,160,181,122,36,55,119,132,115,250,186,94,158,181,32,107,7,234,127,48,192,30,17,88,200,152,147,12,19,139};
static const unsigned char precomputed_nG_merged25519_q_91[] = {32,4,56,86,178,184,215,9,111,109,135,216,176,215,186,144,237,223,114,178,34,90,4,207,191,96,29,51,205,35,111,76};
static const unsigned char precomputed_nG_merged25519_n_91[] = {0,85,143,145,217,163,110,101,94,145,23,188,73,70,35,131,56,156,39,40,139,38,11,113,24,155,9,1,103,240,219,86};
static const unsigned char precomputed_nG_merged25519_q_92[] = {225,190,105,124,86,25,110,82,29,88,218,55,207,70,14,99,173,57,30,203,18,85,102,59,145,14,76,243,120,196,138,86};
static const unsigned char precomputed_nG_merged25519_n_92[] = {202,103,195,152,83,118,152,164,128,218,18,106,71,167,100,220,1,129,233,117,55,58,2,173,24,163,2,68,28,27,161,123};
static const unsigned char precomputed_nG_merged25519_q_93[] = {182,234,44,163,47,9,78,52,43,3,241,173,22,50,195,210,227,148,226,23,149,227,156,108,210,163,27,67,1,136,37,39};
static const unsigned char precomputed_nG_merged25519_n_93[] = {162,179,114,79,63,57,44,81,193,33,56,180,102,58,185,3,70,217,121,210,171,203,151,18,81,228,82,143,252,240,97,232};
static const unsigned char precomputed_nG_merged25519_q_94[] = {48,224,174,249,239,168,73,98,61,187,13,145,102,138,147,147,14,188,98,66,30,117,0,77,145,146,36,181,80,202,231,6};
static const unsigned char precomputed_nG_merged25519_n_94[] = {106,112,23,50,29,210,39,79,57,12,122,158,177,133,83,96,21,12,240,106,115,15,239,159,86,17,166,198,166,144,68,131};
static const unsigned char precomputed_nG_merged25519_q_95[] = {103,4,29,212,189,81,41,119,43,101,173,124,11,88,197,0,119,233,81,166,249,141,15,95,117,141,185,72,175,241,87,103};
static const unsigned char precomputed_nG_merged25519_n_95[] = {242,83,31,132,61,78,147,229,73,88,255,37,96,242,142,208,96,30,12,65,15,166,34,212,185,19,37,196,234,33,166,151};
static const unsigned char precomputed_nG_merged25519_q_96[] = {27,156,149,160,184,52,147,29,234,37,202,73,115,189,28,177,197,146,89,15,96,199,5,64,169,222,219,220,171,226,66,248};
static const unsigned char precomputed_nG_merged25519_n_96[] = {6,103,172,137,117,164,200,126,96,32,78,249,8,9,121,182,225,39,158,28,170,212,240,198,33,82,172,221,48,191,250,100};
static const unsigned char precomputed_nG_merged25519_q_97[] = {1,24,59,4,101,181,100,139,204,31,91,210,250,247,205,54,207,76,172,109,87,165,124,71,54,10,195,97,56,12,172,119};
static const unsigned char precomputed_nG_merged25519_n_97[] = {241,165,131,211,163,174,119,205,198,110,254,246,41,123,207,207,233,245,144,31,180,78,131,233,236,243,226,255,93,157,226,206};
static const unsigned char precomputed_nG_merged25519_q_98[] = {148,212,155,105,22,42,217,97,82,59,154,179,74,106,70,86,158,48,249,1,47,163,225,178,78,55,115,221,50,22,43,58};
static const unsigned char precomputed_nG_merged25519_n_98[] = {18,32,225,235,121,109,146,205,229,146,24,56,24,233,22,126,111,33,133,159,249,31,175,203,2,41,57,167,207,53,236,206};
static const unsigned char precomputed_nG_merged25519_q_99[] = {225,34,160,192,183,237,222,62,18,34,101,94,193,177,206,74,24,97,106,197,225,78,237,65,51,252,187,109,92,29,202,129};
static const unsigned char precomputed_nG_merged25519_n_99[] = {228,182,61,134,80,248,152,169,144,228,86,31,210,36,187,230,104,176,123,182,92,161,98,225,228,95,8,126,179,188,115,118};
static const unsigned char precomputed_nG_merged25519_q_100[] = {139,196,209,44,209,44,206,240,225,210,83,122,92,29,82,49,201,107,25,98,252,160,170,19,93,176,110,173,57,73,137,180};
static const unsigned char precomputed_nG_merged25519_n_100[] = {49,236,81,17,2,139,29,237,148,53,47,163,234,48,26,98,132,219,243,15,45,42,104,62,63,171,30,136,14,40,174,109};
static const unsigned char precomputed_nG_merged25519_q_101[] = {200,68,80,223,3,67,208,248,155,67,114,26,214,120,251,203,153,130,112,48,196,193,96,204,125,162,51,125,191,190,48,61};
static const unsigned char precomputed_nG_merged25519_n_101[] = {33,217,207,179,131,181,1,204,249,19,229,30,156,109,111,164,27,182,181,77,81,125,9,245,26,188,57,29,171,9,47,192};
static const unsigned char precomputed_nG_merged25519_q_102[] = {162,0,28,103,136,199,40,69,106,172,107,46,177,130,171,227,6,191,227,196,211,59,112,31,127,243,230,75,168,13,19,92};
static const unsigned char precomputed_nG_merged25519_n_102[] = {236,78,246,110,90,65,156,79,220,93,140,241,38,133,101,190,143,22,91,102,47,73,132,2,22,121,87,44,105,189,228,180};
static const unsigned char precomputed_nG_merged25519_q_103[] = {181,83,207,199,72,216,70,141,103,75,12,215,43,233,19,173,128,44,64,109,76,20,22,167,24,248,77,171,213,137,180,56};
static const unsigned char precomputed_nG_merged25519_n_103[] = {245,221,226,170,131,224,135,73,20,30,235,241,107,173,155,180,184,216,168,105,219,47,44,188,238,195,28,137,94,120,174,91};
static const unsigned char precomputed_nG_merged25519_q_104[] = {71,119,22,251,156,223,174,133,159,200,189,175,198,175,37,249,90,163,106,137,219,152,188,26,107,104,148,212,4,101,234,212};
static const unsigned char precomputed_nG_merged25519_n_104[] = {8,110,37,59,118,72,82,221,109,207,92,19,105,210,153,89,229,172,147,205,252,51,0,133,51,39,92,169,81,25,113,18};
static const unsigned char precomputed_nG_merged25519_q_105[] = {97,191,64,101,220,164,47,33,92,169,162,204,26,9,86,248,55,187,250,75,234,108,64,1,193,167,59,166,224,103,184,207};
static const unsigned char precomputed_nG_merged25519_n_105[] = {51,31,171,63,97,168,57,202,66,43,203,171,187,15,254,191,246,7,131,10,3,57,222,127,141,185,51,175,75,110,249,4};
static const unsigned char precomputed_nG_merged25519_q_106[] = {76,27,91,200,170,63,179,215,123,123,223,230,21,31,9,240,212,176,243,58,224,151,208,131,227,132,237,68,13,224,219,148};
static const unsigned char precomputed_nG_merged25519_n_106[] = {241,246,125,43,103,239,237,44,122,195,143,51,187,182,68,211,122,192,110,133,60,55,181,156,118,151,66,42,142,233,132,34};
static const unsigned char precomputed_nG_merged25519_q_107[] = {80,193,160,250,22,205,105,190,55,82,214,175,175,117,25,132,128,10,117,160,3,237,122,84,219,126,65,17,178,107,51,33};
static const unsigned char precomputed_nG_merged25519_n_107[] = {2,41,17,26,198,119,88,167,221,59,136,122,82,120,126,136,179,22,219,44,233,104,217,7,148,253,9,120,150,203,254,237};
static const unsigned char precomputed_nG_merged25519_q_108[] = {88,132,109,9,176,42,17,99,143,109,179,197,8,51,55,60,45,32,11,228,153,51,203,230,238,12,9,134,16,146,75,126};
static const unsigned char precomputed_nG_merged25519_n_108[] = {125,90,104,48,37,34,117,80,250,44,224,225,239,233,34,113,20,30,116,156,8,71,218,236,40,109,90,225,65,250,159,108};
static const unsigned char precomputed_nG_merged25519_q_109[] = {9,59,236,159,88,156,60,215,65,29,144,206,180,240,221,133,71,146,251,75,252,22,188,79,124,76,59,55,152,30,120,93};
static const unsigned char precomputed_nG_merged25519_n_109[] = {227,109,59,1,58,16,245,87,220,24,30,226,66,198,241,233,56,135,231,193,211,152,219,126,146,145,2,63,45,26,101,128};
static const unsigned char precomputed_nG_merged25519_q_110[] = {191,249,157,232,214,180,112,120,128,229,97,155,200,139,7,30,132,28,110,105,27,93,58,81,241,138,52,156,75,38,170,223};
static const unsigned char precomputed_nG_merged25519_n_110[] = {113,187,8,166,79,70,149,53,130,231,56,237,79,78,172,236,61,72,102,223,207,79,138,186,125,207,95,0,177,15,132,122};
static const unsigned char precomputed_nG_merged25519_q_111[] = {193,163,64,210,46,2,8,101,66,90,202,139,180,114,144,167,116,154,10,162,29,28,70,190,121,65,247,181,59,221,95,10};
static const unsigned char precomputed_nG_merged25519_n_111[] = {93,227,44,20,223,204,200,210,52,230,156,36,182,136,110,83,212,117,127,20,116,192,95,155,246,9,93,2,88,150,91,175};
static const unsigned char precomputed_nG_merged25519_q_112[] = {161,100,179,27,120,46,131,106,156,182,96,12,244,230,127,114,131,43,131,19,163,133,110,90,144,253,114,178,96,133,93,5};
static const unsigned char precomputed_nG_merged25519_n_112[] = {156,159,107,251,13,107,248,203,242,51,231,164,48,88,246,149,122,70,55,125,192,227,47,76,143,7,212,219,249,226,91,20};
static const unsigned char precomputed_nG_merged25519_q_113[] = {128,238,13,127,53,21,194,18,125,63,187,117,97,223,163,170,16,44,103,209,192,127,158,79,25,214,13,249,222,171,186,65};
static const unsigned char precomputed_nG_merged25519_n_113[] = {155,169,171,165,88,143,193,192,229,174,23,49,24,155,232,133,248,158,173,112,162,42,89,62,236,107,89,123,133,124,54,150};
static const unsigned char precomputed_nG_merged25519_q_114[] = {71,86,74,9,116,177,179,72,49,12,187,225,75,169,228,26,94,248,217,152,21,193,203,221,238,197,40,170,162,145,195,184};
static const unsigned char precomputed_nG_merged25519_n_114[] = {26,62,104,111,173,4,224,251,190,230,249,253,27,212,248,115,63,69,100,77,7,29,186,147,98,124,34,222,64,48,49,2};
static const unsigned char precomputed_nG_merged25519_q_115[] = {96,77,52,193,212,255,140,137,183,101,150,16,239,128,116,134,165,76,199,185,49,200,211,176,137,163,66,104,2,14,220,110};
static const unsigned char precomputed_nG_merged25519_n_115[] = {187,42,244,170,51,253,205,98,135,221,225,10,161,197,254,133,41,49,62,82,9,165,246,119,57,111,103,87,234,183,118,119};
static const unsigned char precomputed_nG_merged25519_q_116[] = {251,122,111,246,120,208,239,166,211,47,180,228,135,106,178,161,15,90,163,79,210,199,245,48,125,114,70,136,15,51,123,43};
static const unsigned char precomputed_nG_merged25519_n_116[] = {13,90,122,148,215,139,219,237,185,114,250,70,116,26,1,229,181,21,41,198,156,62,65,116,102,65,232,237,83,231,46,123};
static const unsigned char precomputed_nG_merged25519_q_117[] = {254,56,122,215,227,189,131,240,213,75,243,96,40,48,216,14,61,70,218,222,28,25,28,112,138,222,58,39,139,105,208,188};
static const unsigned char precomputed_nG_merged25519_n_117[] = {173,73,74,2,64,170,144,40,211,161,103,64,184,199,221,15,119,56,55,58,32,155,79,206,222,17,202,243,85,7,249,32};
static const unsigned char precomputed_nG_merged25519_q_118[] = {221,144,122,161,220,168,63,59,177,157,151,203,105,57,134,223,243,13,30,44,194,10,1,192,48,233,52,177,105,254,108,37};
static const unsigned char precomputed_nG_merged25519_n_118[] = {91,105,22,97,41,149,73,204,172,72,190,52,82,126,42,195,82,141,250,205,139,134,76,38,99,191,208,128,76,201,55,231};
static const unsigned char precomputed_nG_merged25519_q_119[] = {78,244,242,41,180,182,171,231,130,180,254,93,212,239,161,66,35,163,55,159,190,81,232,197,205,60,66,192,146,71,126,210};
static const unsigned char precomputed_nG_merged25519_n_119[] = {127,124,129,161,81,20,51,3,237,224,90,78,3,255,236,201,174,25,159,192,35,38,221,205,117,196,123,153,131,97,173,41};
static const unsigned char precomputed_nG_merged25519_q_120[] = {178,209,37,76,92,190,183,6,38,251,155,51,255,151,33,71,104,89,232,137,138,125,206,77,17,154,32,61,166,217,74,76};
static const unsigned char precomputed_nG_merged25519_n_120[] = {235,79,40,53,50,46,91,206,26,218,236,208,101,116,229,44,123,135,18,53,252,116,102,73,71,88,173,160,24,196,88,153};
static const unsigned char precomputed_nG_merged25519_q_121[] = {191,10,24,120,44,179,136,225,116,92,171,204,31,30,102,250,50,117,22,18,136,83,30,123,36,38,207,185,206,28,234,141};
static const unsigned char precomputed_nG_merged25519_n_121[] = {164,254,126,2,194,185,7,81,241,195,17,238,106,157,143,211,114,205,13,51,6,145,23,226,4,20,99,74,71,42,49,39};
static const unsigned char precomputed_nG_merged25519_q_122[] = {58,181,135,41,98,14,200,55,50,69,113,145,130,232,245,132,1,147,73,34,113,192,103,105,0,250,245,167,128,228,122,23};
static const unsigned char precomputed_nG_merged25519_n_122[] = {203,123,250,217,215,118,221,47,96,108,78,133,238,243,192,231,94,7,153,53,191,65,197,139,131,119,1,241,107,153,115,69};
static const unsigned char precomputed_nG_merged25519_q_123[] = {10,72,125,214,110,45,3,118,32,248,245,177,46,193,190,2,48,119,133,76,133,151,170,178,95,229,20,25,94,227,144,32};
static const unsigned char precomputed_nG_merged25519_n_123[] = {127,92,207,211,116,218,76,193,246,23,111,48,131,110,18,170,173,143,73,65,103,209,153,66,51,108,250,130,234,97,143,31};
static const unsigned char precomputed_nG_merged25519_q_124[] = {183,207,141,110,147,213,44,151,129,41,25,148,84,127,165,255,122,216,43,166,238,19,240,81,44,68,20,188,167,16,179,83};
static const unsigned char precomputed_nG_merged25519_n_124[] = {226,156,59,127,152,20,194,27,95,223,50,111,146,27,26,216,73,45,195,208,255,45,214,208,129,172,213,207,4,213,28,172};
static const unsigned char precomputed_nG_merged25519_q_125[] = {63,43,52,114,8,20,123,139,103,128,106,211,137,227,227,93,175,5,45,53,98,253,244,166,11,210,188,150,201,99,173,5};
static const unsigned char precomputed_nG_merged25519_n_125[] = {207,188,210,60,233,151,159,85,160,172,249,57,189,94,226,240,173,18,186,146,117,178,6,183,175,114,227,103,89,124,73,60};
static const unsigned char precomputed_nG_merged25519_q_126[] = {6,174,70,114,4,103,88,251,52,214,179,58,36,214,175,226,215,13,97,187,25,122,13,188,214,181,191,132,225,111,28,210};
static const unsigned char precomputed_nG_merged25519_n_126[] = {164,141,12,199,217,10,241,247,45,93,212,32,193,214,246,251,81,32,178,225,232,253,224,210,26,214,89,22,84,132,155,7};
static const unsigned char precomputed_nG_merged25519_q_127[] = {17,207,26,138,16,164,197,241,107,166,102,45,23,192,169,209,69,89,215,28,123,239,163,166,213,162,143,19,18,4,128,96};
static const unsigned char precomputed_nG_merged25519_n_127[] = {204,196,172,188,163,217,81,173,134,119,178,82,23,75,105,24,147,9,9,245,75,228,228,161,166,124,93,87,233,144,56,163};
static const unsigned char precomputed_nG_merged25519_q_128[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_128[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_q_129[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_129[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_merged25519_q_130[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_130[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_q_131[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_131[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_merged25519_q_132[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_132[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_q_133[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_133[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_merged25519_q_134[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_134[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_merged25519_q_135[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_135[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_merged25519_q_136[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_136[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_merged25519_q_137[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_137[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_merged25519_q_138[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_138[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_merged25519_q_139[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_139[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_merged25519_q_140[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_140[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_merged25519_q_141[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_141[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_merged25519_q_142[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_142[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_merged25519_q_143[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_143[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_merged25519_q_144[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_144[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_merged25519_q_145[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_145[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_merged25519_q_146[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_146[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_merged25519_q_147[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_147[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_merged25519_q_148[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_148[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_merged25519_q_149[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_149[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_merged25519_q_150[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_150[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_merged25519_q_151[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_151[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_merged25519_q_152[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_152[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_merged25519_q_153[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_153[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_merged25519_q_154[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_154[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_merged25519_q_155[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_155[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_merged25519_q_156[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_156[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_merged25519_q_157[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_157[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_merged25519_q_158[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_158[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_merged25519_q_159[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_159[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_merged25519_q_160[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_160[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_merged25519_q_161[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_161[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_merged25519_q_162[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_162[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_merged25519_q_163[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_163[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_merged25519_q_164[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_164[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_merged25519_q_165[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_165[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_merged25519_q_166[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_166[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_merged25519_q_167[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_167[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_merged25519_q_168[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_168[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_merged25519_q_169[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_169[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_merged25519_q_170[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_170[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_merged25519_q_171[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_171[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_merged25519_q_172[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_172[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_merged25519_q_173[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_173[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_merged25519_q_174[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_174[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_merged25519_q_175[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_175[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_merged25519_q_176[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_176[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_merged25519_q_177[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_177[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_merged25519_q_178[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_178[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_merged25519_q_179[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_179[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_merged25519_q_180[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_180[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_merged25519_q_181[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_181[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_merged25519_q_182[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_182[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_merged25519_q_183[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_183[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_merged25519_q_184[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_184[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_merged25519_q_185[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_185[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_merged25519_q_186[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_186[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_merged25519_q_187[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_187[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_merged25519_q_188[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_188[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_merged25519_q_189[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_189[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_merged25519_q_190[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_190[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_merged25519_q_191[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_191[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_merged25519_q_192[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_192[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_merged25519_q_193[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_193[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_merged25519_q_194[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,162};
static const unsigned char precomputed_nG_merged25519_n_194[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_merged25519_q_195[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_195[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_merged25519_q_196[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,230};
static const unsigned char precomputed_nG_merged25519_n_196[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_merged25519_q_197[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_197[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_merged25519_q_198[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_198[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_merged25519_q_199[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_199[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_merged25519_q_200[] = {88,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_nG_merged25519_n_200[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_merged25519_q_201[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_merged25519_n_201[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_merged25519_q_202[] = {201,163,248,106,174,70,95,14,86,81,56,100,81,15,57,151,86,31,162,201,232,94,162,29,194,41,35,9,243,205,96,34};
static const unsigned char precomputed_nG_merged25519_n_202[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_merged25519_q_203[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_merged25519_n_203[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};

static const struct {
  const unsigned char *q;
  long long qsize;
  const unsigned char *n;
  long long nsize;
} precomputed_nG_merged25519[precomputed_nG_merged25519_NUM] = {
  {
    precomputed_nG_merged25519_q_0,32,
    precomputed_nG_merged25519_n_0,32,
  },
  {
    precomputed_nG_merged25519_q_1,32,
    precomputed_nG_merged25519_n_1,32,
  },
  {
    precomputed_nG_merged25519_q_2,32,
    precomputed_nG_merged25519_n_2,32,
  },
  {
    precomputed_nG_merged25519_q_3,32,
    precomputed_nG_merged25519_n_3,32,
  },
  {
    precomputed_nG_merged25519_q_4,32,
    precomputed_nG_merged25519_n_4,32,
  },
  {
    precomputed_nG_merged25519_q_5,32,
    precomputed_nG_merged25519_n_5,32,
  },
  {
    precomputed_nG_merged25519_q_6,32,
    precomputed_nG_merged25519_n_6,32,
  },
  {
    precomputed_nG_merged25519_q_7,32,
    precomputed_nG_merged25519_n_7,32,
  },
  {
    precomputed_nG_merged25519_q_8,32,
    precomputed_nG_merged25519_n_8,32,
  },
  {
    precomputed_nG_merged25519_q_9,32,
    precomputed_nG_merged25519_n_9,32,
  },
  {
    precomputed_nG_merged25519_q_10,32,
    precomputed_nG_merged25519_n_10,32,
  },
  {
    precomputed_nG_merged25519_q_11,32,
    precomputed_nG_merged25519_n_11,32,
  },
  {
    precomputed_nG_merged25519_q_12,32,
    precomputed_nG_merged25519_n_12,32,
  },
  {
    precomputed_nG_merged25519_q_13,32,
    precomputed_nG_merged25519_n_13,32,
  },
  {
    precomputed_nG_merged25519_q_14,32,
    precomputed_nG_merged25519_n_14,32,
  },
  {
    precomputed_nG_merged25519_q_15,32,
    precomputed_nG_merged25519_n_15,32,
  },
  {
    precomputed_nG_merged25519_q_16,32,
    precomputed_nG_merged25519_n_16,32,
  },
  {
    precomputed_nG_merged25519_q_17,32,
    precomputed_nG_merged25519_n_17,32,
  },
  {
    precomputed_nG_merged25519_q_18,32,
    precomputed_nG_merged25519_n_18,32,
  },
  {
    precomputed_nG_merged25519_q_19,32,
    precomputed_nG_merged25519_n_19,32,
  },
  {
    precomputed_nG_merged25519_q_20,32,
    precomputed_nG_merged25519_n_20,32,
  },
  {
    precomputed_nG_merged25519_q_21,32,
    precomputed_nG_merged25519_n_21,32,
  },
  {
    precomputed_nG_merged25519_q_22,32,
    precomputed_nG_merged25519_n_22,32,
  },
  {
    precomputed_nG_merged25519_q_23,32,
    precomputed_nG_merged25519_n_23,32,
  },
  {
    precomputed_nG_merged25519_q_24,32,
    precomputed_nG_merged25519_n_24,32,
  },
  {
    precomputed_nG_merged25519_q_25,32,
    precomputed_nG_merged25519_n_25,32,
  },
  {
    precomputed_nG_merged25519_q_26,32,
    precomputed_nG_merged25519_n_26,32,
  },
  {
    precomputed_nG_merged25519_q_27,32,
    precomputed_nG_merged25519_n_27,32,
  },
  {
    precomputed_nG_merged25519_q_28,32,
    precomputed_nG_merged25519_n_28,32,
  },
  {
    precomputed_nG_merged25519_q_29,32,
    precomputed_nG_merged25519_n_29,32,
  },
  {
    precomputed_nG_merged25519_q_30,32,
    precomputed_nG_merged25519_n_30,32,
  },
  {
    precomputed_nG_merged25519_q_31,32,
    precomputed_nG_merged25519_n_31,32,
  },
  {
    precomputed_nG_merged25519_q_32,32,
    precomputed_nG_merged25519_n_32,32,
  },
  {
    precomputed_nG_merged25519_q_33,32,
    precomputed_nG_merged25519_n_33,32,
  },
  {
    precomputed_nG_merged25519_q_34,32,
    precomputed_nG_merged25519_n_34,32,
  },
  {
    precomputed_nG_merged25519_q_35,32,
    precomputed_nG_merged25519_n_35,32,
  },
  {
    precomputed_nG_merged25519_q_36,32,
    precomputed_nG_merged25519_n_36,32,
  },
  {
    precomputed_nG_merged25519_q_37,32,
    precomputed_nG_merged25519_n_37,32,
  },
  {
    precomputed_nG_merged25519_q_38,32,
    precomputed_nG_merged25519_n_38,32,
  },
  {
    precomputed_nG_merged25519_q_39,32,
    precomputed_nG_merged25519_n_39,32,
  },
  {
    precomputed_nG_merged25519_q_40,32,
    precomputed_nG_merged25519_n_40,32,
  },
  {
    precomputed_nG_merged25519_q_41,32,
    precomputed_nG_merged25519_n_41,32,
  },
  {
    precomputed_nG_merged25519_q_42,32,
    precomputed_nG_merged25519_n_42,32,
  },
  {
    precomputed_nG_merged25519_q_43,32,
    precomputed_nG_merged25519_n_43,32,
  },
  {
    precomputed_nG_merged25519_q_44,32,
    precomputed_nG_merged25519_n_44,32,
  },
  {
    precomputed_nG_merged25519_q_45,32,
    precomputed_nG_merged25519_n_45,32,
  },
  {
    precomputed_nG_merged25519_q_46,32,
    precomputed_nG_merged25519_n_46,32,
  },
  {
    precomputed_nG_merged25519_q_47,32,
    precomputed_nG_merged25519_n_47,32,
  },
  {
    precomputed_nG_merged25519_q_48,32,
    precomputed_nG_merged25519_n_48,32,
  },
  {
    precomputed_nG_merged25519_q_49,32,
    precomputed_nG_merged25519_n_49,32,
  },
  {
    precomputed_nG_merged25519_q_50,32,
    precomputed_nG_merged25519_n_50,32,
  },
  {
    precomputed_nG_merged25519_q_51,32,
    precomputed_nG_merged25519_n_51,32,
  },
  {
    precomputed_nG_merged25519_q_52,32,
    precomputed_nG_merged25519_n_52,32,
  },
  {
    precomputed_nG_merged25519_q_53,32,
    precomputed_nG_merged25519_n_53,32,
  },
  {
    precomputed_nG_merged25519_q_54,32,
    precomputed_nG_merged25519_n_54,32,
  },
  {
    precomputed_nG_merged25519_q_55,32,
    precomputed_nG_merged25519_n_55,32,
  },
  {
    precomputed_nG_merged25519_q_56,32,
    precomputed_nG_merged25519_n_56,32,
  },
  {
    precomputed_nG_merged25519_q_57,32,
    precomputed_nG_merged25519_n_57,32,
  },
  {
    precomputed_nG_merged25519_q_58,32,
    precomputed_nG_merged25519_n_58,32,
  },
  {
    precomputed_nG_merged25519_q_59,32,
    precomputed_nG_merged25519_n_59,32,
  },
  {
    precomputed_nG_merged25519_q_60,32,
    precomputed_nG_merged25519_n_60,32,
  },
  {
    precomputed_nG_merged25519_q_61,32,
    precomputed_nG_merged25519_n_61,32,
  },
  {
    precomputed_nG_merged25519_q_62,32,
    precomputed_nG_merged25519_n_62,32,
  },
  {
    precomputed_nG_merged25519_q_63,32,
    precomputed_nG_merged25519_n_63,32,
  },
  {
    precomputed_nG_merged25519_q_64,32,
    precomputed_nG_merged25519_n_64,32,
  },
  {
    precomputed_nG_merged25519_q_65,32,
    precomputed_nG_merged25519_n_65,32,
  },
  {
    precomputed_nG_merged25519_q_66,32,
    precomputed_nG_merged25519_n_66,32,
  },
  {
    precomputed_nG_merged25519_q_67,32,
    precomputed_nG_merged25519_n_67,32,
  },
  {
    precomputed_nG_merged25519_q_68,32,
    precomputed_nG_merged25519_n_68,32,
  },
  {
    precomputed_nG_merged25519_q_69,32,
    precomputed_nG_merged25519_n_69,32,
  },
  {
    precomputed_nG_merged25519_q_70,32,
    precomputed_nG_merged25519_n_70,32,
  },
  {
    precomputed_nG_merged25519_q_71,32,
    precomputed_nG_merged25519_n_71,32,
  },
  {
    precomputed_nG_merged25519_q_72,32,
    precomputed_nG_merged25519_n_72,32,
  },
  {
    precomputed_nG_merged25519_q_73,32,
    precomputed_nG_merged25519_n_73,32,
  },
  {
    precomputed_nG_merged25519_q_74,32,
    precomputed_nG_merged25519_n_74,32,
  },
  {
    precomputed_nG_merged25519_q_75,32,
    precomputed_nG_merged25519_n_75,32,
  },
  {
    precomputed_nG_merged25519_q_76,32,
    precomputed_nG_merged25519_n_76,32,
  },
  {
    precomputed_nG_merged25519_q_77,32,
    precomputed_nG_merged25519_n_77,32,
  },
  {
    precomputed_nG_merged25519_q_78,32,
    precomputed_nG_merged25519_n_78,32,
  },
  {
    precomputed_nG_merged25519_q_79,32,
    precomputed_nG_merged25519_n_79,32,
  },
  {
    precomputed_nG_merged25519_q_80,32,
    precomputed_nG_merged25519_n_80,32,
  },
  {
    precomputed_nG_merged25519_q_81,32,
    precomputed_nG_merged25519_n_81,32,
  },
  {
    precomputed_nG_merged25519_q_82,32,
    precomputed_nG_merged25519_n_82,32,
  },
  {
    precomputed_nG_merged25519_q_83,32,
    precomputed_nG_merged25519_n_83,32,
  },
  {
    precomputed_nG_merged25519_q_84,32,
    precomputed_nG_merged25519_n_84,32,
  },
  {
    precomputed_nG_merged25519_q_85,32,
    precomputed_nG_merged25519_n_85,32,
  },
  {
    precomputed_nG_merged25519_q_86,32,
    precomputed_nG_merged25519_n_86,32,
  },
  {
    precomputed_nG_merged25519_q_87,32,
    precomputed_nG_merged25519_n_87,32,
  },
  {
    precomputed_nG_merged25519_q_88,32,
    precomputed_nG_merged25519_n_88,32,
  },
  {
    precomputed_nG_merged25519_q_89,32,
    precomputed_nG_merged25519_n_89,32,
  },
  {
    precomputed_nG_merged25519_q_90,32,
    precomputed_nG_merged25519_n_90,32,
  },
  {
    precomputed_nG_merged25519_q_91,32,
    precomputed_nG_merged25519_n_91,32,
  },
  {
    precomputed_nG_merged25519_q_92,32,
    precomputed_nG_merged25519_n_92,32,
  },
  {
    precomputed_nG_merged25519_q_93,32,
    precomputed_nG_merged25519_n_93,32,
  },
  {
    precomputed_nG_merged25519_q_94,32,
    precomputed_nG_merged25519_n_94,32,
  },
  {
    precomputed_nG_merged25519_q_95,32,
    precomputed_nG_merged25519_n_95,32,
  },
  {
    precomputed_nG_merged25519_q_96,32,
    precomputed_nG_merged25519_n_96,32,
  },
  {
    precomputed_nG_merged25519_q_97,32,
    precomputed_nG_merged25519_n_97,32,
  },
  {
    precomputed_nG_merged25519_q_98,32,
    precomputed_nG_merged25519_n_98,32,
  },
  {
    precomputed_nG_merged25519_q_99,32,
    precomputed_nG_merged25519_n_99,32,
  },
  {
    precomputed_nG_merged25519_q_100,32,
    precomputed_nG_merged25519_n_100,32,
  },
  {
    precomputed_nG_merged25519_q_101,32,
    precomputed_nG_merged25519_n_101,32,
  },
  {
    precomputed_nG_merged25519_q_102,32,
    precomputed_nG_merged25519_n_102,32,
  },
  {
    precomputed_nG_merged25519_q_103,32,
    precomputed_nG_merged25519_n_103,32,
  },
  {
    precomputed_nG_merged25519_q_104,32,
    precomputed_nG_merged25519_n_104,32,
  },
  {
    precomputed_nG_merged25519_q_105,32,
    precomputed_nG_merged25519_n_105,32,
  },
  {
    precomputed_nG_merged25519_q_106,32,
    precomputed_nG_merged25519_n_106,32,
  },
  {
    precomputed_nG_merged25519_q_107,32,
    precomputed_nG_merged25519_n_107,32,
  },
  {
    precomputed_nG_merged25519_q_108,32,
    precomputed_nG_merged25519_n_108,32,
  },
  {
    precomputed_nG_merged25519_q_109,32,
    precomputed_nG_merged25519_n_109,32,
  },
  {
    precomputed_nG_merged25519_q_110,32,
    precomputed_nG_merged25519_n_110,32,
  },
  {
    precomputed_nG_merged25519_q_111,32,
    precomputed_nG_merged25519_n_111,32,
  },
  {
    precomputed_nG_merged25519_q_112,32,
    precomputed_nG_merged25519_n_112,32,
  },
  {
    precomputed_nG_merged25519_q_113,32,
    precomputed_nG_merged25519_n_113,32,
  },
  {
    precomputed_nG_merged25519_q_114,32,
    precomputed_nG_merged25519_n_114,32,
  },
  {
    precomputed_nG_merged25519_q_115,32,
    precomputed_nG_merged25519_n_115,32,
  },
  {
    precomputed_nG_merged25519_q_116,32,
    precomputed_nG_merged25519_n_116,32,
  },
  {
    precomputed_nG_merged25519_q_117,32,
    precomputed_nG_merged25519_n_117,32,
  },
  {
    precomputed_nG_merged25519_q_118,32,
    precomputed_nG_merged25519_n_118,32,
  },
  {
    precomputed_nG_merged25519_q_119,32,
    precomputed_nG_merged25519_n_119,32,
  },
  {
    precomputed_nG_merged25519_q_120,32,
    precomputed_nG_merged25519_n_120,32,
  },
  {
    precomputed_nG_merged25519_q_121,32,
    precomputed_nG_merged25519_n_121,32,
  },
  {
    precomputed_nG_merged25519_q_122,32,
    precomputed_nG_merged25519_n_122,32,
  },
  {
    precomputed_nG_merged25519_q_123,32,
    precomputed_nG_merged25519_n_123,32,
  },
  {
    precomputed_nG_merged25519_q_124,32,
    precomputed_nG_merged25519_n_124,32,
  },
  {
    precomputed_nG_merged25519_q_125,32,
    precomputed_nG_merged25519_n_125,32,
  },
  {
    precomputed_nG_merged25519_q_126,32,
    precomputed_nG_merged25519_n_126,32,
  },
  {
    precomputed_nG_merged25519_q_127,32,
    precomputed_nG_merged25519_n_127,32,
  },
  {
    precomputed_nG_merged25519_q_128,32,
    precomputed_nG_merged25519_n_128,32,
  },
  {
    precomputed_nG_merged25519_q_129,32,
    precomputed_nG_merged25519_n_129,32,
  },
  {
    precomputed_nG_merged25519_q_130,32,
    precomputed_nG_merged25519_n_130,32,
  },
  {
    precomputed_nG_merged25519_q_131,32,
    precomputed_nG_merged25519_n_131,32,
  },
  {
    precomputed_nG_merged25519_q_132,32,
    precomputed_nG_merged25519_n_132,32,
  },
  {
    precomputed_nG_merged25519_q_133,32,
    precomputed_nG_merged25519_n_133,32,
  },
  {
    precomputed_nG_merged25519_q_134,32,
    precomputed_nG_merged25519_n_134,32,
  },
  {
    precomputed_nG_merged25519_q_135,32,
    precomputed_nG_merged25519_n_135,32,
  },
  {
    precomputed_nG_merged25519_q_136,32,
    precomputed_nG_merged25519_n_136,32,
  },
  {
    precomputed_nG_merged25519_q_137,32,
    precomputed_nG_merged25519_n_137,32,
  },
  {
    precomputed_nG_merged25519_q_138,32,
    precomputed_nG_merged25519_n_138,32,
  },
  {
    precomputed_nG_merged25519_q_139,32,
    precomputed_nG_merged25519_n_139,32,
  },
  {
    precomputed_nG_merged25519_q_140,32,
    precomputed_nG_merged25519_n_140,32,
  },
  {
    precomputed_nG_merged25519_q_141,32,
    precomputed_nG_merged25519_n_141,32,
  },
  {
    precomputed_nG_merged25519_q_142,32,
    precomputed_nG_merged25519_n_142,32,
  },
  {
    precomputed_nG_merged25519_q_143,32,
    precomputed_nG_merged25519_n_143,32,
  },
  {
    precomputed_nG_merged25519_q_144,32,
    precomputed_nG_merged25519_n_144,32,
  },
  {
    precomputed_nG_merged25519_q_145,32,
    precomputed_nG_merged25519_n_145,32,
  },
  {
    precomputed_nG_merged25519_q_146,32,
    precomputed_nG_merged25519_n_146,32,
  },
  {
    precomputed_nG_merged25519_q_147,32,
    precomputed_nG_merged25519_n_147,32,
  },
  {
    precomputed_nG_merged25519_q_148,32,
    precomputed_nG_merged25519_n_148,32,
  },
  {
    precomputed_nG_merged25519_q_149,32,
    precomputed_nG_merged25519_n_149,32,
  },
  {
    precomputed_nG_merged25519_q_150,32,
    precomputed_nG_merged25519_n_150,32,
  },
  {
    precomputed_nG_merged25519_q_151,32,
    precomputed_nG_merged25519_n_151,32,
  },
  {
    precomputed_nG_merged25519_q_152,32,
    precomputed_nG_merged25519_n_152,32,
  },
  {
    precomputed_nG_merged25519_q_153,32,
    precomputed_nG_merged25519_n_153,32,
  },
  {
    precomputed_nG_merged25519_q_154,32,
    precomputed_nG_merged25519_n_154,32,
  },
  {
    precomputed_nG_merged25519_q_155,32,
    precomputed_nG_merged25519_n_155,32,
  },
  {
    precomputed_nG_merged25519_q_156,32,
    precomputed_nG_merged25519_n_156,32,
  },
  {
    precomputed_nG_merged25519_q_157,32,
    precomputed_nG_merged25519_n_157,32,
  },
  {
    precomputed_nG_merged25519_q_158,32,
    precomputed_nG_merged25519_n_158,32,
  },
  {
    precomputed_nG_merged25519_q_159,32,
    precomputed_nG_merged25519_n_159,32,
  },
  {
    precomputed_nG_merged25519_q_160,32,
    precomputed_nG_merged25519_n_160,32,
  },
  {
    precomputed_nG_merged25519_q_161,32,
    precomputed_nG_merged25519_n_161,32,
  },
  {
    precomputed_nG_merged25519_q_162,32,
    precomputed_nG_merged25519_n_162,32,
  },
  {
    precomputed_nG_merged25519_q_163,32,
    precomputed_nG_merged25519_n_163,32,
  },
  {
    precomputed_nG_merged25519_q_164,32,
    precomputed_nG_merged25519_n_164,32,
  },
  {
    precomputed_nG_merged25519_q_165,32,
    precomputed_nG_merged25519_n_165,32,
  },
  {
    precomputed_nG_merged25519_q_166,32,
    precomputed_nG_merged25519_n_166,32,
  },
  {
    precomputed_nG_merged25519_q_167,32,
    precomputed_nG_merged25519_n_167,32,
  },
  {
    precomputed_nG_merged25519_q_168,32,
    precomputed_nG_merged25519_n_168,32,
  },
  {
    precomputed_nG_merged25519_q_169,32,
    precomputed_nG_merged25519_n_169,32,
  },
  {
    precomputed_nG_merged25519_q_170,32,
    precomputed_nG_merged25519_n_170,32,
  },
  {
    precomputed_nG_merged25519_q_171,32,
    precomputed_nG_merged25519_n_171,32,
  },
  {
    precomputed_nG_merged25519_q_172,32,
    precomputed_nG_merged25519_n_172,32,
  },
  {
    precomputed_nG_merged25519_q_173,32,
    precomputed_nG_merged25519_n_173,32,
  },
  {
    precomputed_nG_merged25519_q_174,32,
    precomputed_nG_merged25519_n_174,32,
  },
  {
    precomputed_nG_merged25519_q_175,32,
    precomputed_nG_merged25519_n_175,32,
  },
  {
    precomputed_nG_merged25519_q_176,32,
    precomputed_nG_merged25519_n_176,32,
  },
  {
    precomputed_nG_merged25519_q_177,32,
    precomputed_nG_merged25519_n_177,32,
  },
  {
    precomputed_nG_merged25519_q_178,32,
    precomputed_nG_merged25519_n_178,32,
  },
  {
    precomputed_nG_merged25519_q_179,32,
    precomputed_nG_merged25519_n_179,32,
  },
  {
    precomputed_nG_merged25519_q_180,32,
    precomputed_nG_merged25519_n_180,32,
  },
  {
    precomputed_nG_merged25519_q_181,32,
    precomputed_nG_merged25519_n_181,32,
  },
  {
    precomputed_nG_merged25519_q_182,32,
    precomputed_nG_merged25519_n_182,32,
  },
  {
    precomputed_nG_merged25519_q_183,32,
    precomputed_nG_merged25519_n_183,32,
  },
  {
    precomputed_nG_merged25519_q_184,32,
    precomputed_nG_merged25519_n_184,32,
  },
  {
    precomputed_nG_merged25519_q_185,32,
    precomputed_nG_merged25519_n_185,32,
  },
  {
    precomputed_nG_merged25519_q_186,32,
    precomputed_nG_merged25519_n_186,32,
  },
  {
    precomputed_nG_merged25519_q_187,32,
    precomputed_nG_merged25519_n_187,32,
  },
  {
    precomputed_nG_merged25519_q_188,32,
    precomputed_nG_merged25519_n_188,32,
  },
  {
    precomputed_nG_merged25519_q_189,32,
    precomputed_nG_merged25519_n_189,32,
  },
  {
    precomputed_nG_merged25519_q_190,32,
    precomputed_nG_merged25519_n_190,32,
  },
  {
    precomputed_nG_merged25519_q_191,32,
    precomputed_nG_merged25519_n_191,32,
  },
  {
    precomputed_nG_merged25519_q_192,32,
    precomputed_nG_merged25519_n_192,32,
  },
  {
    precomputed_nG_merged25519_q_193,32,
    precomputed_nG_merged25519_n_193,32,
  },
  {
    precomputed_nG_merged25519_q_194,32,
    precomputed_nG_merged25519_n_194,32,
  },
  {
    precomputed_nG_merged25519_q_195,32,
    precomputed_nG_merged25519_n_195,32,
  },
  {
    precomputed_nG_merged25519_q_196,32,
    precomputed_nG_merged25519_n_196,32,
  },
  {
    precomputed_nG_merged25519_q_197,32,
    precomputed_nG_merged25519_n_197,32,
  },
  {
    precomputed_nG_merged25519_q_198,32,
    precomputed_nG_merged25519_n_198,32,
  },
  {
    precomputed_nG_merged25519_q_199,32,
    precomputed_nG_merged25519_n_199,32,
  },
  {
    precomputed_nG_merged25519_q_200,32,
    precomputed_nG_merged25519_n_200,32,
  },
  {
    precomputed_nG_merged25519_q_201,32,
    precomputed_nG_merged25519_n_201,32,
  },
  {
    precomputed_nG_merged25519_q_202,32,
    precomputed_nG_merged25519_n_202,32,
  },
  {
    precomputed_nG_merged25519_q_203,32,
    precomputed_nG_merged25519_n_203,32,
  },
} ;

static void test_nG_merged25519_impl(long long impl)
{
  unsigned char *q = test_nG_merged25519_q;
  unsigned char *n = test_nG_merged25519_n;
  unsigned char *q2 = test_nG_merged25519_q2;
  unsigned char *n2 = test_nG_merged25519_n2;
  long long qlen = crypto_nG_POINTBYTES;
  long long nlen = crypto_nG_SCALARBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,lib25519_dispatch_nG_merged25519_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_nG = lib25519_dispatch_nG_merged25519(impl);
    printf("nG_merged25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_nG_merged25519_implementation(impl),lib25519_dispatch_nG_merged25519_compiler(impl));
  } else {
    crypto_nG = lib25519_nG_merged25519;
    printf("nG_merged25519 selected implementation %s compiler %s\n",lib25519_nG_merged25519_implementation(),lib25519_nG_merged25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 512 : 64;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(q2,q,qlen);
      input_prepare(n2,n,nlen);
      secret(n,nlen);
      crypto_nG(q,n);
      public(n,nlen);
      public(q,qlen);
      checksum(q,qlen);
      output_compare(q2,q,qlen,"crypto_nG");
      input_compare(n2,n,nlen,"crypto_nG");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      secret(n2,nlen);
      crypto_nG(q2,n2);
      public(n2,nlen);
      public(q2,qlen);
      if (memcmp(q2,q,qlen) != 0) fail("failure: crypto_nG is nondeterministic\n");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      secret(n2,nlen);
      crypto_nG(n2,n2);
      public(n2,qlen);
      if (memcmp(n2,q,qlen) != 0) fail("failure: crypto_nG does not handle n=q overlap\n");
      memcpy(n2,n,nlen);
    }
    checksum_expected(nG_merged25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_nG_merged25519_NUM;++precomp) {
    output_prepare(q2,q,precomputed_nG_merged25519[precomp].qsize);
    input_prepare(n2,n,precomputed_nG_merged25519[precomp].nsize);
    memcpy(n,precomputed_nG_merged25519[precomp].n,precomputed_nG_merged25519[precomp].nsize);
    memcpy(n2,precomputed_nG_merged25519[precomp].n,precomputed_nG_merged25519[precomp].nsize);
    crypto_nG(q,n);
    if (memcmp(q,precomputed_nG_merged25519[precomp].q,precomputed_nG_merged25519[precomp].qsize)) {
      fail("failure: crypto_nG fails precomputed test vectors\n");
      printf("expected q: ");
      for (long long pos = 0;pos < precomputed_nG_merged25519[precomp].qsize;++pos) printf("%02x",precomputed_nG_merged25519[precomp].q[pos]);
      printf("\n");
      printf("received q: ");
      for (long long pos = 0;pos < precomputed_nG_merged25519[precomp].qsize;++pos) printf("%02x",q[pos]);
      printf("\n");
    }
    output_compare(q2,q,precomputed_nG_merged25519[precomp].qsize,"crypto_nG");
    input_compare(n2,n,precomputed_nG_merged25519[precomp].nsize,"crypto_nG");
  }
}

void test_nG_merged25519(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"nG")) return;
  if (targetp && strcmp(targetp,"merged25519")) return;
  storage_nG_merged25519_q = callocplus(crypto_nG_POINTBYTES);
  test_nG_merged25519_q = aligned(storage_nG_merged25519_q,crypto_nG_POINTBYTES);
  if (crypto_nG_POINTBYTES > maxalloc) maxalloc = crypto_nG_POINTBYTES;
  storage_nG_merged25519_n = callocplus(crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES);
  test_nG_merged25519_n = aligned(storage_nG_merged25519_n,crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES);
  if (crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES > maxalloc) maxalloc = crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES;
  storage_nG_merged25519_q2 = callocplus(maxalloc);
  test_nG_merged25519_q2 = aligned(storage_nG_merged25519_q2,crypto_nG_POINTBYTES);
  storage_nG_merged25519_n2 = callocplus(maxalloc);
  test_nG_merged25519_n2 = aligned(storage_nG_merged25519_n2,crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("nG_merged25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_nG_merged25519();++impl)
      forked(test_nG_merged25519_impl,impl);
    ++test_nG_merged25519_q;
    ++test_nG_merged25519_n;
    ++test_nG_merged25519_q2;
    ++test_nG_merged25519_n2;
  }
  free(storage_nG_merged25519_n2);
  free(storage_nG_merged25519_q2);
  free(storage_nG_merged25519_n);
  free(storage_nG_merged25519_q);
}
#undef crypto_nG_SCALARBYTES
#undef crypto_nG_POINTBYTES

