#!/bin/sh -e

svn co https://github.com/google/fonts/trunk/ofl/karla debian/orig-source/karla.svn

cd debian/orig-source/karla.svn

DATE=$(date -d "$(svn info --xml | grep -o '<date>.*</date>' | grep -o '[0-9TZ:.+-]*')" +%Y%m%d)

svn export . ../karla-${DATE}

cd -

PACKAGE=$(dpkg-parsechangelog -S Source)

tar --owner=root --group=root --mode=a+rX -cJf ${PACKAGE}_${DATE}.orig.tar.xz -C debian/orig-source karla-${DATE}

rm -rf debian/orig-source
