/*
    bigint.h - Manage big positive integer numbers
    Copyright (c) 1996  Martin Schulze <joey@artis.uni-oldenburg.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: bigint.h,v 1.3 2005-08-26 05:12:28 joey Exp $
 */

/*
 * 4294967295 is max (unsigned long int)
 */

#ifndef _BIGINT_H_
#define _BIGINT_H_

#define BIGINT_LEN	2
#define BIGINT_MAX	1000000000
#define BIGINT_PREC	9

typedef struct
{
  unsigned long int val[BIGINT_LEN];
} bigint;

bigint bigint_add(bigint a, bigint b);

bigint bigint_sub(bigint a, bigint b);

bigint bigint_int(int num);

bigint bigint_string(char *s);

void bigint_sprintf (char *res, char *format, bigint a);

/* compares two bigints
   a < b  => -1
   a > b  =>  1
   a == b =>  0
*/
int bigint_cmp(bigint a, bigint b);

#endif /* _BIGINT_H_ */
