/* GStreamer
 *
 * Copyright (C) 2014-2015 Sebastian Dröge <sebastian@centricular.com>
 * Copyright (C) 2015 Brijesh Singh <brijesh.ksingh@gmail.com>
 * Copyright (C) 2021 Rafał Dzięgiel <rafostar.github@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __GST_CLAPPER_VISUALIZATION_H__
#define __GST_CLAPPER_VISUALIZATION_H__

#include <gst/gst.h>
#include <gst/clapper/clapper-prelude.h>

G_BEGIN_DECLS

typedef struct _GstClapperVisualization GstClapperVisualization;
/**
 * GstClapperVisualization:
 * @name: name of the visualization.
 * @description: description of the visualization.
 *
 * A #GstClapperVisualization descriptor.
 */
struct _GstClapperVisualization {
  gchar *name;
  gchar *description;
};

GST_CLAPPER_API
GType                      gst_clapper_visualization_get_type (void);

GST_CLAPPER_API
GstClapperVisualization *  gst_clapper_visualization_copy     (const GstClapperVisualization *vis);

GST_CLAPPER_API
void                       gst_clapper_visualization_free     (GstClapperVisualization *vis);

GST_CLAPPER_API
GstClapperVisualization ** gst_clapper_visualizations_get     (void);

GST_CLAPPER_API
void                       gst_clapper_visualizations_free    (GstClapperVisualization **viss);

G_END_DECLS

#endif /* __GST_CLAPPER_VISUALIZATION_H__ */
