/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import java.util.regex.Pattern;

public class PgConstraint {
    private static final Pattern PATTERN_PRIMARY_KEY = Pattern.compile(".*PRIMARY[\\s]+KEY.*", 2);
    private String definition;
    private String name;
    private String tableName;
    private String comment;

    public PgConstraint(String string) {
        this.name = string;
    }

    public String getCreationSQL() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("ALTER TABLE ");
        stringBuilder.append(PgDiffUtils.getDropIfExists());
        stringBuilder.append(PgDiffUtils.getQuotedName(this.getTableName()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("\tADD CONSTRAINT ");
        stringBuilder.append(PgDiffUtils.getCreateIfNotExists());
        stringBuilder.append(PgDiffUtils.getQuotedName(this.getName()));
        stringBuilder.append(' ');
        stringBuilder.append(this.getDefinition());
        stringBuilder.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("COMMENT ON CONSTRAINT ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append(" ON ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.tableName));
            stringBuilder.append(" IS ");
            stringBuilder.append(this.comment);
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getDropSQL() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("ALTER TABLE ");
        stringBuilder.append(PgDiffUtils.getDropIfExists());
        stringBuilder.append(PgDiffUtils.getQuotedName(this.getTableName()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("\tDROP CONSTRAINT ");
        stringBuilder.append(PgDiffUtils.getDropIfExists());
        stringBuilder.append(PgDiffUtils.getQuotedName(this.getName()));
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimaryKeyConstraint() {
        return PATTERN_PRIMARY_KEY.matcher(this.definition).matches();
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof PgConstraint) {
            PgConstraint pgConstraint = (PgConstraint)object;
            bl = this.definition.equals(pgConstraint.getDefinition()) && this.name.equals(pgConstraint.getName()) && this.tableName.equals(pgConstraint.getTableName());
        }
        return bl;
    }

    public int hashCode() {
        return (this.getClass().getName() + "|" + this.definition + "|" + this.name + "|" + this.tableName).hashCode();
    }
}

