#
# Makefile for the ETSF_IO library embedded in ABINIT
#

include ../../config.mk

all_targets all etsf_io: install
	@echo "$(etsf_io_pkg_name) is now ready for use."

uncompress: uncompress-stamp
	@echo "$(etsf_io_pkg_name) has been uncompressed."

configure: configure-stamp
	@echo "$(etsf_io_pkg_name) has been configured."

build: build-stamp
	@echo "$(etsf_io_pkg_name) has been built."

install: install-stamp
	@echo "$(etsf_io_pkg_name) has been installed in tmp."

uncompress-stamp:
	tar xf $(abinit_srcdir)/lib/etsf_io/$(etsf_io_pkg_name).tar
	touch uncompress-stamp

configure-stamp: uncompress
	-mkdir tmp
	cd $(etsf_io_pkg_name) && \
	 CPP="$(CPP)" \
	 CPPFLAGS="$(CPPFLAGS_ETSF_IO)" \
	 CC="$(CC) $(EXTRA_CC_LDFLAGS)" \
	 CFLAGS="$(CFLAGS_ETSF_IO)" \
	 CXX="$(CXX) $(EXTRA_CXX_LDFLAGS)" \
	 CXXFLAGS="$(CXXFLAGS_ETSF_IO)" \
	 F77="$(FC) $(EXTRA_FC_LDFLAGS)" \
	 FFLAGS="$(FCFLAGS_FIXEDFORM) $(FCFLAGS_ETSF_IO)" \
	 F90="$(FC) $(EXTRA_FC_LDFLAGS)" \
	 F90FLAGS="$(FCFLAGS_FREEFORM) $(FCFLAGS_ETSF_IO)" \
	 FC="$(FC) $(EXTRA_FC_LDFLAGS)" \
	 FCFLAGS="$(FCFLAGS_FREEFORM) $(FCFLAGS_ETSF_IO)" \
	 ./configure --prefix=$(PWD)/tmp --with-netcdf-module-path=`echo "$(netcdf_include)" | sed "s/-I//"` --with-netcdf-ldflags=`echo "$(netcdf_ldflags)" | sed "s/-lnetcdf//"` --disable-build-tests
	touch configure-stamp

build-stamp: configure
	cd $(etsf_io_pkg_name) && $(MAKE)
	touch build-stamp

install-stamp: build
	cd $(etsf_io_pkg_name) && $(MAKE) install
	mv tmp/include/$(fc_type)/* tmp/include
	rmdir tmp/include/$(fc_type)
	touch install-stamp

clean:
	rm -rf $(etsf_io_pkg_name) tmp
	rm -f uncompress-stamp configure-stamp build-stamp install-stamp
