!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_vhnzc
!! NAME
!! calc_vhnzc
!! 
!! FUNCTION
!! Compute vh(nZc) and the <phi_i|vh(nZc)|phi_j> matrix elements
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS 
!!  pawarray
!!    %coreden4pr2(rho_meshsz)= Core density multiplied by 4Pi.r2
!!  pawdata
!!    %indlmn(6,lmn_size)= Gives l,m,n,ln,lm,s for i=lmn
!!    %rad(big_meshsz)= Coordinates of the radial grid
!!    %rad_(big_meshsz)= rad(:) + AA where rad(i)=AA*(exp[BB*(i-1)]-1)
!!  pawps
!!    %phi(wav_meshsz,basis_size)= atomic partial waves
!!  pshead
!!    %atomic_charge= Total atomic charge
!!    %log_step= Step corresponding to radial mesh
!!    %lmn_size= Number of elements for the paw basis
!!    %rho_meshsz= Dimension of radial mesh for read coredens/valedens
!!    %sph_meshsz= Dimension of radial mesh for spheres
!! 
!! OUTPUT
!!  pawarray
!!    %vhnzc(rho_meshsz)= Hartree potential of the density
!!                          of the nucleus + core electrons
!!    %vhnzcij(lmn2_size)= (i,j) channel of the Hartree term inside
!!                         the spheres for the density nZc
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!      calc_vh,ctrap
!!
!! SOURCE

 subroutine calc_vhnzc(pawarray,pawdata,pawps,pshead)

  use defs_pawps
  use defs_basis

  implicit none

!Arguments ---------------------------------------------
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawdata_type)  :: pawdata
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead

!Local variables ---------------------------------------
 integer :: ilm,ilmn,iln,ir,jlm,jlmn,jln,j0lmn,klmn
 real(dp), allocatable :: ff(:)

!--------------------------------------------------------

!Compute core potential VhnZc=Vh(Nc)*r
!----------------------------------------------------------
 call calc_vh(pawarray%coreden4pr2,pshead%rho_meshsz,&
&             pawdata,pshead,pawarray%vhnzc)

!Divide VhnZc by r and add nuclear potential
!-------------------------------------------
 pawarray%vhnzc(1)=zero 
 do ir=2,pshead%rho_meshsz
  pawarray%vhnzc(ir)=(pawarray%vhnzc(ir)-pshead%atomic_charge)/pawdata%rad(ir)
 enddo
!

!Compute the matrix element <phi_i|vh(nZc)|phi_j>
!------------------------------------------------
 allocate(ff(pshead%sph_meshsz))
 pawarray%vhnzcij=zero
 do jlmn=1,pshead%lmn_size
  j0lmn=jlmn*(jlmn-1)/2
  jlm=pawdata%indlmn(4,jlmn);jln=pawdata%indlmn(5,jlmn)
  do ilmn=1,jlmn
   klmn=j0lmn+ilmn
   ilm=pawdata%indlmn(4,ilmn);iln=pawdata%indlmn(5,ilmn)
   if (jlm==ilm) then
    do ir=1,pshead%sph_meshsz
     ff(ir)=pawps%phi(ir,iln)*pawarray%vhnzc(ir)*pawps%phi(ir,jln)&
&          *pawdata%rad_(ir)
    enddo
    call ctrap(pshead%sph_meshsz,ff,pshead%log_step,&
&              pawarray%vhnzcij(klmn))
   endif
  enddo
 enddo
 deallocate(ff)

 end subroutine calc_vhnzc

!!***
