/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.items;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.model.yaml.internal.util.YamlElementUtils;

public class YamlGroupDTO {
    private static final String DEFAULT_FUNCTION = "EQUALITY";
    private static final Set<String> VALID_FUNCTIONS = Set.of("AND", "OR", "NAND", "NOR", "XOR", "COUNT", "AVG", "MEDIAN", "SUM", "MIN", "MAX", "LATEST", "EARLIEST", "EQUALITY");
    public String type;
    public String dimension;
    public String function;
    public List<@NonNull String> parameters;

    public boolean isValid(@NonNull List<@NonNull String> errors, @NonNull List<@NonNull String> warnings) {
        boolean ok = true;
        if (!YamlElementUtils.isValidItemType(this.type)) {
            errors.add("invalid value \"%s\" for \"type\" field in group".formatted(this.type));
            ok = false;
        } else if (YamlElementUtils.isNumberItemType(this.type)) {
            if (!YamlElementUtils.isValidItemDimension(this.dimension)) {
                errors.add("invalid value \"%s\" for \"dimension\" field in group".formatted(this.dimension));
                ok = false;
            }
        } else if (this.dimension != null) {
            warnings.add("\"dimension\" field in group ignored as type is not Number");
        }
        if (!VALID_FUNCTIONS.contains(this.getFunction())) {
            errors.add("invalid value \"%s\" for \"function\" field".formatted(this.function));
            ok = false;
        }
        return ok;
    }

    public @Nullable String getBaseType() {
        return YamlElementUtils.getItemTypeWithDimension(this.type, this.dimension);
    }

    public String getFunction() {
        return this.function != null ? this.function.toUpperCase() : DEFAULT_FUNCTION;
    }

    public int hashCode() {
        return Objects.hash(this.getBaseType(), this.getFunction());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        YamlGroupDTO other = (YamlGroupDTO)obj;
        return Objects.equals(this.getBaseType(), other.getBaseType()) && Objects.equals(this.getFunction(), other.getFunction()) && YamlElementUtils.equalsListStrings(this.parameters, other.parameters);
    }
}

