/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.delay.provider;

import java.io.IOException;
import java.util.Date;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.delay.packet.DelayInformation;

public abstract class AbstractDelayInformationProvider
extends ExtensionElementProvider<DelayInformation> {
    @Override
    public final DelayInformation parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException.SmackTextParseException {
        String reason;
        String stampString = parser2.getAttributeValue("", "stamp");
        String from = parser2.getAttributeValue("", "from");
        XmlPullParser.Event event = parser2.next();
        switch (event) {
            case TEXT_CHARACTERS: {
                reason = parser2.getText();
                parser2.next();
                break;
            }
            case END_ELEMENT: {
                reason = null;
                break;
            }
            default: {
                throw new IOException("Unexpected event: " + (Object)((Object)event));
            }
        }
        Date stamp = this.parseDate(stampString);
        return new DelayInformation(stamp, from, reason);
    }

    protected abstract Date parseDate(String var1) throws SmackParsingException.SmackTextParseException;
}

