/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.XmppElementUtil;

public class NonzaCallback {
    protected final AbstractXMPPConnection connection;
    protected final Map<QName, ClassAndConsumer<? extends Nonza>> filterAndListeners;

    private NonzaCallback(Builder builder2) {
        this.connection = builder2.connection;
        this.filterAndListeners = builder2.filterAndListeners;
        this.install();
    }

    void onNonzaReceived(Nonza nonza) throws IOException {
        QName key = nonza.getQName();
        ClassAndConsumer<? extends Nonza> classAndConsumer = this.filterAndListeners.get(key);
        ((ClassAndConsumer)classAndConsumer).accept(nonza);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        for (Map.Entry<QName, ClassAndConsumer<? extends Nonza>> entry : this.filterAndListeners.entrySet()) {
            QName filterKey = entry.getKey();
            MultiMap<QName, NonzaCallback> multiMap = this.connection.nonzaCallbacksMap;
            synchronized (multiMap) {
                this.connection.nonzaCallbacksMap.removeOne(filterKey, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install() {
        if (this.filterAndListeners.isEmpty()) {
            return;
        }
        for (QName key : this.filterAndListeners.keySet()) {
            MultiMap<QName, NonzaCallback> multiMap = this.connection.nonzaCallbacksMap;
            synchronized (multiMap) {
                this.connection.nonzaCallbacksMap.put(key, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <SN extends Nonza, FN extends Nonza> SN sendAndWaitForResponse(Builder builder2, Nonza nonza, Class<SN> successNonzaClass, Class<FN> failedNonzaClass) throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.FailedNonzaException {
        Nonza successNonza;
        NonzaResponseCallback nonzaCallback = new NonzaResponseCallback(successNonzaClass, failedNonzaClass, builder2);
        try {
            nonzaCallback.connection.sendNonza(nonza);
            successNonza = nonzaCallback.waitForResponse();
        }
        finally {
            nonzaCallback.cancel();
        }
        return (SN)successNonza;
    }

    private static final class ClassAndConsumer<N extends Nonza> {
        private final Class<N> clazz;
        private final NonzaListener<N> consumer;

        private ClassAndConsumer(Class<N> clazz, NonzaListener<N> consumer) {
            this.clazz = clazz;
            this.consumer = consumer;
        }

        private void accept(Object object) throws IOException {
            Nonza nonza = (Nonza)this.clazz.cast(object);
            this.consumer.accept(nonza);
        }
    }

    public static interface NonzaListener<N extends Nonza> {
        public void accept(N var1) throws IOException;
    }

    public static final class Builder {
        private final AbstractXMPPConnection connection;
        private Map<QName, ClassAndConsumer<? extends Nonza>> filterAndListeners = new HashMap<QName, ClassAndConsumer<? extends Nonza>>();

        Builder(AbstractXMPPConnection connection) {
            this.connection = connection;
        }

        public <N extends Nonza> Builder listenFor(Class<N> nonza, NonzaListener<N> nonzaListener) {
            QName key = XmppElementUtil.getQNameFor(nonza);
            ClassAndConsumer classAndConsumer = new ClassAndConsumer(nonza, nonzaListener);
            this.filterAndListeners.put(key, classAndConsumer);
            return this;
        }

        public NonzaCallback install() {
            return new NonzaCallback(this);
        }
    }

    private static final class NonzaResponseCallback<SN extends Nonza, FN extends Nonza>
    extends NonzaCallback {
        private SN successNonza;
        private FN failedNonza;

        private NonzaResponseCallback(Class<SN> successNonzaClass, Class<FN> failedNonzaClass, Builder builder2) {
            super(builder2);
            QName successNonzaKey = XmppElementUtil.getQNameFor(successNonzaClass);
            QName failedNonzaKey = XmppElementUtil.getQNameFor(failedNonzaClass);
            NonzaListener successListener = new NonzaListener<SN>(){

                @Override
                public void accept(SN successNonza) {
                    successNonza = successNonza;
                    this.notifyResponse();
                }
            };
            ClassAndConsumer successClassAndConsumer = new ClassAndConsumer(successNonzaClass, successListener);
            NonzaListener failedListener = new NonzaListener<FN>(){

                @Override
                public void accept(FN failedNonza) {
                    failedNonza = failedNonza;
                    this.notifyResponse();
                }
            };
            ClassAndConsumer failedClassAndConsumer = new ClassAndConsumer(failedNonzaClass, failedListener);
            this.filterAndListeners.put(successNonzaKey, successClassAndConsumer);
            this.filterAndListeners.put(failedNonzaKey, failedClassAndConsumer);
            this.install();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyResponse() {
            NonzaResponseCallback nonzaResponseCallback = this;
            synchronized (nonzaResponseCallback) {
                this.notifyAll();
            }
        }

        private boolean hasReceivedSuccessOrFailedNonza() {
            return this.successNonza != null || this.failedNonza != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SN waitForResponse() throws SmackException.NoResponseException, InterruptedException, XMPPException.FailedNonzaException {
            long deadline = System.currentTimeMillis() + this.connection.getReplyTimeout();
            NonzaResponseCallback nonzaResponseCallback = this;
            synchronized (nonzaResponseCallback) {
                long now;
                while (!this.hasReceivedSuccessOrFailedNonza() && (now = System.currentTimeMillis()) < deadline) {
                    this.wait(deadline - now);
                }
            }
            if (!this.hasReceivedSuccessOrFailedNonza()) {
                throw SmackException.NoResponseException.newWith((XMPPConnection)this.connection, "Nonza Listener");
            }
            if (this.failedNonza != null) {
                throw new XMPPException.FailedNonzaException((Nonza)this.failedNonza);
            }
            assert (this.successNonza != null);
            return this.successNonza;
        }
    }
}

