/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.authentication;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.jdbc.authentication.AuthenticationPlugin;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.util.Options;

public class OldPasswordPlugin
implements AuthenticationPlugin {
    public static final String TYPE = "mysql_old_password";
    private String authenticationData;
    private byte[] seed;

    @Override
    public String name() {
        return "mysql pre 4.1 password encoding";
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void initialize(String authenticationData, byte[] seed, Options options) {
        this.seed = seed;
        this.authenticationData = authenticationData;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException {
        if (this.authenticationData == null || this.authenticationData.isEmpty()) {
            out.writeEmptyPacket(sequence.incrementAndGet());
        } else {
            out.startPacket(sequence.incrementAndGet());
            byte[] seed = Utils.copyWithLength(this.seed, 8);
            out.write(this.cryptOldFormatPassword(this.authenticationData, new String(seed)));
            out.write(0);
            out.flush();
        }
        Buffer buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        return buffer;
    }

    private byte[] cryptOldFormatPassword(String password, String seed) {
        byte[] result = new byte[seed.length()];
        if (password == null || password.length() == 0) {
            return new byte[0];
        }
        long[] seedHash = this.hashPassword(seed);
        long[] passHash = this.hashPassword(password);
        RandStruct randSeed = new RandStruct(seedHash[0] ^ passHash[0], seedHash[1] ^ passHash[1]);
        for (int i = 0; i < seed.length(); ++i) {
            result[i] = (byte)Math.floor(this.random(randSeed) * 31.0 + 64.0);
        }
        byte extra = (byte)Math.floor(this.random(randSeed) * 31.0);
        int i = 0;
        while (i < seed.length()) {
            int n = i++;
            result[n] = (byte)(result[n] ^ extra);
        }
        return result;
    }

    private double random(RandStruct rand) {
        rand.seed1 = (rand.seed1 * 3L + rand.seed2) % 0x3FFFFFFFL;
        rand.seed2 = (rand.seed1 + rand.seed2 + 33L) % 0x3FFFFFFFL;
        return (double)rand.seed1 / 1.073741823E9;
    }

    private long[] hashPassword(String password) {
        long nr = 1345345333L;
        long nr2 = 305419889L;
        long add = 7L;
        for (int i = 0; i < password.length(); ++i) {
            char currChar = password.charAt(i);
            if (currChar == ' ' || currChar == '\t') continue;
            nr ^= ((nr & 0x3FL) + add) * (long)currChar + (nr << 8);
            nr2 += nr2 << 8 ^ nr;
            add += (long)currChar;
        }
        return new long[]{nr & Integer.MAX_VALUE, nr2 & Integer.MAX_VALUE};
    }

    private class RandStruct {
        private final long maxValue = 0x3FFFFFFFL;
        private long seed1;
        private long seed2;

        public RandStruct(long seed1, long seed2) {
            this.seed1 = seed1 % 0x3FFFFFFFL;
            this.seed2 = seed2 % 0x3FFFFFFFL;
        }
    }
}

