/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.net.InetAddress;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.UDPSlaveTerminal;
import net.wimpi.modbus.net.UDPSlaveTerminalFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusUDPListener {
    private static final Logger logger = LoggerFactory.getLogger(ModbusUDPListener.class);
    private UDPSlaveTerminal m_Terminal;
    private ModbusUDPHandler m_Handler;
    private Thread m_HandlerThread;
    private int m_Port = 502;
    private boolean m_Listening;
    private InetAddress m_Interface;
    private UDPSlaveTerminalFactory m_TerminalFactory;

    public ModbusUDPListener() {
        this(null);
    }

    public ModbusUDPListener(InetAddress ifc) {
        this(ifc, new UDPSlaveTerminalFactory(){

            @Override
            public UDPSlaveTerminal create(InetAddress interfac, int port) {
                UDPSlaveTerminal terminal = new UDPSlaveTerminal(interfac);
                terminal.setLocalPort(port);
                return terminal;
            }
        });
    }

    public ModbusUDPListener(InetAddress ifc, UDPSlaveTerminalFactory terminalFactory) {
        this.m_Interface = ifc;
        this.m_TerminalFactory = terminalFactory;
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setPort(int port) {
        this.m_Port = port > 0 ? port : 502;
    }

    public void start() {
        try {
            this.m_Terminal = this.m_TerminalFactory.create(this.m_Interface == null ? InetAddress.getLocalHost() : this.m_Interface, this.m_Port);
            this.m_Terminal.setLocalPort(this.m_Port);
            this.m_Terminal.activate();
            this.m_Handler = new ModbusUDPHandler(this.m_Terminal.getModbusTransport());
            this.m_HandlerThread = new Thread(this.m_Handler);
            this.m_HandlerThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Listening = true;
    }

    public void stop() {
        this.m_Terminal.deactivate();
        this.m_Handler.stop();
        this.m_Listening = false;
    }

    public boolean isListening() {
        return this.m_Listening;
    }

    public int getLocalPort() {
        if (this.m_Terminal == null) {
            return -1;
        }
        return this.m_Terminal.getLocalPort();
    }

    class ModbusUDPHandler
    implements Runnable {
        private ModbusTransport m_Transport;
        private boolean m_Continue = true;

        public ModbusUDPHandler(ModbusTransport transport) {
            this.m_Transport = transport;
        }

        @Override
        public void run() {
            try {
                do {
                    ModbusRequest request = this.m_Transport.readRequest();
                    logger.trace("Request: {}", (Object)request.getHexMessage());
                    ModbusResponse response = null;
                    response = ModbusCoupler.getReference().getProcessImage() == null ? request.createExceptionResponse(1) : request.createResponse();
                    logger.debug("Request: {}", (Object)request.getHexMessage());
                    logger.debug("Response: {}", (Object)response.getHexMessage());
                    this.m_Transport.writeMessage(response);
                } while (this.m_Continue);
            }
            catch (ModbusIOException ex) {
                if (!ex.isEOF()) {
                    ex.printStackTrace();
                }
            }
            finally {
                try {
                    ModbusUDPListener.this.m_Terminal.deactivate();
                }
                catch (Exception exception) {}
            }
        }

        public void stop() {
            this.m_Continue = false;
        }
    }
}

