/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class ChangePropertyCommand
extends Command {
    private final List<OsmPrimitive> objects = new LinkedList<OsmPrimitive>();
    private final Map<String, String> tags;

    public ChangePropertyCommand(DataSet ds, Collection<? extends OsmPrimitive> objects, Map<String, String> tags) {
        super(ds);
        this.tags = tags;
        this.init(objects);
    }

    public ChangePropertyCommand(Collection<? extends OsmPrimitive> objects, Map<String, String> tags) {
        this(objects.iterator().next().getDataSet(), objects, tags);
    }

    public ChangePropertyCommand(Collection<? extends OsmPrimitive> objects, String key, String value) {
        super(objects.iterator().next().getDataSet());
        this.tags = Collections.singletonMap(key, value);
        this.init(objects);
    }

    public ChangePropertyCommand(OsmPrimitive object, String key, String value) {
        this(Collections.singleton(object), key, value);
    }

    private void init(Collection<? extends OsmPrimitive> objects) {
        for (OsmPrimitive osmPrimitive : objects) {
            boolean modified = false;
            for (Map.Entry<String, String> tag : this.tags.entrySet()) {
                String oldVal = osmPrimitive.get(tag.getKey());
                String newVal = tag.getValue();
                if (Utils.isEmpty(newVal)) {
                    if (oldVal == null) continue;
                    modified = true;
                    break;
                }
                if (oldVal != null && newVal.equals(oldVal)) continue;
                modified = true;
                break;
            }
            if (!modified) continue;
            this.objects.add(osmPrimitive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCommand() {
        if (this.objects.isEmpty()) {
            return true;
        }
        DataSet dataSet = this.objects.get(0).getDataSet();
        if (dataSet != null) {
            dataSet.beginUpdate();
        }
        try {
            super.executeCommand();
            for (OsmPrimitive osm : this.objects) {
                for (Map.Entry<String, String> tag : this.tags.entrySet()) {
                    String oldVal = osm.get(tag.getKey());
                    String newVal = tag.getValue();
                    if (Utils.isEmpty(newVal)) {
                        if (oldVal == null) continue;
                        osm.remove(tag.getKey());
                        continue;
                    }
                    if (oldVal != null && newVal.equals(oldVal)) continue;
                    osm.put(tag.getKey(), newVal);
                }
                osm.setModified(true);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (dataSet != null) {
                dataSet.endUpdate();
            }
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.addAll(this.objects);
    }

    @Override
    public String getDescriptionText() {
        String text;
        if (this.objects.size() == 1 && this.tags.size() == 1) {
            OsmPrimitive primitive = this.objects.get(0);
            Map.Entry<String, String> entry = this.tags.entrySet().iterator().next();
            if (Utils.isEmpty(entry.getValue())) {
                String msg;
                switch (OsmPrimitiveType.from(primitive)) {
                    case NODE: {
                        msg = I18n.marktr("Remove \"{0}\" for node ''{1}''");
                        break;
                    }
                    case WAY: {
                        msg = I18n.marktr("Remove \"{0}\" for way ''{1}''");
                        break;
                    }
                    case RELATION: {
                        msg = I18n.marktr("Remove \"{0}\" for relation ''{1}''");
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                text = I18n.tr(msg, entry.getKey(), primitive.getDisplayName(DefaultNameFormatter.getInstance()));
            } else {
                String msg;
                switch (OsmPrimitiveType.from(primitive)) {
                    case NODE: {
                        msg = I18n.marktr("Set {0}={1} for node ''{2}''");
                        break;
                    }
                    case WAY: {
                        msg = I18n.marktr("Set {0}={1} for way ''{2}''");
                        break;
                    }
                    case RELATION: {
                        msg = I18n.marktr("Set {0}={1} for relation ''{2}''");
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                text = I18n.tr(msg, entry.getKey(), entry.getValue(), primitive.getDisplayName(DefaultNameFormatter.getInstance()));
            }
        } else {
            boolean allNull;
            Map.Entry<String, String> entry;
            text = this.objects.size() > 1 && this.tags.size() == 1 ? (Utils.isEmpty((entry = this.tags.entrySet().iterator().next()).getValue()) ? I18n.trn("Remove \"{0}\" for {1} object", "Remove \"{0}\" for {1} objects", this.objects.size(), entry.getKey(), this.objects.size()) : I18n.trn("Set {0}={1} for {2} object", "Set {0}={1} for {2} objects", this.objects.size(), entry.getKey(), entry.getValue(), this.objects.size())) : ((allNull = this.tags.entrySet().stream().allMatch(tag -> Utils.isEmpty((String)tag.getValue()))) ? I18n.trn("Deleted {0} tags for {1} object", "Deleted {0} tags for {1} objects", this.objects.size(), this.tags.size(), this.objects.size()) : I18n.trn("Set {0} tags for {1} object", "Set {0} tags for {1} objects", this.objects.size(), this.tags.size(), this.objects.size()));
        }
        return text;
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("dialogs", "propertiesdialog", ImageProvider.ImageSizes.SMALLICON);
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.objects.size() == 1) {
            return null;
        }
        return this.objects.stream().map(OsmPseudoCommand::new).collect(Collectors.toList());
    }

    public final int getObjectsNumber() {
        return this.objects.size();
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.objects, this.tags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ChangePropertyCommand that = (ChangePropertyCommand)obj;
        return Objects.equals(this.objects, that.objects) && Objects.equals(this.tags, that.tags);
    }

    public static Command build(OsmPrimitive source, Tagged target) {
        String key;
        HashMap<String, String> changedTags = new HashMap<String, String>();
        for (Map.Entry<String, String> tag : source.getKeys().entrySet()) {
            key = tag.getKey();
            String val = target.get(key);
            if (tag.getValue().equals(val)) continue;
            changedTags.put(key, val);
        }
        for (Map.Entry<String, String> tag : target.getKeys().entrySet()) {
            key = tag.getKey();
            if (source.hasTag(key)) continue;
            changedTags.put(key, tag.getValue());
        }
        if (changedTags.isEmpty()) {
            return null;
        }
        if (changedTags.size() == 1) {
            Map.Entry tag = changedTags.entrySet().iterator().next();
            return new ChangePropertyCommand(Collections.singleton(source), (String)tag.getKey(), (String)tag.getValue());
        }
        return new ChangePropertyCommand(Collections.singleton(source), new HashMap<String, String>(changedTags));
    }

    static final class OsmPseudoCommand
    implements PseudoCommand {
        private final OsmPrimitive osm;

        OsmPseudoCommand(OsmPrimitive osm) {
            this.osm = osm;
        }

        @Override
        public String getDescriptionText() {
            return this.osm.getDisplayName(DefaultNameFormatter.getInstance());
        }

        @Override
        public Icon getDescriptionIcon() {
            return ImageProvider.get(this.osm.getDisplayType());
        }

        @Override
        public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
            return Collections.singleton(this.osm);
        }
    }
}

