/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AaptManager;
import brut.androlib.exceptions.AndrolibException;
import brut.util.OS;
import brut.util.OSDetection;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public final class Config {
    public static final String DEFAULT_FRAMEWORK_DIRECTORY;
    public int mJobs = Math.min(Runtime.getRuntime().availableProcessors(), 8);
    public String mFrameworkDirectory = DEFAULT_FRAMEWORK_DIRECTORY;
    public String mFrameworkTag = null;
    public String[] mLibraryFiles = null;
    public boolean mForced = false;
    public boolean mVerbose = false;
    public int mDecodeSources = 2;
    public boolean mBaksmaliDebugMode = true;
    public int mBaksmaliApiLevel = 0;
    public int mDecodeResources = 2;
    public int mDecodeResolve = 1;
    public boolean mAnalysisMode = false;
    public boolean mKeepBrokenResources = false;
    public int mDecodeAssets = 2;
    public boolean mDebugMode = false;
    public boolean mNetSecConf = false;
    public boolean mCopyOriginalFiles = false;
    public boolean mNoCrunch = false;
    public boolean mNoApk = false;
    public File mAaptBinary = null;
    public int mAaptVersion = 2;

    public final void setFrameworkDirectory(String string) {
        if (string == null || string.isEmpty()) {
            string = DEFAULT_FRAMEWORK_DIRECTORY;
        }
        this.mFrameworkDirectory = string;
    }

    public final void setFrameworkTag(String string) {
        if (string == null || string.isEmpty()) {
            string = null;
        }
        this.mFrameworkTag = string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setAaptBinary(File file) {
        int n;
        this.mAaptBinary = file;
        AaptManager.setAaptBinaryExecutable(file);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getPath());
        arrayList.add("version");
        String string = OS.execAndReturn(arrayList.toArray(new String[0]));
        if (string == null) {
            throw new AndrolibException("Could not execute aapt binary at location: " + file.getPath());
        }
        if (string.startsWith("Android Asset Packaging Tool (aapt) 2:") || string.startsWith("Android Asset Packaging Tool (aapt) 2.")) {
            n = 2;
        } else {
            if (!string.startsWith("Android Asset Packaging Tool, v0.")) {
                throw new AndrolibException("aapt version could not be identified: ".concat(string));
            }
            n = 1;
        }
        this.mAaptVersion = n;
    }

    static {
        Path path;
        String[] stringArray;
        String[] stringArray2 = stringArray;
        stringArray = new File(System.getProperty("user.home"));
        String string = OSDetection.OS;
        if (string.contains("mac")) {
            path = Paths.get(stringArray2.getAbsolutePath(), "Library", "apktool", "framework");
        } else if (string.contains("win")) {
            path = Paths.get(stringArray2.getAbsolutePath(), "AppData", "Local", "apktool", "framework");
        } else {
            string = System.getenv("XDG_DATA_HOME");
            if (string != null) {
                String[] stringArray3 = new String[2];
                stringArray2 = stringArray3;
                stringArray3[0] = "apktool";
                stringArray3[1] = "framework";
                path = Paths.get(string, stringArray2);
            } else {
                path = Paths.get(stringArray2.getAbsolutePath(), ".local", "share", "apktool", "framework");
            }
        }
        DEFAULT_FRAMEWORK_DIRECTORY = path.toString();
    }
}

