/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public class URIUtil {
    public static final BitSet ALLOWED = new BitSet(){
        {
            int i = 97;
            while (i <= 122) {
                this.set(i);
                ++i;
            }
            i = 65;
            while (i <= 90) {
                this.set(i);
                ++i;
            }
            i = 48;
            while (i <= 57) {
                this.set(i);
                ++i;
            }
            this.set(33);
            this.set(36);
            this.set(38);
            this.set(39);
            this.set(40);
            this.set(41);
            this.set(42);
            this.set(43);
            this.set(44);
            this.set(59);
            this.set(61);
            this.set(45);
            this.set(46);
            this.set(95);
            this.set(126);
            this.set(58);
            this.set(64);
        }
    };
    public static final BitSet PATH_SEGMENT = new BitSet(){
        {
            this.or(ALLOWED);
            this.clear(59);
        }
    };
    public static final BitSet PATH_PARAM_NAME = new BitSet(){
        {
            this.or(ALLOWED);
            this.clear(59);
            this.clear(61);
        }
    };
    public static final BitSet PATH_PARAM_VALUE = new BitSet(){
        {
            this.or(ALLOWED);
            this.clear(59);
        }
    };
    public static final BitSet QUERY = new BitSet(){
        {
            this.or(ALLOWED);
            this.set(47);
            this.set(63);
            this.clear(61);
            this.clear(38);
            this.clear(43);
        }
    };
    public static final BitSet FRAGMENT = new BitSet(){
        {
            this.or(ALLOWED);
            this.set(47);
            this.set(63);
        }
    };

    public static URI createAbsoluteURI(URI base, String uri) throws IllegalArgumentException {
        return URIUtil.createAbsoluteURI(base, URI.create(uri));
    }

    public static URI createAbsoluteURI(URI base, URI relativeOrNot) throws IllegalArgumentException {
        if (base == null && !relativeOrNot.isAbsolute()) {
            throw new IllegalArgumentException("Base URI is null and given URI is not absolute");
        }
        if (base == null && relativeOrNot.isAbsolute()) {
            return relativeOrNot;
        }
        assert (base != null);
        if (base.getPath().isEmpty()) {
            try {
                base = new URI(base.getScheme(), base.getAuthority(), "/", base.getQuery(), base.getFragment());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return base.resolve(relativeOrNot);
    }

    public static URL createAbsoluteURL(URL base, String uri) throws IllegalArgumentException {
        return URIUtil.createAbsoluteURL(base, URI.create(uri));
    }

    public static URL createAbsoluteURL(URL base, URI relativeOrNot) throws IllegalArgumentException {
        if (base == null && !relativeOrNot.isAbsolute()) {
            throw new IllegalArgumentException("Base URL is null and given URI is not absolute");
        }
        if (base == null && relativeOrNot.isAbsolute()) {
            try {
                return relativeOrNot.toURL();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Base URL was null and given URI can't be converted to URL");
            }
        }
        try {
            assert (base != null);
            URI baseURI = base.toURI();
            URI absoluteURI = URIUtil.createAbsoluteURI(baseURI, relativeOrNot);
            return absoluteURI.toURL();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Base URL is not an URI, or can't create absolute URI (null?), or absolute URI can not be converted to URL", e);
        }
    }

    public static URL createAbsoluteURL(URI base, URI relativeOrNot) throws IllegalArgumentException {
        try {
            return URIUtil.createAbsoluteURI(base, relativeOrNot).toURL();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Absolute URI can not be converted to URL", e);
        }
    }

    public static URL createAbsoluteURL(InetAddress address, int localStreamPort, URI relativeOrNot) throws IllegalArgumentException {
        try {
            if (address instanceof Inet6Address) {
                return URIUtil.createAbsoluteURL(new URL("http://[" + address.getHostAddress() + "]:" + localStreamPort), relativeOrNot);
            }
            if (address instanceof Inet4Address) {
                return URIUtil.createAbsoluteURL(new URL("http://" + address.getHostAddress() + ":" + localStreamPort), relativeOrNot);
            }
            throw new IllegalArgumentException("InetAddress is neither IPv4 nor IPv6: " + String.valueOf(address));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Address, port, and URI can not be converted to URL", e);
        }
    }

    public static URI createRelativePathURI(URI uri) {
        int idx;
        URIUtil.assertRelativeURI("Given", uri);
        URI normalizedURI = uri.normalize();
        Object uriString = normalizedURI.toString();
        while ((idx = ((String)uriString).indexOf("../")) != -1) {
            uriString = ((String)uriString).substring(0, idx) + ((String)uriString).substring(idx + 3);
        }
        while (((String)uriString).startsWith("/")) {
            uriString = ((String)uriString).substring(1);
        }
        return URI.create((String)uriString);
    }

    public static URI createRelativeURI(URI base, URI full) {
        return base.relativize(full);
    }

    public static URI createRelativeURI(URL base, URL full) throws IllegalArgumentException {
        try {
            return URIUtil.createRelativeURI(base.toURI(), full.toURI());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't convert base or full URL to URI", e);
        }
    }

    public static URI createRelativeURI(URI base, URL full) throws IllegalArgumentException {
        try {
            return URIUtil.createRelativeURI(base, full.toURI());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't convert full URL to URI", e);
        }
    }

    public static URI createRelativeURI(URL base, URI full) throws IllegalArgumentException {
        try {
            return URIUtil.createRelativeURI(base.toURI(), full);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't convert base URL to URI", e);
        }
    }

    public static boolean isAbsoluteURI(String s) {
        URI uri = URI.create(s);
        return uri.isAbsolute();
    }

    public static void assertRelativeURI(String what, URI uri) {
        if (uri.isAbsolute()) {
            throw new IllegalArgumentException(what + " URI must be relative, without scheme and authority");
        }
    }

    public static URL toURL(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI toURI(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String percentEncode(String s) {
        return s == null ? "" : URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    public static String percentDecode(String s) {
        return s == null ? "" : URLDecoder.decode(s, StandardCharsets.UTF_8);
    }

    public static String encodePathSegment(String pathSegment) {
        return URIUtil.encode(PATH_SEGMENT, pathSegment, "UTF-8");
    }

    public static String encodePathParamName(String pathParamName) {
        return URIUtil.encode(PATH_PARAM_NAME, pathParamName, "UTF-8");
    }

    public static String encodePathParamValue(String pathParamValue) {
        return URIUtil.encode(PATH_PARAM_VALUE, pathParamValue, "UTF-8");
    }

    public static String encodeQueryNameOrValue(String queryNameOrValue) {
        return URIUtil.encode(QUERY, queryNameOrValue, "UTF-8");
    }

    public static String encodeFragment(String fragment) {
        return URIUtil.encode(FRAGMENT, fragment, "UTF-8");
    }

    public static String encode(BitSet allowedCharacters, String s, String charset) {
        if (s == null) {
            return null;
        }
        StringBuilder encoded = new StringBuilder(s.length() * 3);
        char[] characters = s.toCharArray();
        try {
            char[] cArray = characters;
            int n = characters.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (allowedCharacters.get(c)) {
                    encoded.append(c);
                } else {
                    byte[] bytes;
                    byte[] byArray = bytes = String.valueOf(c).getBytes(charset);
                    int n3 = bytes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        byte b = byArray[n4];
                        encoded.append(String.format("%%%1$02X", b & 0xFF));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return encoded.toString();
    }
}

