/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.UnsupportedAudioFormatException;
import org.openhab.core.audio.UnsupportedAudioStreamException;
import org.openhab.core.library.types.PercentType;

@NonNullByDefault
public interface AudioSink {
    public String getId();

    public @Nullable String getLabel(@Nullable Locale var1);

    @Deprecated
    public void process(@Nullable AudioStream var1) throws UnsupportedAudioFormatException, UnsupportedAudioStreamException;

    default public CompletableFuture<@Nullable Void> processAndComplete(@Nullable AudioStream audioStream) {
        try {
            this.process(audioStream);
        }
        catch (UnsupportedAudioFormatException | UnsupportedAudioStreamException e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFuture.completedFuture(null);
    }

    public Set<AudioFormat> getSupportedFormats();

    public Set<Class<? extends AudioStream>> getSupportedStreams();

    public PercentType getVolume() throws IOException;

    public void setVolume(PercentType var1) throws IOException;
}

