/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPFieldFloat;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPNumericArray;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldArrayFloat
extends JBBPAbstractArrayField<JBBPFieldFloat>
implements JBBPNumericArray {
    private static final long serialVersionUID = 6839868800303265190L;
    private final float[] array;

    public JBBPFieldArrayFloat(JBBPNamedFieldInfo name, float[] array) {
        super(name);
        JBBPUtils.assertNotNull(array, "Array must not be null");
        this.array = array;
    }

    public float[] getArray() {
        return (float[])this.array.clone();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public JBBPFieldFloat getElementAt(int index) {
        JBBPFieldFloat result = new JBBPFieldFloat(this.fieldNameInfo, this.array[index]);
        result.payload = this.payload;
        return result;
    }

    @Override
    public int getAsInt(int index) {
        return Math.round(this.array[index]);
    }

    public float getAsFloat(int index) {
        return this.array[index];
    }

    @Override
    public long getAsLong(int index) {
        return this.getAsInt(index);
    }

    @Override
    public boolean getAsBool(int index) {
        return this.array[index] != 0.0f;
    }

    @Override
    public Object getValueArrayAsObject(boolean reverseBits) {
        float[] result;
        if (reverseBits) {
            result = (float[])this.array.clone();
            for (int i = 0; i < result.length; ++i) {
                result[i] = Float.intBitsToFloat((int)JBBPFieldInt.reverseBits(Float.floatToIntBits(result[i])));
            }
        } else {
            result = (float[])this.array.clone();
        }
        return result;
    }

    @Override
    public String getTypeAsString() {
        return "floatj [" + this.array.length + ']';
    }
}

