/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler.conversion;

import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.conversion.CompiledBlockVisitor;
import com.igormaznitsa.jbbp.compiler.conversion.ExpressionEvaluatorVisitor;
import com.igormaznitsa.jbbp.compiler.conversion.IntConstValueEvaluator;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPIntegerValueEvaluator;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.utils.JavaSrcTextBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class JBBPToJava6Converter
extends CompiledBlockVisitor {
    private static final int FLAG_DETECTED_CUSTOM_FIELDS = 1;
    private static final int FLAG_DETECTED_EXTERNAL_FIELDS = 2;
    private static final int FLAG_DETECTED_VAR_FIELDS = 4;
    private static final int FLAG_ADD_ASSERT_NOT_NEGATIVE_EXPR = 8;
    private static final Set<String> RESERVED_JAVA_KEYWORDS;
    private static final String NAME_ROOT_STRUCT = "_Root_";
    private static final String NAME_PARSER_FLAGS = "_ParserFlags_";
    private static final String NAME_INPUT_STREAM = "In";
    private static final String NAME_OUTPUT_STREAM = "Out";
    private final AtomicInteger flagSet = new AtomicInteger();
    private final Map<JBBPNamedFieldInfo, NamedFieldInfo> foundNamedFields = new HashMap<JBBPNamedFieldInfo, NamedFieldInfo>();
    private final AtomicInteger anonymousFieldCounter = new AtomicInteger();
    private final AtomicInteger specialFieldsCounter = new AtomicInteger();
    private final List<Struct> structStack = new ArrayList<Struct>();
    private final JavaSrcTextBuffer specialSection = new JavaSrcTextBuffer();
    private final JavaSrcTextBuffer specialMethods = new JavaSrcTextBuffer();
    private final Builder builder;
    private String result;

    private JBBPToJava6Converter(Builder builder) {
        super(builder.parserFlags, builder.srcParser.getCompiledBlock());
        this.builder = builder;
    }

    public static Builder makeBuilder(JBBPParser parser) {
        return new Builder(parser);
    }

    public String convert() {
        return ((JBBPToJava6Converter)JBBPToJava6Converter.class.cast(this.visit())).getResult();
    }

    private void registerNamedField(JBBPNamedFieldInfo fieldInfo, FieldType fieldType) {
        if (fieldInfo != null) {
            if (this.foundNamedFields.containsKey(fieldInfo)) {
                throw new Error("Detected duplication of named field : " + fieldInfo);
            }
            this.foundNamedFields.put(fieldInfo, new NamedFieldInfo(fieldInfo, this.getCurrentStruct(), fieldType));
        }
    }

    private Struct getCurrentStruct() {
        return this.structStack.get(0);
    }

    @Override
    public void visitStart() {
        this.flagSet.set(0);
        this.foundNamedFields.clear();
        this.anonymousFieldCounter.set(1234);
        this.specialFieldsCounter.set(1);
        this.specialSection.clean();
        this.structStack.clear();
        this.specialMethods.clean();
        this.structStack.add(new Struct(null, this.builder.mainClassName, "public"));
    }

    public String getResult() {
        return this.result;
    }

    @Override
    public void visitEnd() {
        JavaSrcTextBuffer buffer = new JavaSrcTextBuffer();
        if (this.builder.headComment != null) {
            buffer.printCommentMultiLinesWithIndent(this.builder.headComment);
        }
        if (this.builder.mainClassPackage != null && this.builder.mainClassPackage.length() != 0) {
            buffer.print("package ").print(this.builder.mainClassPackage).println(";");
        }
        buffer.println();
        buffer.println("import com.igormaznitsa.jbbp.model.*;");
        buffer.println("import com.igormaznitsa.jbbp.io.*;");
        buffer.println("import com.igormaznitsa.jbbp.compiler.*;");
        buffer.println("import com.igormaznitsa.jbbp.compiler.tokenizer.*;");
        buffer.println("import java.io.IOException;");
        buffer.println("import java.util.*;");
        buffer.println();
        this.specialSection.println();
        this.specialSection.printJavaDocLinesWithIndent("The Constant contains parser flags\n@see JBBPParser#FLAG_SKIP_REMAINING_FIELDS_IF_EOF\n@see JBBPParser#FLAG_NEGATIVE_EXPRESSION_RESULT_AS_ZERO");
        this.specialSection.indent().printf("protected static final int %s = %d;", NAME_PARSER_FLAGS, this.parserFlags);
        int detected = this.flagSet.get();
        if ((detected & 1) != 0) {
            this.specialMethods.printJavaDocLinesWithIndent("Reading of custom fields\n@param sourceStruct source structure holding the field, must not be null\n@param inStream the input stream, must not be null\n@param typeParameterContainer info about field type, must not be null\n@param nullableNamedFieldInfo info abut field name, it can be null\n@param extraValue value from extra field part, default value 0\n@param readWholeStream flag to read the stream as array till the stream end if true\n@param arraySize if array then it is zero or great\n@exception IOException if data can't be read\n@return read value as abstract field, must not be null");
            this.specialMethods.println("public abstract JBBPAbstractField readCustomFieldType(Object sourceStruct, JBBPBitInputStream inStream, JBBPFieldTypeParameterContainer typeParameterContainer, JBBPNamedFieldInfo nullableNamedFieldInfo, int extraValue, boolean readWholeStream, int arraySize) throws IOException;");
            this.specialMethods.println();
            this.specialMethods.printJavaDocLinesWithIndent("Writing custom fields\n@param sourceStruct source structure holding the field, must not be null\n@param outStream the output stream, must not be null\n@param fieldValue value to be written\n@param typeParameterContainer info about field type, must not be null\n@param nullableNamedFieldInfo info abut field name, it can be null\n@param extraValue value from extra field part, default value is 0\n@param wholeArray true if to write whole array\n@param arraySize if array then it is zero or great\n@exception IOException if data can't be written");
            this.specialMethods.println("public abstract void writeCustomFieldType(Object sourceStruct, JBBPBitOutputStream outStream, JBBPAbstractField fieldValue, JBBPFieldTypeParameterContainer typeParameterContainer, JBBPNamedFieldInfo nullableNamedFieldInfo, int extraValue, boolean wholeArray, int arraySize) throws IOException;");
        }
        if ((detected & 2) != 0) {
            if (!this.specialMethods.isEmpty()) {
                this.specialMethods.println();
            }
            this.specialMethods.printJavaDocLinesWithIndent("Method is called from expressions to provide value\n@param sourceStruct source structure holding the field, must not be null\n@param valueName name of value to be provided, must not be null\n@return integer value for the named parameter");
            this.specialMethods.println("public abstract int getNamedValue(Object sourceStruct, String valueName);");
        }
        if ((detected & 4) != 0) {
            if (!this.specialMethods.isEmpty()) {
                this.specialMethods.println();
            }
            this.specialMethods.printJavaDocLinesWithIndent("Read variable field\n@param sourceStruct source structure holding the field, must not be null\n@param inStream the input stream, must not be null\n@param byteOrder\n@param nullableNamedFieldInfo info abut field name, it can be null\n@param extraValue value from extra field part, -1 if not defined\n@return\n@exception IOException");
            this.specialMethods.println("public abstract JBBPAbstractField readVarField(Object sourceStruct, JBBPBitInputStream inStream, JBBPByteOrder byteOrder, JBBPNamedFieldInfo nullableNamedFieldInfo, int extraValue) throws IOException;");
            this.specialMethods.println();
            this.specialMethods.printJavaDocLinesWithIndent("Read variable array field\n@param sourceStruct source structure holding the field, must not be null\n@param inStream the input stream, must not be null\n@param byteOrder byte order to be used for reading, must not be null\n@param nullableNamedFieldInfo info abut field name, it can be null\n@param extraValue value from extra field part, -1 if not defined\n@param readWholeStream if true then whole stream should be read\n@param arraySize size of array to read (if whole stream flag is false)\n@return array object contains read data, must not be null\n@exception IOException if error during data reading");
            this.specialMethods.println("public abstract JBBPAbstractArrayField<? extends JBBPAbstractField> readVarArray(Object sourceStruct, JBBPBitInputStream inStream, JBBPByteOrder byteOrder, JBBPNamedFieldInfo nullableNamedFieldInfo, int extraValue, boolean readWholeStream, int arraySize) throws IOException;");
            this.specialMethods.println();
            this.specialMethods.printJavaDocLinesWithIndent("Read variable field\n@param sourceStruct source structure holding the field, must not be null\n@param value field value, must not be null\n@param outStream the output stream, must not be null,\n@param byteOrder byte order to be used for reading, must not be null\n@param nullableNamedFieldInfo info abut field name, it can be null\n@param extraValue value from extra field part, -1 if not defined\n@exception IOException  it is thrown if any transport error during operation");
            this.specialMethods.println("public abstract void writeVarField(Object sourceStruct, JBBPAbstractField value, JBBPBitOutputStream outStream, JBBPByteOrder byteOrder, JBBPNamedFieldInfo nullableNamedFieldInfo, int extraValue) throws IOException;");
            this.specialMethods.println();
            this.specialMethods.printJavaDocLinesWithIndent("Write variable array\n@param sourceStruct source structure holding the field, must not be null\n@param array array value to be written, must not be null\n@param outStream the output stream, must not be null\n@param byteOrder byte order to be used for reading, must not be null\n@param nullableNamedFieldInfo info abut field name, it can be null\n@param extraValue value from extra field part, -1 if not defined\n@param arraySizeToWrite\n@exception IOException it is thrown if any transport error during operation");
            this.specialMethods.println("public abstract void writeVarArray(Object sourceStruct, JBBPAbstractArrayField<? extends JBBPAbstractField> array, JBBPBitOutputStream outStream, JBBPByteOrder byteOrder, JBBPNamedFieldInfo nullableNamedFieldInfo, int extraValue, int arraySizeToWrite) throws IOException;");
        }
        if ((detected & 8) != 0) {
            if (!this.specialMethods.isEmpty()) {
                this.specialMethods.println();
            }
            this.specialMethods.println("private static int assrtExprNotNeg(final int value) { if (value<0) throw new IllegalArgumentException(\"Negative value in expression\"); return value; }");
        }
        String specialMethodsText = this.specialMethods.toString();
        boolean hasAbstractMethods = (this.flagSet.get() & 7) != 0 || this.builder.doMainClassAbstract;
        buffer.printJavaDocLinesWithIndent("Generated from JBBP script by internal JBBP Class Source Generator");
        this.structStack.get(0).write(buffer, hasAbstractMethods ? "abstract" : null, this.builder.superClass, this.builder.mainClassImplements, this.builder.mapSubClassesInterfaces, this.builder.mapSubClassesSuperclasses, this.specialSection.toString(), specialMethodsText.length() == 0 ? null : specialMethodsText, this.builder.mainClassCustomText, true);
        this.result = buffer.toString();
    }

    @Override
    public void visitStructureStart(int offsetInCompiledBlock, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPIntegerValueEvaluator nullableArraySize) {
        String structType;
        String structName = (nullableNameFieldInfo == null ? this.makeAnonymousStructName() : this.prepFldName(nullableNameFieldInfo.getFieldName())).toLowerCase(Locale.ENGLISH);
        String structBaseTypeName = structName.toUpperCase(Locale.ENGLISH);
        String arraySizeIn = nullableArraySize == null ? null : this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, nullableArraySize, this.flagSet, true);
        String arraySizeOut = nullableArraySize == null ? null : this.evaluatorToString(NAME_OUTPUT_STREAM, offsetInCompiledBlock, nullableArraySize, this.flagSet, true);
        Struct newStruct = new Struct(this.getCurrentStruct(), structBaseTypeName, "public" + (this.builder.internalClassesNotStatic ? "" : " static"));
        String fieldModifier = this.makeModifier(nullableNameFieldInfo);
        String toType = this.builder.generateFields ? "" : '(' + structBaseTypeName + ')';
        if (nullableArraySize == null) {
            structType = structBaseTypeName;
            if (this.builder.generateFields) {
                this.getCurrentStruct().getFields().indent().print(fieldModifier).printf(" %s %s;", structType, structName).println();
            }
            this.processSkipRemainingFlag();
            this.processSkipRemainingFlagForWriting("this." + structName);
            this.getCurrentStruct().getReadFunc().indent().printf("if ( this.%1$s == null) { this.%1$s = new %2$s(%3$s);}", structName, structType, this.structStack.size() == 1 ? "this" : "this._Root_").printf(" %s.read(%s);%n", toType.length() == 0 ? "this." + structName : '(' + toType + "this." + structName + ')', NAME_INPUT_STREAM);
            this.getCurrentStruct().getWriteFunc().indent().print(toType.length() == 0 ? structName : '(' + toType + structName + ')').println(".write(Out);");
        } else {
            structType = structBaseTypeName + " []";
            if (this.builder.generateFields) {
                this.getCurrentStruct().getFields().indent().print(fieldModifier).printf(" %s %s;", structType, structName).println();
            }
            this.processSkipRemainingFlag();
            this.processSkipRemainingFlagForWriting("this." + structName);
            if ("-1".equals(arraySizeIn)) {
                this.getCurrentStruct().getReadFunc().indent().printf("List<%3$s> __%1$s_tmplst__ = new ArrayList<%3$s>(); while (%5$s.hasAvailableData()){ __%1$s_tmplst__.add(new %3$s(%4$s).read(%5$s));} this.%1$s = __%1$s_tmplst__.toArray(new %3$s[__%1$s_tmplst__.size()]);__%1$s_tmplst__ = null;%n", structName, arraySizeIn, structBaseTypeName, this.structStack.size() == 1 ? "this" : NAME_ROOT_STRUCT, NAME_INPUT_STREAM);
                this.getCurrentStruct().getWriteFunc().indent().printf("for (int I=0;I<this.%1$s.length;I++){ %2$s.write(%3$s); }%n", structName, toType.length() == 0 ? "this." + structName + "[I]" : '(' + toType + "this." + structName + "[I])", NAME_OUTPUT_STREAM);
            } else {
                this.getCurrentStruct().getReadFunc().indent().printf("if (this.%1$s == null || this.%1$s.length != %2$s){ this.%1$s = new %3$s[%2$s]; for(int I=0;I<%2$s;I++){ this.%1$s[I] = new %3$s(%4$s);}}", structName, arraySizeIn, structBaseTypeName, this.structStack.size() == 1 ? "this" : "this._Root_").printf("for (int I=0;I<%2$s;I++){ this.%1$s[I].read(%3$s); }%n", toType + structName, arraySizeIn, NAME_INPUT_STREAM);
                this.getCurrentStruct().getWriteFunc().indent().printf("for (int I=0;I<%2$s;I++){ this.%1$s[I].write(%3$s); }", toType + structName, arraySizeOut, NAME_OUTPUT_STREAM);
            }
        }
        if (nullableNameFieldInfo != null && this.builder.addGettersSetters) {
            String interfaceForGetter = (String)this.builder.mapSubClassesInterfaces.get(newStruct.getPath());
            this.registerGetterSetter(interfaceForGetter == null ? structType : interfaceForGetter + (nullableArraySize == null ? "" : " []"), structName, false);
        }
        this.structStack.add(0, newStruct);
    }

    private void processSkipRemainingFlag() {
        if (this.isFlagSkipRemainingFieldsIfEOF()) {
            this.getCurrentStruct().getReadFunc().indent().println(String.format("if (!%s.hasAvailableData()) return this;", NAME_INPUT_STREAM));
        }
    }

    private void processSkipRemainingFlagForWriting(String structFieldName) {
        if (this.isFlagSkipRemainingFieldsIfEOF()) {
            this.getCurrentStruct().getWriteFunc().indent().println(String.format("if (%s == null) return this;", structFieldName));
        }
    }

    private String prepFldName(String fieldName) {
        String result = fieldName;
        if (RESERVED_JAVA_KEYWORDS.contains(fieldName)) {
            result = '_' + result;
        } else if (fieldName.startsWith("_")) {
            if (fieldName.endsWith("_")) {
                String withoutUnderscores = fieldName.substring(1, fieldName.length() - 1);
                if (RESERVED_JAVA_KEYWORDS.contains(withoutUnderscores)) {
                    result = '_' + result + this.anonymousFieldCounter.incrementAndGet() + '_';
                }
            } else {
                String withoutUnderscore = fieldName.substring(1);
                if (RESERVED_JAVA_KEYWORDS.contains(withoutUnderscore)) {
                    result = result + '_';
                }
            }
        }
        return result;
    }

    @Override
    public void visitStructureEnd(int offsetInCompiledBlock, JBBPNamedFieldInfo nullableNameFieldInfo) {
        this.structStack.remove(0);
    }

    @Override
    public void visitValField(int offsetInCompiledBlock, JBBPNamedFieldInfo nameFieldInfo, JBBPIntegerValueEvaluator expression) {
        String fieldName = this.prepFldName(nameFieldInfo.getFieldName());
        FieldType type = FieldType.VAL;
        this.registerNamedField(nameFieldInfo, type);
        String fieldModifier = this.makeModifier(nameFieldInfo);
        this.processSkipRemainingFlag();
        String textFieldType = type.asJavaSingleFieldType();
        if (this.builder.generateFields) {
            this.getCurrentStruct().getFields().printf("%s %s %s;%n", fieldModifier, textFieldType, fieldName);
        }
        String valIn = this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, expression, this.flagSet, false);
        String valOut = this.evaluatorToString(NAME_OUTPUT_STREAM, offsetInCompiledBlock, expression, this.flagSet, false);
        this.getCurrentStruct().getReadFunc().println(String.format("this.%s = %s;", fieldName, valIn));
        this.getCurrentStruct().getWriteFunc().println(String.format("this.%s = %s;", fieldName, valOut));
        if (this.builder.addGettersSetters) {
            this.registerGetterSetter(textFieldType, fieldName, true);
        }
    }

    @Override
    public void visitPrimitiveField(int offsetInCompiledBlock, int primitiveType, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPByteOrder byteOrder, boolean readWholeStreamAsArray, boolean altFieldType, JBBPIntegerValueEvaluator nullableArraySize) {
        String textFieldType;
        String fieldName = nullableNameFieldInfo == null ? this.makeAnonymousFieldName() : this.prepFldName(nullableNameFieldInfo.getFieldName());
        FieldType type = FieldType.findForCode(primitiveType);
        if (altFieldType) {
            switch (type) {
                case INT: {
                    type = FieldType.FLOAT;
                    break;
                }
                case LONG: {
                    type = FieldType.DOUBLE;
                    break;
                }
                case BOOL: {
                    type = FieldType.STRING;
                    break;
                }
                default: {
                    throw new Error("Unexpected type : " + (Object)((Object)type));
                }
            }
        }
        this.registerNamedField(nullableNameFieldInfo, type);
        String arraySizeIn = nullableArraySize == null ? null : this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, nullableArraySize, this.flagSet, true);
        String arraySizeOut = nullableArraySize == null ? null : this.evaluatorToString(NAME_OUTPUT_STREAM, offsetInCompiledBlock, nullableArraySize, this.flagSet, true);
        String fieldModifier = this.makeModifier(nullableNameFieldInfo);
        this.processSkipRemainingFlag();
        if (nullableArraySize == null) {
            textFieldType = type.asJavaSingleFieldType();
            if (this.builder.generateFields) {
                this.getCurrentStruct().getFields().printf("%s %s %s;%n", fieldModifier, textFieldType, fieldName);
            }
            this.getCurrentStruct().getReadFunc().println(String.format("this.%s = %s;", fieldName, type.makeReaderForSingleField(NAME_INPUT_STREAM, byteOrder)));
            this.getCurrentStruct().getWriteFunc().print(type.makeWriterForSingleField(NAME_OUTPUT_STREAM, "this." + fieldName, byteOrder)).println(";");
        } else {
            textFieldType = type.asJavaArrayFieldType() + " []";
            if (this.builder.generateFields) {
                this.getCurrentStruct().getFields().printf("%s %s %s;%n", fieldModifier, textFieldType, fieldName);
            }
            this.getCurrentStruct().getReadFunc().printf("this.%s = %s;%n", fieldName, type.makeReaderForArray(NAME_INPUT_STREAM, arraySizeIn, byteOrder));
            if (readWholeStreamAsArray) {
                this.getCurrentStruct().getWriteFunc().print(type.makeWriterForArrayWithUnknownSize(NAME_OUTPUT_STREAM, "this." + fieldName, byteOrder)).println(";");
            } else {
                this.getCurrentStruct().getWriteFunc().print(type.makeWriterForArray(NAME_OUTPUT_STREAM, "this." + fieldName, arraySizeOut, byteOrder)).println(";");
            }
        }
        if (nullableNameFieldInfo != null && this.builder.addGettersSetters) {
            this.registerGetterSetter(textFieldType, fieldName, true);
        }
    }

    private void registerGetterSetter(String fieldType, String fieldName, boolean makeSetter) {
        if (!this.getCurrentStruct().getGettersSetters().isEmpty()) {
            this.getCurrentStruct().getGettersSetters().println();
        }
        if (makeSetter) {
            this.getCurrentStruct().getGettersSetters().indent().printf("public void set%s(%s value) { this.%s = value;}%n", fieldName.toUpperCase(Locale.ENGLISH), fieldType, fieldName);
        }
        this.getCurrentStruct().getGettersSetters().indent().printf("public %s get%s() { return this.%s;}%n", fieldType, fieldName.toUpperCase(Locale.ENGLISH), fieldName);
    }

    @Override
    public void visitBitField(int offsetInCompiledBlock, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPIntegerValueEvaluator notNullFieldSize, JBBPIntegerValueEvaluator nullableArraySize) {
        String fieldType;
        String fieldName = nullableNameFieldInfo == null ? this.makeAnonymousFieldName() : this.prepFldName(nullableNameFieldInfo.getFieldName());
        this.registerNamedField(nullableNameFieldInfo, FieldType.BIT);
        String sizeOfFieldIn = this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, notNullFieldSize, this.flagSet, true);
        String sizeOfFieldOut = this.evaluatorToString(NAME_OUTPUT_STREAM, offsetInCompiledBlock, notNullFieldSize, this.flagSet, true);
        try {
            sizeOfFieldIn = "JBBPBitNumber." + JBBPBitNumber.decode(Integer.parseInt(sizeOfFieldIn)).name();
        }
        catch (NumberFormatException ex) {
            sizeOfFieldIn = "JBBPBitNumber.decode(" + sizeOfFieldIn + ')';
        }
        try {
            sizeOfFieldOut = "JBBPBitNumber." + JBBPBitNumber.decode(Integer.parseInt(sizeOfFieldOut)).name();
        }
        catch (NumberFormatException ex) {
            sizeOfFieldOut = "JBBPBitNumber.decode(" + sizeOfFieldOut + ')';
        }
        String arraySizeIn = nullableArraySize == null ? null : this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, nullableArraySize, this.flagSet, true);
        String arraySizeOut = nullableArraySize == null ? null : this.evaluatorToString(NAME_OUTPUT_STREAM, offsetInCompiledBlock, nullableArraySize, this.flagSet, true);
        String fieldModifier = this.makeModifier(nullableNameFieldInfo);
        this.processSkipRemainingFlag();
        if (arraySizeIn == null) {
            this.getCurrentStruct().getReadFunc().indent().printf("this.%s = In.readBitField(%s);%n", fieldName, sizeOfFieldIn);
        } else {
            this.getCurrentStruct().getReadFunc().indent().print(fieldName).print(" = In.readBitsArray(").print(arraySizeIn).print(",").print(sizeOfFieldIn).println(");");
        }
        if (arraySizeOut == null) {
            this.getCurrentStruct().getWriteFunc().indent().printf("%s.writeBits(this.%s,%s);%n", NAME_OUTPUT_STREAM, fieldName, sizeOfFieldOut);
        } else if ("-1".equals(arraySizeIn)) {
            this.getCurrentStruct().getWriteFunc().indent().printf("for(int I=0; I<%s.length; I++)", fieldName).printf(" Out.writeBits(this.%s[I],%s);%n", fieldName, sizeOfFieldOut);
        } else {
            this.getCurrentStruct().getWriteFunc().indent().printf("for(int I=0; I<%s; I++)", arraySizeOut).printf(" Out.writeBits(this.%s[I],%s);%n", fieldName, sizeOfFieldOut);
        }
        String string = fieldType = nullableArraySize == null ? "byte" : "byte []";
        if (this.builder.generateFields) {
            this.getCurrentStruct().getFields().indent().printf("%s %s %s;%n", fieldModifier, fieldType, fieldName);
        }
        if (nullableNameFieldInfo != null && this.builder.addGettersSetters) {
            this.registerGetterSetter(fieldType, fieldName, true);
        }
    }

    private String makeAnonymousFieldName() {
        return "_AField" + this.anonymousFieldCounter.getAndIncrement();
    }

    private String makeSpecialFieldName() {
        return "_SField" + this.specialFieldsCounter.getAndIncrement();
    }

    private String makeAnonymousStructName() {
        return "_AStruct" + this.anonymousFieldCounter.getAndIncrement();
    }

    private String makeModifier(JBBPNamedFieldInfo nullableNameFieldInfo) {
        return nullableNameFieldInfo == null || this.builder.addGettersSetters ? "protected" : "public";
    }

    @Override
    public void visitCustomField(int offsetInCompiledBlock, JBBPFieldTypeParameterContainer notNullFieldType, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPByteOrder byteOrder, boolean readWholeStream, JBBPIntegerValueEvaluator nullableArraySizeEvaluator, JBBPIntegerValueEvaluator extraDataValueEvaluator) {
        this.flagSet.set(this.flagSet.get() | 1);
        this.registerNamedField(nullableNameFieldInfo, FieldType.CUSTOM);
        String fieldName = nullableNameFieldInfo == null ? this.makeAnonymousFieldName() : this.prepFldName(nullableNameFieldInfo.getFieldName());
        String fieldModifier = this.makeModifier(nullableNameFieldInfo);
        String specialFieldName = this.makeSpecialFieldName();
        String specialFieldName_fieldNameInfo = specialFieldName + "FieldInfo";
        String specialFieldName_typeParameterContainer = specialFieldName + "TypeParameter";
        if (this.builder.generateFields) {
            this.getCurrentStruct().getFields().printf("%s JBBPAbstractField %s;%n", fieldModifier, fieldName);
        }
        if (nullableNameFieldInfo != null) {
            this.specialSection.printf("private static final JBBPNamedFieldInfo %s = %s;%n", specialFieldName_fieldNameInfo, "new JBBPNamedFieldInfo(\"" + this.prepFldName(nullableNameFieldInfo.getFieldName()) + "\",\"" + nullableNameFieldInfo.getFieldPath() + "\"," + nullableNameFieldInfo.getFieldOffsetInCompiledBlock() + ")");
        }
        this.specialSection.printf("private static final JBBPFieldTypeParameterContainer %s = %s;%n", specialFieldName_typeParameterContainer, "new JBBPFieldTypeParameterContainer(JBBPByteOrder." + notNullFieldType.getByteOrder().name() + ",\"" + notNullFieldType.getTypeName() + "\"," + (notNullFieldType.getExtraData() == null ? "null" : "\"" + notNullFieldType.getExtraData() + "\"") + ")");
        this.processSkipRemainingFlag();
        this.getCurrentStruct().getReadFunc().printf("%s = %s;%n", fieldName, String.format("%s.readCustomFieldType(this, In, %s, %s, %s, %b, %s)", this.getCurrentStruct().isRoot() ? "this" : "this._Root_", specialFieldName_typeParameterContainer, nullableNameFieldInfo == null ? "null" : specialFieldName_fieldNameInfo, extraDataValueEvaluator == null ? "0" : this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, extraDataValueEvaluator, this.flagSet, true), readWholeStream, nullableArraySizeEvaluator == null ? "-1" : this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, nullableArraySizeEvaluator, this.flagSet, true)));
        this.getCurrentStruct().getWriteFunc().printf("%s;%n", String.format("%s.writeCustomFieldType(this, Out, %s, %s, %s, %s, %b, %s)", this.getCurrentStruct().isRoot() ? "this" : "this._Root_", "this." + fieldName, specialFieldName_typeParameterContainer, nullableNameFieldInfo == null ? "null" : specialFieldName_fieldNameInfo, extraDataValueEvaluator == null ? "0" : this.evaluatorToString(NAME_OUTPUT_STREAM, offsetInCompiledBlock, extraDataValueEvaluator, this.flagSet, true), readWholeStream, nullableArraySizeEvaluator == null ? "-1" : this.evaluatorToString(NAME_OUTPUT_STREAM, offsetInCompiledBlock, nullableArraySizeEvaluator, this.flagSet, true)));
        if (nullableNameFieldInfo != null && this.builder.addGettersSetters) {
            this.registerGetterSetter("JBBPAbstractField", fieldName, true);
        }
    }

    @Override
    public void visitVarField(int offsetInCompiledBlock, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPByteOrder byteOrder, boolean readWholeStreamIntoArray, JBBPIntegerValueEvaluator nullableArraySizeEvaluator, JBBPIntegerValueEvaluator extraDataValueEvaluator) {
        String fieldType;
        this.flagSet.set(this.flagSet.get() | 4);
        this.registerNamedField(nullableNameFieldInfo, FieldType.VAR);
        String fieldName = nullableNameFieldInfo == null ? this.makeAnonymousFieldName() : this.prepFldName(nullableNameFieldInfo.getFieldName());
        String fieldModifier = this.makeModifier(nullableNameFieldInfo);
        String specialFieldName = this.makeSpecialFieldName();
        String specialFieldName_fieldNameInfo = specialFieldName + "FieldInfo";
        if (nullableNameFieldInfo != null) {
            this.specialSection.printf("private static final JBBPNamedFieldInfo %s = %s;%n", specialFieldName_fieldNameInfo, "new JBBPNamedFieldInfo(\"" + this.prepFldName(nullableNameFieldInfo.getFieldName()) + "\",\"" + nullableNameFieldInfo.getFieldPath() + "\"," + nullableNameFieldInfo.getFieldOffsetInCompiledBlock() + ")");
        }
        this.processSkipRemainingFlag();
        if (readWholeStreamIntoArray || nullableArraySizeEvaluator != null) {
            fieldType = "JBBPAbstractArrayField<? extends JBBPAbstractField>";
            if (this.builder.generateFields) {
                this.getCurrentStruct().getFields().printf("%s %s %s;%n", fieldModifier, fieldType, fieldName);
            }
            this.getCurrentStruct().getReadFunc().printf("%s = %s;%n", fieldName, String.format("%s.readVarArray(this, In, %s, %s, %s, %b, %s)", this.getCurrentStruct().isRoot() ? "this" : "this._Root_", "JBBPByteOrder." + byteOrder.name(), nullableNameFieldInfo == null ? "null" : specialFieldName_fieldNameInfo, extraDataValueEvaluator == null ? "-1" : this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, extraDataValueEvaluator, this.flagSet, true), readWholeStreamIntoArray, nullableArraySizeEvaluator == null ? "-1" : this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, nullableArraySizeEvaluator, this.flagSet, true)));
            this.getCurrentStruct().getWriteFunc().printf("%s.writeVarArray(this, this.%s, Out, %s, %s, %s, %s);%n", this.getCurrentStruct().isRoot() ? "this" : "this._Root_", fieldName, "JBBPByteOrder." + byteOrder.name(), nullableNameFieldInfo == null ? "null" : specialFieldName_fieldNameInfo, extraDataValueEvaluator == null ? "-1" : this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, extraDataValueEvaluator, this.flagSet, true), nullableArraySizeEvaluator == null ? "-1" : this.evaluatorToString(NAME_OUTPUT_STREAM, offsetInCompiledBlock, nullableArraySizeEvaluator, this.flagSet, true));
        } else {
            fieldType = "JBBPAbstractField";
            if (this.builder.generateFields) {
                this.getCurrentStruct().getFields().printf("%s %s %s;%n", fieldModifier, fieldType, fieldName);
            }
            this.getCurrentStruct().getReadFunc().printf("%s = %s;%n", fieldName, String.format("%s.readVarField(this, In, %s, %s, %s)", this.getCurrentStruct().isRoot() ? "this" : "this._Root_", "JBBPByteOrder." + byteOrder.name(), nullableNameFieldInfo == null ? "null" : specialFieldName_fieldNameInfo, extraDataValueEvaluator == null ? "-1" : this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, extraDataValueEvaluator, this.flagSet, true)));
            this.getCurrentStruct().getWriteFunc().printf("%s.writeVarField(this, this.%s, Out, %s, %s, %s);%n", this.getCurrentStruct().isRoot() ? "this" : "this._Root_", fieldName, "JBBPByteOrder." + byteOrder.name(), nullableNameFieldInfo == null ? "null" : specialFieldName_fieldNameInfo, extraDataValueEvaluator == null ? "-1" : this.evaluatorToString(NAME_OUTPUT_STREAM, offsetInCompiledBlock, extraDataValueEvaluator, this.flagSet, true));
        }
        if (nullableNameFieldInfo != null && this.builder.addGettersSetters) {
            this.registerGetterSetter(fieldType, fieldName, true);
        }
    }

    private String evaluatorToString(final String streamName, int offsetInBlock, JBBPIntegerValueEvaluator evaluator, final AtomicInteger detectedFlagsSet, boolean doResultPostprocessing) {
        final StringBuilder buffer = new StringBuilder();
        ExpressionEvaluatorVisitor visitor = new ExpressionEvaluatorVisitor(){
            private final List<Object> stack = new ArrayList<Object>();

            @Override
            public ExpressionEvaluatorVisitor visitStart() {
                this.stack.clear();
                return this;
            }

            @Override
            public ExpressionEvaluatorVisitor visitSpecial(ExpressionEvaluatorVisitor.Special specialField) {
                this.stack.add((Object)specialField);
                return this;
            }

            @Override
            public ExpressionEvaluatorVisitor visitField(JBBPNamedFieldInfo nullableNameFieldInfo, String nullableExternalFieldName) {
                if (nullableNameFieldInfo != null) {
                    this.stack.add(nullableNameFieldInfo);
                } else if (nullableExternalFieldName != null) {
                    detectedFlagsSet.set(detectedFlagsSet.get() | 2);
                    this.stack.add(nullableExternalFieldName);
                }
                return this;
            }

            @Override
            public ExpressionEvaluatorVisitor visitOperator(ExpressionEvaluatorVisitor.Operator operator) {
                this.stack.add((Object)operator);
                return this;
            }

            @Override
            public ExpressionEvaluatorVisitor visitConstant(int value) {
                this.stack.add(value);
                return this;
            }

            private String arg2str(Object obj) {
                if (obj instanceof ExprTreeItem) {
                    return obj.toString();
                }
                if (obj instanceof ExpressionEvaluatorVisitor.Special) {
                    switch ((ExpressionEvaluatorVisitor.Special)((Object)obj)) {
                        case STREAM_COUNTER: {
                            return "(int)" + streamName + ".getCounter()";
                        }
                    }
                    throw new Error("Unexpected special");
                }
                if (obj instanceof Integer) {
                    if ((Integer)obj < 0) {
                        return '(' + obj.toString() + ')';
                    }
                    return obj.toString();
                }
                if (obj instanceof String) {
                    return String.format("%s.getNamedValue(this, \"%s\")", JBBPToJava6Converter.this.getCurrentStruct().isRoot() ? "this" : "this._Root_", obj.toString());
                }
                if (obj instanceof JBBPNamedFieldInfo) {
                    String result;
                    NamedFieldInfo namedFieldInfo = (NamedFieldInfo)JBBPToJava6Converter.this.foundNamedFields.get(obj);
                    String fieldPath = namedFieldInfo.makeSrcPath(JBBPToJava6Converter.this.getCurrentStruct());
                    switch (namedFieldInfo.fieldType) {
                        case BOOL: {
                            result = '(' + fieldPath + "?1:0)";
                            break;
                        }
                        case CUSTOM: 
                        case VAR: {
                            result = "((JBBPNumericField)" + fieldPath + ").getAsInt()";
                            break;
                        }
                        default: {
                            result = "(int)" + fieldPath;
                        }
                    }
                    return result;
                }
                return null;
            }

            @Override
            public ExpressionEvaluatorVisitor visitEnd() {
                buffer.setLength(0);
                for (int i = 0; i < this.stack.size(); ++i) {
                    if (!(this.stack.get(i) instanceof ExpressionEvaluatorVisitor.Operator)) continue;
                    ExpressionEvaluatorVisitor.Operator op = (ExpressionEvaluatorVisitor.Operator)((Object)this.stack.remove(i));
                    --i;
                    ExprTreeItem newItem = new ExprTreeItem(op);
                    for (int j = 0; j < op.argsNumber; ++j) {
                        Object val = this.stack.remove(i);
                        --i;
                        if (newItem.right == null) {
                            newItem.right = val;
                            continue;
                        }
                        newItem.left = val;
                    }
                    this.stack.add(++i, newItem);
                }
                if (this.stack.size() != 1) {
                    throw new IllegalStateException("Stack must have only element");
                }
                Object result = this.stack.remove(0);
                if (result instanceof ExprTreeItem) {
                    buffer.append('(').append(result.toString()).append(')');
                } else {
                    buffer.append(this.arg2str(result));
                }
                return this;
            }

            class ExprTreeItem {
                ExpressionEvaluatorVisitor.Operator op;
                Object left;
                Object right;

                ExprTreeItem(ExpressionEvaluatorVisitor.Operator op) {
                    this.op = op;
                }

                boolean doesNeedBrackets(Object obj) {
                    if (!(obj instanceof ExprTreeItem)) {
                        return false;
                    }
                    ExprTreeItem that = (ExprTreeItem)obj;
                    return that.op.priority <= this.op.priority || (that.op == ExpressionEvaluatorVisitor.Operator.LSHIFT || that.op == ExpressionEvaluatorVisitor.Operator.RSHIFT || that.op == ExpressionEvaluatorVisitor.Operator.URSHIFT) && (this.op == ExpressionEvaluatorVisitor.Operator.LSHIFT || this.op == ExpressionEvaluatorVisitor.Operator.RSHIFT || this.op == ExpressionEvaluatorVisitor.Operator.URSHIFT);
                }

                public String toString() {
                    String leftStr = this.arg2str(this.left);
                    String rightStr = this.arg2str(this.right);
                    if (this.doesNeedBrackets(this.left)) {
                        leftStr = '(' + leftStr + ')';
                    }
                    if (this.doesNeedBrackets(this.right)) {
                        rightStr = '(' + rightStr + ')';
                    }
                    return (leftStr == null ? "" : leftStr) + this.op.text + (rightStr == null ? "" : rightStr);
                }
            }
        };
        evaluator.visitItems(this.compiledBlock, offsetInBlock, visitor);
        String result = buffer.toString();
        if (result.startsWith("(") && result.endsWith(")")) {
            try {
                result = Integer.toString(Integer.parseInt(result.substring(1, result.length() - 1).trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!(evaluator instanceof IntConstValueEvaluator) && doResultPostprocessing) {
            if ((this.parserFlags & 2) != 0) {
                result = "java.lang.Math.max(0," + result + ')';
            } else {
                detectedFlagsSet.set(detectedFlagsSet.get() | 8);
                result = "assrtExprNotNeg(" + result + ')';
            }
        }
        return result;
    }

    @Override
    public void visitActionItem(int offsetInCompiledBlock, int actionType, JBBPIntegerValueEvaluator nullableArgument) {
        String valueTxtIn = nullableArgument == null ? "1" : this.evaluatorToString(NAME_INPUT_STREAM, offsetInCompiledBlock, nullableArgument, this.flagSet, true);
        String valueTxtOut = nullableArgument == null ? "1" : this.evaluatorToString(NAME_OUTPUT_STREAM, offsetInCompiledBlock, nullableArgument, this.flagSet, true);
        switch (actionType) {
            case 14: {
                this.getCurrentStruct().getReadFunc().println("In.resetCounter();");
                this.getCurrentStruct().getWriteFunc().println("Out.resetCounter();");
                break;
            }
            case 1: {
                this.getCurrentStruct().getReadFunc().indent().print("In.align(").print(valueTxtIn).println(");");
                this.getCurrentStruct().getWriteFunc().indent().print("Out.align(").print(valueTxtOut).println(");");
                break;
            }
            case 12: {
                this.getCurrentStruct().getReadFunc().indent().print("In.skip(").print(valueTxtIn).println(");");
                this.getCurrentStruct().getWriteFunc().indent().printf("for(int I=0; I<%s; I++) %s.write(0);%n", valueTxtOut, NAME_OUTPUT_STREAM);
                break;
            }
            default: {
                throw new Error("Detected unknown action, contact developer!");
            }
        }
    }

    static {
        HashSet<String> reserved = new HashSet<String>();
        reserved.add("abstract");
        reserved.add("assert");
        reserved.add("boolean");
        reserved.add("break");
        reserved.add("byte");
        reserved.add("case");
        reserved.add("catch");
        reserved.add("char");
        reserved.add("class");
        reserved.add("continue");
        reserved.add("default");
        reserved.add("do");
        reserved.add("double");
        reserved.add("else");
        reserved.add("enum");
        reserved.add("extends");
        reserved.add("final");
        reserved.add("finally");
        reserved.add("float");
        reserved.add("for");
        reserved.add("if");
        reserved.add("implements");
        reserved.add("import");
        reserved.add("instanceof");
        reserved.add("int");
        reserved.add("interface");
        reserved.add("long");
        reserved.add("native");
        reserved.add("new");
        reserved.add("package");
        reserved.add("private");
        reserved.add("protected");
        reserved.add("public");
        reserved.add("return");
        reserved.add("short");
        reserved.add("static");
        reserved.add("strictfp");
        reserved.add("super");
        reserved.add("switch");
        reserved.add("synchronized");
        reserved.add("this");
        reserved.add("throw");
        reserved.add("throws");
        reserved.add("transient");
        reserved.add("try");
        reserved.add("void");
        reserved.add("volatile");
        reserved.add("while");
        reserved.add("true");
        reserved.add("null");
        reserved.add("false");
        reserved.add("var");
        reserved.add("const");
        reserved.add("goto");
        RESERVED_JAVA_KEYWORDS = Collections.unmodifiableSet(reserved);
    }

    private final class NamedFieldInfo {
        final JBBPNamedFieldInfo info;
        final Struct struct;
        final FieldType fieldType;

        NamedFieldInfo(JBBPNamedFieldInfo info, Struct struct, FieldType fieldType) {
            this.info = info;
            this.struct = struct;
            this.fieldType = fieldType;
        }

        String makeSrcPath(Struct currentStruct) {
            String fieldName = JBBPToJava6Converter.this.prepFldName(this.info.getFieldName());
            if (this.struct == currentStruct) {
                return "this." + fieldName;
            }
            String structPath = this.struct.getPath();
            if (currentStruct.isRoot()) {
                return "this." + (structPath.length() == 0 ? "" : structPath + ".") + fieldName;
            }
            return "this._Root_." + (structPath.length() == 0 ? "" : structPath + ".") + fieldName;
        }
    }

    private static class Struct {
        private final String classModifiers;
        private final String className;
        private final Struct parent;
        private final List<Struct> children = new ArrayList<Struct>();
        private final JavaSrcTextBuffer fields = new JavaSrcTextBuffer();
        private final JavaSrcTextBuffer readFunc = new JavaSrcTextBuffer();
        private final JavaSrcTextBuffer writeFunc = new JavaSrcTextBuffer();
        private final JavaSrcTextBuffer gettersSetters = new JavaSrcTextBuffer();
        private final String path;

        private Struct(Struct parent, String className, String classModifiers) {
            this.path = parent == null ? "" : parent.path + (parent.path.length() == 0 ? "" : ".") + className.toLowerCase(Locale.ENGLISH);
            this.classModifiers = classModifiers;
            this.className = className;
            this.parent = parent;
            if (this.parent != null) {
                this.parent.children.add(this);
            }
        }

        private static String interfaces2str(Set<String> set) {
            StringBuilder buffer = new StringBuilder();
            for (String s : set) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(s);
            }
            return buffer.toString();
        }

        boolean isRoot() {
            return this.parent == null;
        }

        String getPath() {
            return this.path;
        }

        Struct findRoot() {
            if (this.parent == null) {
                return this;
            }
            return this.parent.findRoot();
        }

        void write(JavaSrcTextBuffer buffer, String extraModifier, String superClass, Set<String> implementedInterfaces, Map<String, String> mapStructInterfaces, Map<String, String> mapStructSuperclasses, String commonSectionText, String specialMethods, String customText, boolean useSuperclassForReadWrite) {
            String interfaceForGetSet = mapStructInterfaces == null ? null : mapStructInterfaces.get(this.getPath());
            Object[] objectArray = new Object[5];
            objectArray[0] = this.classModifiers;
            objectArray[1] = extraModifier == null ? " " : ' ' + extraModifier + ' ';
            objectArray[2] = this.className;
            Object object = objectArray[3] = superClass != null ? " extends " + superClass + ' ' : "";
            objectArray[4] = interfaceForGetSet == null ? (implementedInterfaces != null && !implementedInterfaces.isEmpty() ? " implements " + Struct.interfaces2str(implementedInterfaces) + ' ' : "") : " implements " + interfaceForGetSet;
            buffer.indent().printf("%s%sclass %s%s%s {%n", objectArray);
            buffer.incIndent();
            if (commonSectionText != null) {
                buffer.printLinesWithIndent(commonSectionText);
            }
            for (Struct c : this.children) {
                c.write(buffer, null, mapStructSuperclasses.get(c.getPath()), null, mapStructInterfaces, mapStructSuperclasses, null, null, null, false);
            }
            buffer.println();
            buffer.printLinesWithIndent(this.fields.toString());
            if (this.parent != null) {
                buffer.indent().println("private final " + this.findRoot().className + ' ' + JBBPToJava6Converter.NAME_ROOT_STRUCT + ';');
            }
            buffer.println();
            buffer.indent().print("public ").print(this.className).print(" (").print(this.parent == null ? "" : this.findRoot().className + " root").println(") {");
            buffer.incIndent();
            if (this.parent != null) {
                buffer.indent().print(JBBPToJava6Converter.NAME_ROOT_STRUCT).print(" = ").println("root;");
            }
            buffer.decIndent();
            buffer.indent().println("}");
            buffer.println();
            buffer.indent().printf("public %s read(final JBBPBitInputStream In) throws IOException {%n", useSuperclassForReadWrite && superClass != null ? superClass : this.className);
            buffer.incIndent();
            buffer.printLinesWithIndent(this.readFunc.toString());
            buffer.indent().println("return this;");
            buffer.decIndent();
            buffer.indent().println("}");
            buffer.println();
            buffer.indent().printf("public %s write(final JBBPBitOutputStream Out) throws IOException {%n", useSuperclassForReadWrite && superClass != null ? superClass : this.className);
            buffer.incIndent();
            buffer.printLinesWithIndent(this.writeFunc.toString());
            buffer.indent().println("return this;");
            buffer.decIndent();
            buffer.indent().println("}");
            if (specialMethods != null) {
                buffer.println();
                buffer.printLinesWithIndent(specialMethods);
                buffer.println();
            }
            if (!this.gettersSetters.isEmpty()) {
                buffer.println();
                buffer.printLinesWithIndent(this.gettersSetters.toString());
                buffer.println();
            }
            if (customText != null && customText.length() != 0) {
                buffer.printCommentLinesWithIndent("------ Custom section START");
                buffer.printLinesWithIndent(customText);
                buffer.printCommentLinesWithIndent("------ Custom section END");
            }
            buffer.decIndent();
            buffer.indent().println("}");
        }

        JavaSrcTextBuffer getWriteFunc() {
            return this.writeFunc;
        }

        JavaSrcTextBuffer getReadFunc() {
            return this.readFunc;
        }

        JavaSrcTextBuffer getFields() {
            return this.fields;
        }

        JavaSrcTextBuffer getGettersSetters() {
            return this.gettersSetters;
        }
    }

    public static final class Builder {
        private final Set<String> mainClassImplements = new HashSet<String>();
        private final JBBPParser srcParser;
        private final Map<String, String> mapSubClassesInterfaces = new HashMap<String, String>();
        private final Map<String, String> mapSubClassesSuperclasses = new HashMap<String, String>();
        public boolean internalClassesNotStatic;
        private String mainClassPackage;
        private String mainClassName;
        private boolean doMainClassAbstract;
        private String superClass;
        private String headComment;
        private boolean lockBuilder;
        private int parserFlags;
        private boolean addGettersSetters;
        private String mainClassCustomText;
        private boolean generateFields;

        private Builder(JBBPParser parser) {
            this.srcParser = parser;
            this.parserFlags = parser.getFlags();
            this.generateFields = true;
        }

        private void assertNonLocked() {
            if (this.lockBuilder) {
                throw new IllegalStateException("Builder already locked");
            }
        }

        public Builder setMapSubClassesInterfaces(Map<String, String> mapClassNameToInterface) {
            this.assertNonLocked();
            this.mapSubClassesInterfaces.clear();
            if (mapClassNameToInterface != null) {
                this.mapSubClassesInterfaces.putAll(mapClassNameToInterface);
            }
            return this;
        }

        public Builder setMapSubClassesSuperclasses(Map<String, String> mapClassNameToSuperclasses) {
            this.assertNonLocked();
            this.mapSubClassesSuperclasses.clear();
            if (mapClassNameToSuperclasses != null) {
                this.mapSubClassesSuperclasses.putAll(mapClassNameToSuperclasses);
            }
            return this;
        }

        public Builder setMainClassCustomText(String value) {
            this.assertNonLocked();
            this.mainClassCustomText = value;
            return this;
        }

        public Builder setAddGettersSetters(boolean value) {
            this.assertNonLocked();
            this.addGettersSetters = value;
            return this;
        }

        public Builder setParserFlags(int value) {
            this.assertNonLocked();
            this.parserFlags = value;
            return this;
        }

        public Builder setMainClassPackage(String value) {
            this.assertNonLocked();
            this.mainClassPackage = value;
            return this;
        }

        public Builder setDoMainClassAbstract(boolean value) {
            this.assertNonLocked();
            this.doMainClassAbstract = value;
            return this;
        }

        public Builder setMainClassName(String value) {
            this.assertNonLocked();
            this.mainClassName = value;
            return this;
        }

        public Builder doInternalClassesNonStatic() {
            this.assertNonLocked();
            this.internalClassesNotStatic = true;
            return this;
        }

        public Builder setSuperClass(String value) {
            this.assertNonLocked();
            this.superClass = value;
            return this;
        }

        public Builder setMainClassImplements(String ... values) {
            this.assertNonLocked();
            Collections.addAll(this.mainClassImplements, values);
            return this;
        }

        public Builder setHeadComment(String text) {
            this.assertNonLocked();
            this.headComment = text;
            return this;
        }

        public Builder disableGenerateFields() {
            this.generateFields = false;
            return this;
        }

        public JBBPToJava6Converter build() {
            this.lockBuilder = true;
            if (this.mainClassName == null) {
                throw new NullPointerException("Class name must not be null");
            }
            return new JBBPToJava6Converter(this);
        }
    }

    private static enum FieldType {
        BOOL(3, "boolean", "boolean", "%s.readBoolean()", "%s.readBoolArray(%s)", "%s.write(%s ? 1 : 0)", "for(int I=0;I<%3$s;I++){%1$s.write(%2$s[I] ? 1 : 0);}", "for(int I=0;I<%2$s.length;I++){%1$s.write(%2$s[I] ? 1 : 0);}"),
        BYTE(5, "byte", "byte", "(byte)%s.readByte()", "%s.readByteArray(%s, %s)", "%s.write(%s)", "%1$s.writeBytes(%2$s, %3$s, %4$s)", "%1$s.writeBytes(%2$s, %2$s.length, %3$s)"),
        UBYTE(4, "char", "byte", "(char)(%s.readByte() & 0xFF)", "%s.readByteArray(%s, %s)", "%s.write(%s)", "%1$s.writeBytes(%2$s, %3$s, %4$s)", "%1$s.writeBytes(%2$s, %2$s.length, %3$s)"),
        SHORT(7, "short", "short", "(short)%s.readUnsignedShort(%s)", "%s.readShortArray(%s,%s)", "%s.writeShort(%s,%s)", "for(int I=0;I<%3$s;I++){%1$s.writeShort(%2$s[I],%4$s);}", "for(int I=0;I<%2$s.length;I++){%1$s.writeShort(%2$s[I],%3$s);}"),
        USHORT(6, "char", "char", "(char)%s.readUnsignedShort(%s)", "%s.readUShortArray(%s,%s)", "%s.writeShort(%s,%s)", "for(int I=0;I<%3$s;I++){%1$s.writeShort(%2$s[I],%4$s);}", "for(int I=0;I<%2$s.length;I++){%1$s.writeShort(%2$s[I],%3$s);}"),
        INT(8, "int", "int", "%s.readInt(%s)", "%s.readIntArray(%s,%s)", "%s.writeInt(%s,%s)", "for(int I=0;I<%3$s;I++){%1$s.writeInt(%2$s[I],%4$s);}", "for(int I=0;I<%2$s.length;I++){%1$s.writeInt(%2$s[I],%3$s);}"),
        LONG(9, "long", "long", "%s.readLong(%s)", "%s.readLongArray(%s,%s)", "%s.writeLong(%s,%s)", "for(int I=0;I<%3$s;I++){%1$s.writeLong(%2$s[I],%4$s);}", "for(int I=0;I<%2$s.length;I++){%1$s.writeLong(%2$s[I],%3$s);}"),
        CUSTOM(-1, "", "", "", "", "", "", ""),
        VAR(-2, "", "", "", "", "", "", ""),
        VAL(-3, "int", "", "", "", "", "", ""),
        BIT(-4, "", "", "", "", "", "", ""),
        FLOAT(-5, "float", "float", "%s.readFloat(%s)", "%s.readFloatArray(%s,%s)", "%s.writeFloat(%s,%s)", "for(int I=0;I<%3$s;I++){%1$s.writeFloat(%2$s[I],%4$s);}", "for(int I=0;I<%2$s.length;I++){%1$s.writeFloat(%2$s[I],%3$s);}"),
        DOUBLE(-6, "double", "double", "%s.readDouble(%s)", "%s.readDoubleArray(%s,%s)", "%s.writeDouble(%s,%s)", "for(int I=0;I<%3$s;I++){%1$s.writeDouble(%2$s[I],%4$s);}", "for(int I=0;I<%2$s.length;I++){%1$s.writeDouble(%2$s[I],%3$s);}"),
        STRING(-7, "String", "String", "%s.readString(%s)", "%s.readStringArray(%s,%s)", "%s.writeString(%s,%s)", "for(int I=0;I<%3$s;I++){%1$s.writeString(%2$s[I],%4$s);}", "%1$s.writeStringArray(%2$s,%3$s)"),
        UNKNOWN(Integer.MIN_VALUE, "", "", "", "", "", "", "");

        private final int code;
        private final String javaSingleType;
        private final String javaArrayType;
        private final String methodReadOne;
        private final String methodReadArray;
        private final String methodWriteOne;
        private final String methodWriteArray;
        private final String methodWriteArrayWithUnknownSize;

        private FieldType(int code, String javaSingleType, String javaArrayType, String readOne, String readArray, String writeOne, String writeArray, String writeArrayWithUnknownSize) {
            this.code = code;
            this.methodWriteArrayWithUnknownSize = writeArrayWithUnknownSize;
            this.javaSingleType = javaSingleType;
            this.javaArrayType = javaArrayType;
            this.methodReadArray = readArray;
            this.methodReadOne = readOne;
            this.methodWriteArray = writeArray;
            this.methodWriteOne = writeOne;
        }

        static FieldType findForCode(int code) {
            for (FieldType t : FieldType.values()) {
                if (t.code != code) continue;
                return t;
            }
            return UNKNOWN;
        }

        void assertNotUnknown() {
            if (this == UNKNOWN) {
                throw new Error("Call method for unknown type");
            }
        }

        String asJavaSingleFieldType() {
            this.assertNotUnknown();
            return this.javaSingleType;
        }

        String asJavaArrayFieldType() {
            this.assertNotUnknown();
            return this.javaArrayType;
        }

        String makeReaderForSingleField(String streamName, JBBPByteOrder byteOrder) {
            this.assertNotUnknown();
            return String.format(this.methodReadOne, streamName, "JBBPByteOrder." + byteOrder.name());
        }

        String makeWriterForSingleField(String streamName, String fieldName, JBBPByteOrder byteOrder) {
            this.assertNotUnknown();
            return String.format(this.methodWriteOne, streamName, fieldName, "JBBPByteOrder." + byteOrder.name());
        }

        String makeReaderForArray(String streamName, String arraySize, JBBPByteOrder byteOrder) {
            this.assertNotUnknown();
            return String.format(this.methodReadArray, streamName, arraySize, "JBBPByteOrder." + byteOrder.name());
        }

        String makeWriterForArray(String streamName, String fieldName, String arraySize, JBBPByteOrder byteOrder) {
            this.assertNotUnknown();
            return String.format(this.methodWriteArray, streamName, fieldName, arraySize, "JBBPByteOrder." + byteOrder.name());
        }

        String makeWriterForArrayWithUnknownSize(String streamName, String fieldName, JBBPByteOrder byteOrder) {
            this.assertNotUnknown();
            return String.format(this.methodWriteArrayWithUnknownSize, streamName, fieldName, "JBBPByteOrder." + byteOrder.name());
        }
    }
}

