/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_encoder_stats_t")
public class BGFXEncoderStats
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CPUTIMEBEGIN;
    public static final int CPUTIMEEND;

    public BGFXEncoderStats(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXEncoderStats.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int64_t")
    public long cpuTimeBegin() {
        return BGFXEncoderStats.ncpuTimeBegin(this.address());
    }

    @NativeType(value="int64_t")
    public long cpuTimeEnd() {
        return BGFXEncoderStats.ncpuTimeEnd(this.address());
    }

    public static BGFXEncoderStats create(long address) {
        return (BGFXEncoderStats)BGFXEncoderStats.wrap(BGFXEncoderStats.class, (long)address);
    }

    @Nullable
    public static BGFXEncoderStats createSafe(long address) {
        return address == 0L ? null : (BGFXEncoderStats)BGFXEncoderStats.wrap(BGFXEncoderStats.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)BGFXEncoderStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)BGFXEncoderStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static long ncpuTimeBegin(long struct) {
        return UNSAFE.getLong(null, struct + (long)CPUTIMEBEGIN);
    }

    public static long ncpuTimeEnd(long struct) {
        return UNSAFE.getLong(null, struct + (long)CPUTIMEEND);
    }

    static {
        Struct.Layout layout = BGFXEncoderStats.__struct((Struct.Member[])new Struct.Member[]{BGFXEncoderStats.__member((int)8), BGFXEncoderStats.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CPUTIMEBEGIN = layout.offsetof(0);
        CPUTIMEEND = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXEncoderStats, Buffer> {
        private static final BGFXEncoderStats ELEMENT_FACTORY = BGFXEncoderStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXEncoderStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int64_t")
        public long cpuTimeBegin() {
            return BGFXEncoderStats.ncpuTimeBegin(this.address());
        }

        @NativeType(value="int64_t")
        public long cpuTimeEnd() {
            return BGFXEncoderStats.ncpuTimeEnd(this.address());
        }
    }
}

