/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.wiki;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.engine.BaseRenderEngine;
import org.radeox.engine.context.BaseRenderContext;

public class Wiki2Markup
extends MatchingTask {
    private Path src;
    private File destDir;
    protected boolean failOnError = true;
    protected boolean listFiles = false;
    protected File[] compileList = new File[0];
    private GlobPatternMapper m = new GlobPatternMapper();
    private RenderContext context = new BaseRenderContext();
    private RenderEngine engine = this.createRenderEngine();

    public static void main(String[] args) {
        try {
            Wiki2Markup engine = new Wiki2Markup();
            engine.compileFiles(args);
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    public Wiki2Markup() {
        this.m.setFrom("*.wiki");
        this.m.setTo(this.getExtension());
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setListfiles(boolean list) {
        this.listFiles = list;
    }

    public boolean getListfiles() {
        return this.listFiles;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setProceed(boolean proceed) {
        this.failOnError = !proceed;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.resetFileLists();
        String[] list = this.src.list();
        for (int i = 0; i < list.length; ++i) {
            File srcDir = this.getProject().resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(srcDir, this.destDir != null ? this.destDir : srcDir, files);
        }
        this.compile();
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        File[] newFiles = sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)this.m);
        if (newFiles.length > 0) {
            File[] newCompileList = new File[this.compileList.length + newFiles.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles, 0, newCompileList, this.compileList.length, newFiles.length);
            this.compileList = newCompileList;
        }
    }

    public File[] getFileList() {
        return this.compileList;
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist " + "or is not a directory", this.getLocation());
        }
    }

    public void compileFiles(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            File file = new File(args[i]);
            this.compile(file, args[i]);
        }
    }

    protected void compile() {
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            try {
                for (int i = 0; i < this.compileList.length; ++i) {
                    String filename = this.compileList[i].getAbsolutePath();
                    if (this.listFiles) {
                        this.log(filename);
                    }
                    this.compile(this.compileList[i], this.compileList[i].getName());
                }
            }
            catch (Exception e) {
                String message = "Compile failed: " + e;
                if (this.failOnError) {
                    throw new BuildException(message, (Throwable)e, this.getLocation());
                }
                this.log(message, 0);
            }
        }
    }

    protected void compile(File file, String name) throws IOException {
        String[] names = this.m.mapFileName(name);
        String outputName = names[0];
        this.context.set("name", (Object)name);
        String text = this.readFile(file);
        String result = this.engine.render(text, this.context);
        File outputFile = new File(this.getDestdir(), outputName);
        System.out.println("Creating file: " + outputFile);
        FileWriter writer = new FileWriter(outputFile);
        result = this.filter(result);
        writer.write(result);
        writer.close();
    }

    protected String filter(String result) {
        return "<html><body>\n" + result + "\n<body><html>\n";
    }

    protected String readFile(File file) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected RenderEngine createRenderEngine() {
        return new BaseRenderEngine();
    }

    protected String getExtension() {
        return "*.html";
    }
}

