/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.decompiler;

import org.jd.gui.util.decompiler.StringBuilderPrinter;

public class LineNumberStringBuilderPrinter
extends StringBuilderPrinter {
    protected boolean showLineNumbers = false;
    protected int maxLineNumber = 0;
    protected int digitCount = 0;
    protected String lineNumberBeginPrefix;
    protected String lineNumberEndPrefix;
    protected String unknownLineNumberPrefix;

    public void setShowLineNumbers(boolean showLineNumbers) {
        this.showLineNumbers = showLineNumbers;
    }

    protected int printDigit(int dcv, int lineNumber, int divisor, int left) {
        if (this.digitCount >= dcv) {
            if (lineNumber < divisor) {
                this.stringBuffer.append(' ');
            } else {
                int e = (lineNumber - left) / divisor;
                this.stringBuffer.append((char)(48 + e));
                left += e * divisor;
            }
        }
        return left;
    }

    @Override
    public void start(int maxLineNumber, int majorVersion, int minorVersion) {
        super.start(maxLineNumber, majorVersion, minorVersion);
        if (this.showLineNumbers) {
            this.maxLineNumber = maxLineNumber;
            if (maxLineNumber > 0) {
                this.digitCount = 1;
                this.unknownLineNumberPrefix = " ";
                int maximum = 9;
                while (maximum < maxLineNumber) {
                    ++this.digitCount;
                    this.unknownLineNumberPrefix = this.unknownLineNumberPrefix + ' ';
                    maximum = maximum * 10 + 9;
                }
                this.lineNumberBeginPrefix = "/* ";
                this.lineNumberEndPrefix = " */ ";
            } else {
                this.unknownLineNumberPrefix = "";
                this.lineNumberBeginPrefix = "";
                this.lineNumberEndPrefix = "";
            }
        } else {
            this.maxLineNumber = 0;
            this.unknownLineNumberPrefix = "";
            this.lineNumberBeginPrefix = "";
            this.lineNumberEndPrefix = "";
        }
    }

    @Override
    public void startLine(int lineNumber) {
        if (this.maxLineNumber > 0) {
            this.stringBuffer.append(this.lineNumberBeginPrefix);
            if (lineNumber == 0) {
                this.stringBuffer.append(this.unknownLineNumberPrefix);
            } else {
                int left = 0;
                left = this.printDigit(5, lineNumber, 10000, left);
                left = this.printDigit(4, lineNumber, 1000, left);
                left = this.printDigit(3, lineNumber, 100, left);
                left = this.printDigit(2, lineNumber, 10, left);
                this.stringBuffer.append((char)(48 + (lineNumber - left)));
            }
            this.stringBuffer.append(this.lineNumberEndPrefix);
        }
        for (int i = 0; i < this.indentationCount; ++i) {
            this.stringBuffer.append("  ");
        }
    }

    @Override
    public void extraLine(int count) {
        if (this.realignmentLineNumber) {
            while (count-- > 0) {
                if (this.maxLineNumber > 0) {
                    this.stringBuffer.append(this.lineNumberBeginPrefix);
                    this.stringBuffer.append(this.unknownLineNumberPrefix);
                    this.stringBuffer.append(this.lineNumberEndPrefix);
                }
                this.stringBuffer.append("\n");
            }
        }
    }
}

