/*
 * This declarations of the PIC10F322 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:22:55 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC10F322_H__
#define __PIC10F322_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF_ADDR               0x0000
#define TMR0_ADDR               0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR_ADDR                0x0004
#define PORTA_ADDR              0x0005
#define TRISA_ADDR              0x0006
#define LATA_ADDR               0x0007
#define ANSELA_ADDR             0x0008
#define WPUA_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PIR1_ADDR               0x000C
#define PIE1_ADDR               0x000D
#define OPTION_REG_ADDR         0x000E
#define PCON_ADDR               0x000F
#define OSCCON_ADDR             0x0010
#define TMR2_ADDR               0x0011
#define PR2_ADDR                0x0012
#define T2CON_ADDR              0x0013
#define PWM1DCL_ADDR            0x0014
#define PWM1DCH_ADDR            0x0015
#define PWM1CON_ADDR            0x0016
#define PWM1CON0_ADDR           0x0016
#define PWM2DCL_ADDR            0x0017
#define PWM2DCH_ADDR            0x0018
#define PWM2CON_ADDR            0x0019
#define PWM2CON0_ADDR           0x0019
#define IOCAP_ADDR              0x001A
#define IOCAN_ADDR              0x001B
#define IOCAF_ADDR              0x001C
#define FVRCON_ADDR             0x001D
#define ADRES_ADDR              0x001E
#define ADCON_ADDR              0x001F
#define PMADR_ADDR              0x0020
#define PMADRL_ADDR             0x0020
#define PMADRH_ADDR             0x0021
#define PMDAT_ADDR              0x0022
#define PMDATL_ADDR             0x0022
#define PMDATH_ADDR             0x0023
#define PMCON1_ADDR             0x0024
#define PMCON2_ADDR             0x0025
#define CLKRCON_ADDR            0x0026
#define NCO1ACC_ADDR            0x0027
#define NCO1ACCL_ADDR           0x0027
#define NCO1ACCH_ADDR           0x0028
#define NCO1ACCU_ADDR           0x0029
#define NCO1INC_ADDR            0x002A
#define NCO1INCL_ADDR           0x002A
#define NCO1INCH_ADDR           0x002B
#define NCO1INCU_ADDR           0x002C
#define NCO1CON_ADDR            0x002D
#define NCO1CLK_ADDR            0x002E
#define WDTCON_ADDR             0x0030
#define CLC1CON_ADDR            0x0031
#define CLC1SEL0_ADDR           0x0032
#define CLC1SEL1_ADDR           0x0033
#define CLC1POL_ADDR            0x0034
#define CLC1GLS0_ADDR           0x0035
#define CLC1GLS1_ADDR           0x0036
#define CLC1GLS2_ADDR           0x0037
#define CLC1GLS3_ADDR           0x0038
#define CWG1CON0_ADDR           0x0039
#define CWG1CON1_ADDR           0x003A
#define CWG1CON2_ADDR           0x003B
#define CWG1DBR_ADDR            0x003C
#define CWG1DBF_ADDR            0x003D
#define VREGCON_ADDR            0x003E
#define BORCON_ADDR             0x003F

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF;
extern __at(0x0001) __sfr TMR0;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef union
  {
  struct
    {
    unsigned C                  : 1;
    unsigned DC                 : 1;
    unsigned Z                  : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned IRP                : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RP                 : 2;
    unsigned                    : 1;
    };
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10
#define _RP0                    0x20
#define _RP1                    0x40
#define _IRP                    0x80

//==============================================================================

extern __at(0x0004) __sfr FSR;

//==============================================================================
//        PORTA Bits

extern __at(0x0005) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 4;
    unsigned                    : 4;
    };
  } __PORTAbits_t;

extern __at(0x0005) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0006) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 3;
    unsigned                    : 5;
    };
  } __TRISAbits_t;

extern __at(0x0006) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0007) __sfr LATA;

typedef union
  {
  struct
    {
    unsigned LATA0              : 1;
    unsigned LATA1              : 1;
    unsigned LATA2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATA               : 3;
    unsigned                    : 5;
    };
  } __LATAbits_t;

extern __at(0x0007) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x0008) __sfr ANSELA;

typedef union
  {
  struct
    {
    unsigned ANSA0              : 1;
    unsigned ANSA1              : 1;
    unsigned ANSA2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSA               : 3;
    unsigned                    : 5;
    };
  } __ANSELAbits_t;

extern __at(0x0008) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x0009) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned WPUA3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUA               : 4;
    unsigned                    : 4;
    };
  } __WPUAbits_t;

extern __at(0x0009) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08

//==============================================================================


//==============================================================================
//        PCLATH Bits

extern __at(0x000A) __sfr PCLATH;

typedef struct
  {
  unsigned PCLH0                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PCLATHbits_t;

extern __at(0x000A) volatile __PCLATHbits_t PCLATHbits;

#define _PCLH0                  0x01

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef struct
  {
  unsigned IOCIF                : 1;
  unsigned INTF                 : 1;
  unsigned TMR0IF               : 1;
  unsigned IOCIE                : 1;
  unsigned INTE                 : 1;
  unsigned TMR0IE               : 1;
  unsigned PEIE                 : 1;
  unsigned GIE                  : 1;
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x000C) __sfr PIR1;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR2IF               : 1;
  unsigned                      : 1;
  unsigned CLC1IF               : 1;
  unsigned NCO1IF               : 1;
  unsigned                      : 1;
  unsigned ADIF                 : 1;
  unsigned                      : 1;
  } __PIR1bits_t;

extern __at(0x000C) volatile __PIR1bits_t PIR1bits;

#define _TMR2IF                 0x02
#define _CLC1IF                 0x08
#define _NCO1IF                 0x10
#define _ADIF                   0x40

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x000D) __sfr PIE1;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR2IE               : 1;
  unsigned                      : 1;
  unsigned CLC1IE               : 1;
  unsigned NCO1IE               : 1;
  unsigned                      : 1;
  unsigned ADIE                 : 1;
  unsigned                      : 1;
  } __PIE1bits_t;

extern __at(0x000D) volatile __PIE1bits_t PIE1bits;

#define _TMR2IE                 0x02
#define _CLC1IE                 0x08
#define _NCO1IE                 0x10
#define _ADIE                   0x40

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x000E) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x000E) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x000F) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PCONbits_t;

extern __at(0x000F) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0010) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned HFIOFS             : 1;
    unsigned LFIOFR             : 1;
    unsigned                    : 1;
    unsigned HFIOFR             : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0010) volatile __OSCCONbits_t OSCCONbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _HFIOFR                 0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40

//==============================================================================

extern __at(0x0011) __sfr TMR2;
extern __at(0x0012) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x0013) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned TOUTPS0            : 1;
    unsigned TOUTPS1            : 1;
    unsigned TOUTPS2            : 1;
    unsigned TOUTPS3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TOUTPS             : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0013) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _TOUTPS0                0x08
#define _TOUTPS1                0x10
#define _TOUTPS2                0x20
#define _TOUTPS3                0x40

//==============================================================================


//==============================================================================
//        PWM1DCL Bits

extern __at(0x0014) __sfr PWM1DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM1DCL0           : 1;
    unsigned PWM1DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM1DCL            : 2;
    };
  } __PWM1DCLbits_t;

extern __at(0x0014) volatile __PWM1DCLbits_t PWM1DCLbits;

#define _PWM1DCL0               0x40
#define _PWM1DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM1DCH Bits

extern __at(0x0015) __sfr PWM1DCH;

typedef struct
  {
  unsigned PWM1DCH0             : 1;
  unsigned PWM1DCH1             : 1;
  unsigned PWM1DCH2             : 1;
  unsigned PWM1DCH3             : 1;
  unsigned PWM1DCH4             : 1;
  unsigned PWM1DCH5             : 1;
  unsigned PWM1DCH6             : 1;
  unsigned PWM1DCH7             : 1;
  } __PWM1DCHbits_t;

extern __at(0x0015) volatile __PWM1DCHbits_t PWM1DCHbits;

#define _PWM1DCH0               0x01
#define _PWM1DCH1               0x02
#define _PWM1DCH2               0x04
#define _PWM1DCH3               0x08
#define _PWM1DCH4               0x10
#define _PWM1DCH5               0x20
#define _PWM1DCH6               0x40
#define _PWM1DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0016) __sfr PWM1CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1POL              : 1;
  unsigned PWM1OUT              : 1;
  unsigned PWM1OE               : 1;
  unsigned PWM1EN               : 1;
  } __PWM1CONbits_t;

extern __at(0x0016) volatile __PWM1CONbits_t PWM1CONbits;

#define _PWM1POL                0x10
#define _PWM1OUT                0x20
#define _PWM1OE                 0x40
#define _PWM1EN                 0x80

//==============================================================================


//==============================================================================
//        PWM1CON0 Bits

extern __at(0x0016) __sfr PWM1CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1POL              : 1;
  unsigned PWM1OUT              : 1;
  unsigned PWM1OE               : 1;
  unsigned PWM1EN               : 1;
  } __PWM1CON0bits_t;

extern __at(0x0016) volatile __PWM1CON0bits_t PWM1CON0bits;

#define _PWM1CON0_PWM1POL       0x10
#define _PWM1CON0_PWM1OUT       0x20
#define _PWM1CON0_PWM1OE        0x40
#define _PWM1CON0_PWM1EN        0x80

//==============================================================================


//==============================================================================
//        PWM2DCL Bits

extern __at(0x0017) __sfr PWM2DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM2DCL0           : 1;
    unsigned PWM2DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM2DCL            : 2;
    };
  } __PWM2DCLbits_t;

extern __at(0x0017) volatile __PWM2DCLbits_t PWM2DCLbits;

#define _PWM2DCL0               0x40
#define _PWM2DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM2DCH Bits

extern __at(0x0018) __sfr PWM2DCH;

typedef struct
  {
  unsigned PWM2DCH0             : 1;
  unsigned PWM2DCH1             : 1;
  unsigned PWM2DCH2             : 1;
  unsigned PWM2DCH3             : 1;
  unsigned PWM2DCH4             : 1;
  unsigned PWM2DCH5             : 1;
  unsigned PWM2DCH6             : 1;
  unsigned PWM2DCH7             : 1;
  } __PWM2DCHbits_t;

extern __at(0x0018) volatile __PWM2DCHbits_t PWM2DCHbits;

#define _PWM2DCH0               0x01
#define _PWM2DCH1               0x02
#define _PWM2DCH2               0x04
#define _PWM2DCH3               0x08
#define _PWM2DCH4               0x10
#define _PWM2DCH5               0x20
#define _PWM2DCH6               0x40
#define _PWM2DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM2CON Bits

extern __at(0x0019) __sfr PWM2CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM2POL              : 1;
  unsigned PWM2OUT              : 1;
  unsigned PWM2OE               : 1;
  unsigned PWM2EN               : 1;
  } __PWM2CONbits_t;

extern __at(0x0019) volatile __PWM2CONbits_t PWM2CONbits;

#define _PWM2POL                0x10
#define _PWM2OUT                0x20
#define _PWM2OE                 0x40
#define _PWM2EN                 0x80

//==============================================================================


//==============================================================================
//        PWM2CON0 Bits

extern __at(0x0019) __sfr PWM2CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM2POL              : 1;
  unsigned PWM2OUT              : 1;
  unsigned PWM2OE               : 1;
  unsigned PWM2EN               : 1;
  } __PWM2CON0bits_t;

extern __at(0x0019) volatile __PWM2CON0bits_t PWM2CON0bits;

#define _PWM2CON0_PWM2POL       0x10
#define _PWM2CON0_PWM2OUT       0x20
#define _PWM2CON0_PWM2OE        0x40
#define _PWM2CON0_PWM2EN        0x80

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x001A) __sfr IOCAP;

typedef union
  {
  struct
    {
    unsigned IOCAP0             : 1;
    unsigned IOCAP1             : 1;
    unsigned IOCAP2             : 1;
    unsigned IOCAP3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAP              : 4;
    unsigned                    : 4;
    };
  } __IOCAPbits_t;

extern __at(0x001A) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x001B) __sfr IOCAN;

typedef union
  {
  struct
    {
    unsigned IOCAN0             : 1;
    unsigned IOCAN1             : 1;
    unsigned IOCAN2             : 1;
    unsigned IOCAN3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAN              : 4;
    unsigned                    : 4;
    };
  } __IOCANbits_t;

extern __at(0x001B) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x001C) __sfr IOCAF;

typedef union
  {
  struct
    {
    unsigned IOCAF0             : 1;
    unsigned IOCAF1             : 1;
    unsigned IOCAF2             : 1;
    unsigned IOCAF3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAF              : 4;
    unsigned                    : 4;
    };
  } __IOCAFbits_t;

extern __at(0x001C) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x001D) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };
  } __FVRCONbits_t;

extern __at(0x001D) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================

extern __at(0x001E) __sfr ADRES;

//==============================================================================
//        ADCON Bits

extern __at(0x001F) __sfr ADCON;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 3;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 5;
    unsigned ADCS               : 3;
    };
  } __ADCONbits_t;

extern __at(0x001F) volatile __ADCONbits_t ADCONbits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _ADCS0                  0x20
#define _ADCS1                  0x40
#define _ADCS2                  0x80

//==============================================================================

extern __at(0x0020) __sfr PMADR;
extern __at(0x0020) __sfr PMADRL;

//==============================================================================
//        PMADRH Bits

extern __at(0x0021) __sfr PMADRH;

typedef struct
  {
  unsigned PMADR8               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PMADRHbits_t;

extern __at(0x0021) volatile __PMADRHbits_t PMADRHbits;

#define _PMADR8                 0x01

//==============================================================================

extern __at(0x0022) __sfr PMDAT;
extern __at(0x0022) __sfr PMDATL;
extern __at(0x0023) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0024) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0024) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0025) __sfr PMCON2;

//==============================================================================
//        CLKRCON Bits

extern __at(0x0026) __sfr CLKRCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CLKROE               : 1;
  unsigned                      : 1;
  } __CLKRCONbits_t;

extern __at(0x0026) volatile __CLKRCONbits_t CLKRCONbits;

#define _CLKROE                 0x40

//==============================================================================

extern __at(0x0027) __sfr NCO1ACC;

//==============================================================================
//        NCO1ACCL Bits

extern __at(0x0027) __sfr NCO1ACCL;

typedef struct
  {
  unsigned NCO1ACC0             : 1;
  unsigned NCO1ACC1             : 1;
  unsigned NCO1ACC2             : 1;
  unsigned NCO1ACC3             : 1;
  unsigned NCO1ACC4             : 1;
  unsigned NCO1ACC5             : 1;
  unsigned NCO1ACC6             : 1;
  unsigned NCO1ACC7             : 1;
  } __NCO1ACCLbits_t;

extern __at(0x0027) volatile __NCO1ACCLbits_t NCO1ACCLbits;

#define _NCO1ACC0               0x01
#define _NCO1ACC1               0x02
#define _NCO1ACC2               0x04
#define _NCO1ACC3               0x08
#define _NCO1ACC4               0x10
#define _NCO1ACC5               0x20
#define _NCO1ACC6               0x40
#define _NCO1ACC7               0x80

//==============================================================================


//==============================================================================
//        NCO1ACCH Bits

extern __at(0x0028) __sfr NCO1ACCH;

typedef struct
  {
  unsigned NCO1ACC8             : 1;
  unsigned NCO1ACC9             : 1;
  unsigned NCO1ACC10            : 1;
  unsigned NCO1ACC11            : 1;
  unsigned NCO1ACC12            : 1;
  unsigned NCO1ACC13            : 1;
  unsigned NCO1ACC14            : 1;
  unsigned NCO1ACC15            : 1;
  } __NCO1ACCHbits_t;

extern __at(0x0028) volatile __NCO1ACCHbits_t NCO1ACCHbits;

#define _NCO1ACC8               0x01
#define _NCO1ACC9               0x02
#define _NCO1ACC10              0x04
#define _NCO1ACC11              0x08
#define _NCO1ACC12              0x10
#define _NCO1ACC13              0x20
#define _NCO1ACC14              0x40
#define _NCO1ACC15              0x80

//==============================================================================


//==============================================================================
//        NCO1ACCU Bits

extern __at(0x0029) __sfr NCO1ACCU;

typedef struct
  {
  unsigned NCO1ACC16            : 1;
  unsigned NCO1ACC17            : 1;
  unsigned NCO1ACC18            : 1;
  unsigned NCO1ACC19            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __NCO1ACCUbits_t;

extern __at(0x0029) volatile __NCO1ACCUbits_t NCO1ACCUbits;

#define _NCO1ACC16              0x01
#define _NCO1ACC17              0x02
#define _NCO1ACC18              0x04
#define _NCO1ACC19              0x08

//==============================================================================

extern __at(0x002A) __sfr NCO1INC;

//==============================================================================
//        NCO1INCL Bits

extern __at(0x002A) __sfr NCO1INCL;

typedef struct
  {
  unsigned NCO1INC0             : 1;
  unsigned NCO1INC1             : 1;
  unsigned NCO1INC2             : 1;
  unsigned NCO1INC3             : 1;
  unsigned NCO1INC4             : 1;
  unsigned NCO1INC5             : 1;
  unsigned NCO1INC6             : 1;
  unsigned NCO1INC7             : 1;
  } __NCO1INCLbits_t;

extern __at(0x002A) volatile __NCO1INCLbits_t NCO1INCLbits;

#define _NCO1INC0               0x01
#define _NCO1INC1               0x02
#define _NCO1INC2               0x04
#define _NCO1INC3               0x08
#define _NCO1INC4               0x10
#define _NCO1INC5               0x20
#define _NCO1INC6               0x40
#define _NCO1INC7               0x80

//==============================================================================


//==============================================================================
//        NCO1INCH Bits

extern __at(0x002B) __sfr NCO1INCH;

typedef struct
  {
  unsigned NCO1INC8             : 1;
  unsigned NCO1INC9             : 1;
  unsigned NCO1INC10            : 1;
  unsigned NCO1INC11            : 1;
  unsigned NCO1INC12            : 1;
  unsigned NCO1INC13            : 1;
  unsigned NCO1INC14            : 1;
  unsigned NCO1INC15            : 1;
  } __NCO1INCHbits_t;

extern __at(0x002B) volatile __NCO1INCHbits_t NCO1INCHbits;

#define _NCO1INC8               0x01
#define _NCO1INC9               0x02
#define _NCO1INC10              0x04
#define _NCO1INC11              0x08
#define _NCO1INC12              0x10
#define _NCO1INC13              0x20
#define _NCO1INC14              0x40
#define _NCO1INC15              0x80

//==============================================================================

extern __at(0x002C) __sfr NCO1INCU;

//==============================================================================
//        NCO1CON Bits

extern __at(0x002D) __sfr NCO1CON;

typedef struct
  {
  unsigned N1PFM                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned N1POL                : 1;
  unsigned N1OUT                : 1;
  unsigned N1OE                 : 1;
  unsigned N1EN                 : 1;
  } __NCO1CONbits_t;

extern __at(0x002D) volatile __NCO1CONbits_t NCO1CONbits;

#define _N1PFM                  0x01
#define _N1POL                  0x10
#define _N1OUT                  0x20
#define _N1OE                   0x40
#define _N1EN                   0x80

//==============================================================================


//==============================================================================
//        NCO1CLK Bits

extern __at(0x002E) __sfr NCO1CLK;

typedef union
  {
  struct
    {
    unsigned N1CKS0             : 1;
    unsigned N1CKS1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned N1PWS0             : 1;
    unsigned N1PWS1             : 1;
    unsigned N1PWS2             : 1;
    };

  struct
    {
    unsigned N1CKS              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 5;
    unsigned N1PWS              : 3;
    };
  } __NCO1CLKbits_t;

extern __at(0x002E) volatile __NCO1CLKbits_t NCO1CLKbits;

#define _N1CKS0                 0x01
#define _N1CKS1                 0x02
#define _N1PWS0                 0x20
#define _N1PWS1                 0x40
#define _N1PWS2                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0030) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0030) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        CLC1CON Bits

extern __at(0x0031) __sfr CLC1CON;

typedef union
  {
  struct
    {
    unsigned LC1MODE0           : 1;
    unsigned LC1MODE1           : 1;
    unsigned LC1MODE2           : 1;
    unsigned LC1INTN            : 1;
    unsigned LC1INTP            : 1;
    unsigned LC1OUT             : 1;
    unsigned LC1OE              : 1;
    unsigned LC1EN              : 1;
    };

  struct
    {
    unsigned LCMODE0            : 1;
    unsigned LCMODE1            : 1;
    unsigned LCMODE2            : 1;
    unsigned LCINTN             : 1;
    unsigned LCINTP             : 1;
    unsigned LCOUT              : 1;
    unsigned LCOE               : 1;
    unsigned LCEN               : 1;
    };

  struct
    {
    unsigned LC1MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LCMODE             : 3;
    unsigned                    : 5;
    };
  } __CLC1CONbits_t;

extern __at(0x0031) volatile __CLC1CONbits_t CLC1CONbits;

#define _LC1MODE0               0x01
#define _LCMODE0                0x01
#define _LC1MODE1               0x02
#define _LCMODE1                0x02
#define _LC1MODE2               0x04
#define _LCMODE2                0x04
#define _LC1INTN                0x08
#define _LCINTN                 0x08
#define _LC1INTP                0x10
#define _LCINTP                 0x10
#define _LC1OUT                 0x20
#define _LCOUT                  0x20
#define _LC1OE                  0x40
#define _LCOE                   0x40
#define _LC1EN                  0x80
#define _LCEN                   0x80

//==============================================================================


//==============================================================================
//        CLC1SEL0 Bits

extern __at(0x0032) __sfr CLC1SEL0;

typedef union
  {
  struct
    {
    unsigned LC1D1S0            : 1;
    unsigned LC1D1S1            : 1;
    unsigned LC1D1S2            : 1;
    unsigned                    : 1;
    unsigned LC1D2S0            : 1;
    unsigned LC1D2S1            : 1;
    unsigned LC1D2S2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned                    : 1;
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC1D1S             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned D2S                : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LC1D2S             : 3;
    unsigned                    : 1;
    };
  } __CLC1SEL0bits_t;

extern __at(0x0032) volatile __CLC1SEL0bits_t CLC1SEL0bits;

#define _LC1D1S0                0x01
#define _D1S0                   0x01
#define _LC1D1S1                0x02
#define _D1S1                   0x02
#define _LC1D1S2                0x04
#define _D1S2                   0x04
#define _LC1D2S0                0x10
#define _D2S0                   0x10
#define _LC1D2S1                0x20
#define _D2S1                   0x20
#define _LC1D2S2                0x40
#define _D2S2                   0x40

//==============================================================================


//==============================================================================
//        CLC1SEL1 Bits

extern __at(0x0033) __sfr CLC1SEL1;

typedef union
  {
  struct
    {
    unsigned LC1D3S0            : 1;
    unsigned LC1D3S1            : 1;
    unsigned LC1D3S2            : 1;
    unsigned                    : 1;
    unsigned LC1D4S0            : 1;
    unsigned LC1D4S1            : 1;
    unsigned LC1D4S2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned                    : 1;
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D3S             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned D3S                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LC1D4S             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned D4S                : 3;
    unsigned                    : 1;
    };
  } __CLC1SEL1bits_t;

extern __at(0x0033) volatile __CLC1SEL1bits_t CLC1SEL1bits;

#define _LC1D3S0                0x01
#define _D3S0                   0x01
#define _LC1D3S1                0x02
#define _D3S1                   0x02
#define _LC1D3S2                0x04
#define _D3S2                   0x04
#define _LC1D4S0                0x10
#define _D4S0                   0x10
#define _LC1D4S1                0x20
#define _D4S1                   0x20
#define _LC1D4S2                0x40
#define _D4S2                   0x40

//==============================================================================


//==============================================================================
//        CLC1POL Bits

extern __at(0x0034) __sfr CLC1POL;

typedef union
  {
  struct
    {
    unsigned LC1G1POL           : 1;
    unsigned LC1G2POL           : 1;
    unsigned LC1G3POL           : 1;
    unsigned LC1G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC1POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC1POLbits_t;

extern __at(0x0034) volatile __CLC1POLbits_t CLC1POLbits;

#define _LC1G1POL               0x01
#define _G1POL                  0x01
#define _LC1G2POL               0x02
#define _G2POL                  0x02
#define _LC1G3POL               0x04
#define _G3POL                  0x04
#define _LC1G4POL               0x08
#define _G4POL                  0x08
#define _LC1POL                 0x80
#define _POL                    0x80

//==============================================================================


//==============================================================================
//        CLC1GLS0 Bits

extern __at(0x0035) __sfr CLC1GLS0;

typedef union
  {
  struct
    {
    unsigned LC1G1D1N           : 1;
    unsigned LC1G1D1T           : 1;
    unsigned LC1G1D2N           : 1;
    unsigned LC1G1D2T           : 1;
    unsigned LC1G1D3N           : 1;
    unsigned LC1G1D3T           : 1;
    unsigned LC1G1D4N           : 1;
    unsigned LC1G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS0bits_t;

extern __at(0x0035) volatile __CLC1GLS0bits_t CLC1GLS0bits;

#define _LC1G1D1N               0x01
#define _D1N                    0x01
#define _LC1G1D1T               0x02
#define _D1T                    0x02
#define _LC1G1D2N               0x04
#define _D2N                    0x04
#define _LC1G1D2T               0x08
#define _D2T                    0x08
#define _LC1G1D3N               0x10
#define _D3N                    0x10
#define _LC1G1D3T               0x20
#define _D3T                    0x20
#define _LC1G1D4N               0x40
#define _D4N                    0x40
#define _LC1G1D4T               0x80
#define _D4T                    0x80

//==============================================================================


//==============================================================================
//        CLC1GLS1 Bits

extern __at(0x0036) __sfr CLC1GLS1;

typedef union
  {
  struct
    {
    unsigned LC1G2D1N           : 1;
    unsigned LC1G2D1T           : 1;
    unsigned LC1G2D2N           : 1;
    unsigned LC1G2D2T           : 1;
    unsigned LC1G2D3N           : 1;
    unsigned LC1G2D3T           : 1;
    unsigned LC1G2D4N           : 1;
    unsigned LC1G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS1bits_t;

extern __at(0x0036) volatile __CLC1GLS1bits_t CLC1GLS1bits;

#define _CLC1GLS1_LC1G2D1N      0x01
#define _CLC1GLS1_D1N           0x01
#define _CLC1GLS1_LC1G2D1T      0x02
#define _CLC1GLS1_D1T           0x02
#define _CLC1GLS1_LC1G2D2N      0x04
#define _CLC1GLS1_D2N           0x04
#define _CLC1GLS1_LC1G2D2T      0x08
#define _CLC1GLS1_D2T           0x08
#define _CLC1GLS1_LC1G2D3N      0x10
#define _CLC1GLS1_D3N           0x10
#define _CLC1GLS1_LC1G2D3T      0x20
#define _CLC1GLS1_D3T           0x20
#define _CLC1GLS1_LC1G2D4N      0x40
#define _CLC1GLS1_D4N           0x40
#define _CLC1GLS1_LC1G2D4T      0x80
#define _CLC1GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS2 Bits

extern __at(0x0037) __sfr CLC1GLS2;

typedef union
  {
  struct
    {
    unsigned LC1G3D1N           : 1;
    unsigned LC1G3D1T           : 1;
    unsigned LC1G3D2N           : 1;
    unsigned LC1G3D2T           : 1;
    unsigned LC1G3D3N           : 1;
    unsigned LC1G3D3T           : 1;
    unsigned LC1G3D4N           : 1;
    unsigned LC1G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS2bits_t;

extern __at(0x0037) volatile __CLC1GLS2bits_t CLC1GLS2bits;

#define _CLC1GLS2_LC1G3D1N      0x01
#define _CLC1GLS2_D1N           0x01
#define _CLC1GLS2_LC1G3D1T      0x02
#define _CLC1GLS2_D1T           0x02
#define _CLC1GLS2_LC1G3D2N      0x04
#define _CLC1GLS2_D2N           0x04
#define _CLC1GLS2_LC1G3D2T      0x08
#define _CLC1GLS2_D2T           0x08
#define _CLC1GLS2_LC1G3D3N      0x10
#define _CLC1GLS2_D3N           0x10
#define _CLC1GLS2_LC1G3D3T      0x20
#define _CLC1GLS2_D3T           0x20
#define _CLC1GLS2_LC1G3D4N      0x40
#define _CLC1GLS2_D4N           0x40
#define _CLC1GLS2_LC1G3D4T      0x80
#define _CLC1GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS3 Bits

extern __at(0x0038) __sfr CLC1GLS3;

typedef union
  {
  struct
    {
    unsigned LC1G4D1N           : 1;
    unsigned LC1G4D1T           : 1;
    unsigned LC1G4D2N           : 1;
    unsigned LC1G4D2T           : 1;
    unsigned LC1G4D3N           : 1;
    unsigned LC1G4D3T           : 1;
    unsigned LC1G4D4N           : 1;
    unsigned LC1G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC1GLS3bits_t;

extern __at(0x0038) volatile __CLC1GLS3bits_t CLC1GLS3bits;

#define _LC1G4D1N               0x01
#define _G4D1N                  0x01
#define _LC1G4D1T               0x02
#define _G4D1T                  0x02
#define _LC1G4D2N               0x04
#define _G4D2N                  0x04
#define _LC1G4D2T               0x08
#define _G4D2T                  0x08
#define _LC1G4D3N               0x10
#define _G4D3N                  0x10
#define _LC1G4D3T               0x20
#define _G4D3T                  0x20
#define _LC1G4D4N               0x40
#define _G4D4N                  0x40
#define _LC1G4D4T               0x80
#define _G4D4T                  0x80

//==============================================================================


//==============================================================================
//        CWG1CON0 Bits

extern __at(0x0039) __sfr CWG1CON0;

typedef struct
  {
  unsigned G1CS0                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned G1POLA               : 1;
  unsigned G1POLB               : 1;
  unsigned G1OEA                : 1;
  unsigned G1OEB                : 1;
  unsigned G1EN                 : 1;
  } __CWG1CON0bits_t;

extern __at(0x0039) volatile __CWG1CON0bits_t CWG1CON0bits;

#define _G1CS0                  0x01
#define _G1POLA                 0x08
#define _G1POLB                 0x10
#define _G1OEA                  0x20
#define _G1OEB                  0x40
#define _G1EN                   0x80

//==============================================================================


//==============================================================================
//        CWG1CON1 Bits

extern __at(0x003A) __sfr CWG1CON1;

typedef union
  {
  struct
    {
    unsigned G1IS0              : 1;
    unsigned G1IS1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1ASDLA0           : 1;
    unsigned G1ASDLA1           : 1;
    unsigned G1ASDLB0           : 1;
    unsigned G1ASDLB1           : 1;
    };

  struct
    {
    unsigned G1IS               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned G1ASDLA            : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned G1ASDLB            : 2;
    };
  } __CWG1CON1bits_t;

extern __at(0x003A) volatile __CWG1CON1bits_t CWG1CON1bits;

#define _G1IS0                  0x01
#define _G1IS1                  0x02
#define _G1ASDLA0               0x10
#define _G1ASDLA1               0x20
#define _G1ASDLB0               0x40
#define _G1ASDLB1               0x80

//==============================================================================


//==============================================================================
//        CWG1CON2 Bits

extern __at(0x003B) __sfr CWG1CON2;

typedef struct
  {
  unsigned G1ASDSFLT            : 1;
  unsigned G1ASDSCLC1           : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned G1ARSEN              : 1;
  unsigned G1ASE                : 1;
  } __CWG1CON2bits_t;

extern __at(0x003B) volatile __CWG1CON2bits_t CWG1CON2bits;

#define _G1ASDSFLT              0x01
#define _G1ASDSCLC1             0x02
#define _G1ARSEN                0x40
#define _G1ASE                  0x80

//==============================================================================


//==============================================================================
//        CWG1DBR Bits

extern __at(0x003C) __sfr CWG1DBR;

typedef union
  {
  struct
    {
    unsigned CWG1DBR0           : 1;
    unsigned CWG1DBR1           : 1;
    unsigned CWG1DBR2           : 1;
    unsigned CWG1DBR3           : 1;
    unsigned CWG1DBR4           : 1;
    unsigned CWG1DBR5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBR            : 6;
    unsigned                    : 2;
    };
  } __CWG1DBRbits_t;

extern __at(0x003C) volatile __CWG1DBRbits_t CWG1DBRbits;

#define _CWG1DBR0               0x01
#define _CWG1DBR1               0x02
#define _CWG1DBR2               0x04
#define _CWG1DBR3               0x08
#define _CWG1DBR4               0x10
#define _CWG1DBR5               0x20

//==============================================================================


//==============================================================================
//        CWG1DBF Bits

extern __at(0x003D) __sfr CWG1DBF;

typedef union
  {
  struct
    {
    unsigned CWG1DBF0           : 1;
    unsigned CWG1DBF1           : 1;
    unsigned CWG1DBF2           : 1;
    unsigned CWG1DBF3           : 1;
    unsigned CWG1DBF4           : 1;
    unsigned CWG1DBF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBF            : 6;
    unsigned                    : 2;
    };
  } __CWG1DBFbits_t;

extern __at(0x003D) volatile __CWG1DBFbits_t CWG1DBFbits;

#define _CWG1DBF0               0x01
#define _CWG1DBF1               0x02
#define _CWG1DBF2               0x04
#define _CWG1DBF3               0x08
#define _CWG1DBF4               0x10
#define _CWG1DBF5               0x20

//==============================================================================


//==============================================================================
//        VREGCON Bits

extern __at(0x003E) __sfr VREGCON;

typedef union
  {
  struct
    {
    unsigned VREGPM0            : 1;
    unsigned VREGPM1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned VREGPM             : 2;
    unsigned                    : 6;
    };
  } __VREGCONbits_t;

extern __at(0x003E) volatile __VREGCONbits_t VREGCONbits;

#define _VREGPM0                0x01
#define _VREGPM1                0x02

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x003F) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x003F) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG                 0x2007

//----------------------------- CONFIG Options -------------------------------

#define _FOSC_INTOSC            0x3FFE  // INTOSC oscillator: CLKIN function disabled.
#define _FOSC_EC                0x3FFF  // EC: CLKIN function enabled.
#define _BOREN_OFF              0x3FF9  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0x3FFB  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3FFD  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _WDTE_OFF               0x3FE7  // WDT disabled.
#define _WDTE_SWDTEN            0x3FEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR pin function is digital input, MCLR internally tied to VDD.
#define _MCLRE_ON               0x3FFF  // MCLR pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _LVP_OFF                0x3EFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.
#define _LPBOR_OFF              0x3DFF  // BOR disabled.
#define _LPBOR_ON               0x3FFF  // BOR enabled.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_27                0x3BFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _BORV_24                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _WRT_ALL                0x27FF  // 000h to 1FFh write protected, no addresses may be modified by PMCON control.
#define _WRT_HALF               0x2FFF  // 000h to 0FFh write protected, 100h to 1FFh may be modified by PMCON control.
#define _WRT_BOOT               0x37FF  // 000h to 07Fh write protected, 080h to 1FFh may be modified by PMCON control.
#define _WRT_OFF                0x3FFF  // Write protection off.

//==============================================================================

#define _DEVID1                 0x2006

#define _IDLOC0                 0x2000
#define _IDLOC1                 0x2001
#define _IDLOC2                 0x2002
#define _IDLOC3                 0x2003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCONbits.ADON                  // bit 0
#define GO_NOT_DONE             ADCONbits.GO_NOT_DONE           // bit 1
#define CHS0                    ADCONbits.CHS0                  // bit 2
#define CHS1                    ADCONbits.CHS1                  // bit 3
#define CHS2                    ADCONbits.CHS2                  // bit 4
#define ADCS0                   ADCONbits.ADCS0                 // bit 5
#define ADCS1                   ADCONbits.ADCS1                 // bit 6
#define ADCS2                   ADCONbits.ADCS2                 // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define LC1MODE0                CLC1CONbits.LC1MODE0            // bit 0, shadows bit in CLC1CONbits
#define LCMODE0                 CLC1CONbits.LCMODE0             // bit 0, shadows bit in CLC1CONbits
#define LC1MODE1                CLC1CONbits.LC1MODE1            // bit 1, shadows bit in CLC1CONbits
#define LCMODE1                 CLC1CONbits.LCMODE1             // bit 1, shadows bit in CLC1CONbits
#define LC1MODE2                CLC1CONbits.LC1MODE2            // bit 2, shadows bit in CLC1CONbits
#define LCMODE2                 CLC1CONbits.LCMODE2             // bit 2, shadows bit in CLC1CONbits
#define LC1INTN                 CLC1CONbits.LC1INTN             // bit 3, shadows bit in CLC1CONbits
#define LCINTN                  CLC1CONbits.LCINTN              // bit 3, shadows bit in CLC1CONbits
#define LC1INTP                 CLC1CONbits.LC1INTP             // bit 4, shadows bit in CLC1CONbits
#define LCINTP                  CLC1CONbits.LCINTP              // bit 4, shadows bit in CLC1CONbits
#define LC1OUT                  CLC1CONbits.LC1OUT              // bit 5, shadows bit in CLC1CONbits
#define LCOUT                   CLC1CONbits.LCOUT               // bit 5, shadows bit in CLC1CONbits
#define LC1OE                   CLC1CONbits.LC1OE               // bit 6, shadows bit in CLC1CONbits
#define LCOE                    CLC1CONbits.LCOE                // bit 6, shadows bit in CLC1CONbits
#define LC1EN                   CLC1CONbits.LC1EN               // bit 7, shadows bit in CLC1CONbits
#define LCEN                    CLC1CONbits.LCEN                // bit 7, shadows bit in CLC1CONbits

#define LC1G1D1N                CLC1GLS0bits.LC1G1D1N           // bit 0, shadows bit in CLC1GLS0bits
#define D1N                     CLC1GLS0bits.D1N                // bit 0, shadows bit in CLC1GLS0bits
#define LC1G1D1T                CLC1GLS0bits.LC1G1D1T           // bit 1, shadows bit in CLC1GLS0bits
#define D1T                     CLC1GLS0bits.D1T                // bit 1, shadows bit in CLC1GLS0bits
#define LC1G1D2N                CLC1GLS0bits.LC1G1D2N           // bit 2, shadows bit in CLC1GLS0bits
#define D2N                     CLC1GLS0bits.D2N                // bit 2, shadows bit in CLC1GLS0bits
#define LC1G1D2T                CLC1GLS0bits.LC1G1D2T           // bit 3, shadows bit in CLC1GLS0bits
#define D2T                     CLC1GLS0bits.D2T                // bit 3, shadows bit in CLC1GLS0bits
#define LC1G1D3N                CLC1GLS0bits.LC1G1D3N           // bit 4, shadows bit in CLC1GLS0bits
#define D3N                     CLC1GLS0bits.D3N                // bit 4, shadows bit in CLC1GLS0bits
#define LC1G1D3T                CLC1GLS0bits.LC1G1D3T           // bit 5, shadows bit in CLC1GLS0bits
#define D3T                     CLC1GLS0bits.D3T                // bit 5, shadows bit in CLC1GLS0bits
#define LC1G1D4N                CLC1GLS0bits.LC1G1D4N           // bit 6, shadows bit in CLC1GLS0bits
#define D4N                     CLC1GLS0bits.D4N                // bit 6, shadows bit in CLC1GLS0bits
#define LC1G1D4T                CLC1GLS0bits.LC1G1D4T           // bit 7, shadows bit in CLC1GLS0bits
#define D4T                     CLC1GLS0bits.D4T                // bit 7, shadows bit in CLC1GLS0bits

#define LC1G4D1N                CLC1GLS3bits.LC1G4D1N           // bit 0, shadows bit in CLC1GLS3bits
#define G4D1N                   CLC1GLS3bits.G4D1N              // bit 0, shadows bit in CLC1GLS3bits
#define LC1G4D1T                CLC1GLS3bits.LC1G4D1T           // bit 1, shadows bit in CLC1GLS3bits
#define G4D1T                   CLC1GLS3bits.G4D1T              // bit 1, shadows bit in CLC1GLS3bits
#define LC1G4D2N                CLC1GLS3bits.LC1G4D2N           // bit 2, shadows bit in CLC1GLS3bits
#define G4D2N                   CLC1GLS3bits.G4D2N              // bit 2, shadows bit in CLC1GLS3bits
#define LC1G4D2T                CLC1GLS3bits.LC1G4D2T           // bit 3, shadows bit in CLC1GLS3bits
#define G4D2T                   CLC1GLS3bits.G4D2T              // bit 3, shadows bit in CLC1GLS3bits
#define LC1G4D3N                CLC1GLS3bits.LC1G4D3N           // bit 4, shadows bit in CLC1GLS3bits
#define G4D3N                   CLC1GLS3bits.G4D3N              // bit 4, shadows bit in CLC1GLS3bits
#define LC1G4D3T                CLC1GLS3bits.LC1G4D3T           // bit 5, shadows bit in CLC1GLS3bits
#define G4D3T                   CLC1GLS3bits.G4D3T              // bit 5, shadows bit in CLC1GLS3bits
#define LC1G4D4N                CLC1GLS3bits.LC1G4D4N           // bit 6, shadows bit in CLC1GLS3bits
#define G4D4N                   CLC1GLS3bits.G4D4N              // bit 6, shadows bit in CLC1GLS3bits
#define LC1G4D4T                CLC1GLS3bits.LC1G4D4T           // bit 7, shadows bit in CLC1GLS3bits
#define G4D4T                   CLC1GLS3bits.G4D4T              // bit 7, shadows bit in CLC1GLS3bits

#define LC1G1POL                CLC1POLbits.LC1G1POL            // bit 0, shadows bit in CLC1POLbits
#define G1POL                   CLC1POLbits.G1POL               // bit 0, shadows bit in CLC1POLbits
#define LC1G2POL                CLC1POLbits.LC1G2POL            // bit 1, shadows bit in CLC1POLbits
#define G2POL                   CLC1POLbits.G2POL               // bit 1, shadows bit in CLC1POLbits
#define LC1G3POL                CLC1POLbits.LC1G3POL            // bit 2, shadows bit in CLC1POLbits
#define G3POL                   CLC1POLbits.G3POL               // bit 2, shadows bit in CLC1POLbits
#define LC1G4POL                CLC1POLbits.LC1G4POL            // bit 3, shadows bit in CLC1POLbits
#define G4POL                   CLC1POLbits.G4POL               // bit 3, shadows bit in CLC1POLbits
#define LC1POL                  CLC1POLbits.LC1POL              // bit 7, shadows bit in CLC1POLbits
#define POL                     CLC1POLbits.POL                 // bit 7, shadows bit in CLC1POLbits

#define LC1D1S0                 CLC1SEL0bits.LC1D1S0            // bit 0, shadows bit in CLC1SEL0bits
#define D1S0                    CLC1SEL0bits.D1S0               // bit 0, shadows bit in CLC1SEL0bits
#define LC1D1S1                 CLC1SEL0bits.LC1D1S1            // bit 1, shadows bit in CLC1SEL0bits
#define D1S1                    CLC1SEL0bits.D1S1               // bit 1, shadows bit in CLC1SEL0bits
#define LC1D1S2                 CLC1SEL0bits.LC1D1S2            // bit 2, shadows bit in CLC1SEL0bits
#define D1S2                    CLC1SEL0bits.D1S2               // bit 2, shadows bit in CLC1SEL0bits
#define LC1D2S0                 CLC1SEL0bits.LC1D2S0            // bit 4, shadows bit in CLC1SEL0bits
#define D2S0                    CLC1SEL0bits.D2S0               // bit 4, shadows bit in CLC1SEL0bits
#define LC1D2S1                 CLC1SEL0bits.LC1D2S1            // bit 5, shadows bit in CLC1SEL0bits
#define D2S1                    CLC1SEL0bits.D2S1               // bit 5, shadows bit in CLC1SEL0bits
#define LC1D2S2                 CLC1SEL0bits.LC1D2S2            // bit 6, shadows bit in CLC1SEL0bits
#define D2S2                    CLC1SEL0bits.D2S2               // bit 6, shadows bit in CLC1SEL0bits

#define LC1D3S0                 CLC1SEL1bits.LC1D3S0            // bit 0, shadows bit in CLC1SEL1bits
#define D3S0                    CLC1SEL1bits.D3S0               // bit 0, shadows bit in CLC1SEL1bits
#define LC1D3S1                 CLC1SEL1bits.LC1D3S1            // bit 1, shadows bit in CLC1SEL1bits
#define D3S1                    CLC1SEL1bits.D3S1               // bit 1, shadows bit in CLC1SEL1bits
#define LC1D3S2                 CLC1SEL1bits.LC1D3S2            // bit 2, shadows bit in CLC1SEL1bits
#define D3S2                    CLC1SEL1bits.D3S2               // bit 2, shadows bit in CLC1SEL1bits
#define LC1D4S0                 CLC1SEL1bits.LC1D4S0            // bit 4, shadows bit in CLC1SEL1bits
#define D4S0                    CLC1SEL1bits.D4S0               // bit 4, shadows bit in CLC1SEL1bits
#define LC1D4S1                 CLC1SEL1bits.LC1D4S1            // bit 5, shadows bit in CLC1SEL1bits
#define D4S1                    CLC1SEL1bits.D4S1               // bit 5, shadows bit in CLC1SEL1bits
#define LC1D4S2                 CLC1SEL1bits.LC1D4S2            // bit 6, shadows bit in CLC1SEL1bits
#define D4S2                    CLC1SEL1bits.D4S2               // bit 6, shadows bit in CLC1SEL1bits

#define CLKROE                  CLKRCONbits.CLKROE              // bit 6

#define G1CS0                   CWG1CON0bits.G1CS0              // bit 0
#define G1POLA                  CWG1CON0bits.G1POLA             // bit 3
#define G1POLB                  CWG1CON0bits.G1POLB             // bit 4
#define G1OEA                   CWG1CON0bits.G1OEA              // bit 5
#define G1OEB                   CWG1CON0bits.G1OEB              // bit 6
#define G1EN                    CWG1CON0bits.G1EN               // bit 7

#define G1IS0                   CWG1CON1bits.G1IS0              // bit 0
#define G1IS1                   CWG1CON1bits.G1IS1              // bit 1
#define G1ASDLA0                CWG1CON1bits.G1ASDLA0           // bit 4
#define G1ASDLA1                CWG1CON1bits.G1ASDLA1           // bit 5
#define G1ASDLB0                CWG1CON1bits.G1ASDLB0           // bit 6
#define G1ASDLB1                CWG1CON1bits.G1ASDLB1           // bit 7

#define G1ASDSFLT               CWG1CON2bits.G1ASDSFLT          // bit 0
#define G1ASDSCLC1              CWG1CON2bits.G1ASDSCLC1         // bit 1
#define G1ARSEN                 CWG1CON2bits.G1ARSEN            // bit 6
#define G1ASE                   CWG1CON2bits.G1ASE              // bit 7

#define CWG1DBF0                CWG1DBFbits.CWG1DBF0            // bit 0
#define CWG1DBF1                CWG1DBFbits.CWG1DBF1            // bit 1
#define CWG1DBF2                CWG1DBFbits.CWG1DBF2            // bit 2
#define CWG1DBF3                CWG1DBFbits.CWG1DBF3            // bit 3
#define CWG1DBF4                CWG1DBFbits.CWG1DBF4            // bit 4
#define CWG1DBF5                CWG1DBFbits.CWG1DBF5            // bit 5

#define CWG1DBR0                CWG1DBRbits.CWG1DBR0            // bit 0
#define CWG1DBR1                CWG1DBRbits.CWG1DBR1            // bit 1
#define CWG1DBR2                CWG1DBRbits.CWG1DBR2            // bit 2
#define CWG1DBR3                CWG1DBRbits.CWG1DBR3            // bit 3
#define CWG1DBR4                CWG1DBRbits.CWG1DBR4            // bit 4
#define CWG1DBR5                CWG1DBRbits.CWG1DBR5            // bit 5

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2

#define NCO1ACC8                NCO1ACCHbits.NCO1ACC8           // bit 0
#define NCO1ACC9                NCO1ACCHbits.NCO1ACC9           // bit 1
#define NCO1ACC10               NCO1ACCHbits.NCO1ACC10          // bit 2
#define NCO1ACC11               NCO1ACCHbits.NCO1ACC11          // bit 3
#define NCO1ACC12               NCO1ACCHbits.NCO1ACC12          // bit 4
#define NCO1ACC13               NCO1ACCHbits.NCO1ACC13          // bit 5
#define NCO1ACC14               NCO1ACCHbits.NCO1ACC14          // bit 6
#define NCO1ACC15               NCO1ACCHbits.NCO1ACC15          // bit 7

#define NCO1ACC0                NCO1ACCLbits.NCO1ACC0           // bit 0
#define NCO1ACC1                NCO1ACCLbits.NCO1ACC1           // bit 1
#define NCO1ACC2                NCO1ACCLbits.NCO1ACC2           // bit 2
#define NCO1ACC3                NCO1ACCLbits.NCO1ACC3           // bit 3
#define NCO1ACC4                NCO1ACCLbits.NCO1ACC4           // bit 4
#define NCO1ACC5                NCO1ACCLbits.NCO1ACC5           // bit 5
#define NCO1ACC6                NCO1ACCLbits.NCO1ACC6           // bit 6
#define NCO1ACC7                NCO1ACCLbits.NCO1ACC7           // bit 7

#define NCO1ACC16               NCO1ACCUbits.NCO1ACC16          // bit 0
#define NCO1ACC17               NCO1ACCUbits.NCO1ACC17          // bit 1
#define NCO1ACC18               NCO1ACCUbits.NCO1ACC18          // bit 2
#define NCO1ACC19               NCO1ACCUbits.NCO1ACC19          // bit 3

#define N1CKS0                  NCO1CLKbits.N1CKS0              // bit 0
#define N1CKS1                  NCO1CLKbits.N1CKS1              // bit 1
#define N1PWS0                  NCO1CLKbits.N1PWS0              // bit 5
#define N1PWS1                  NCO1CLKbits.N1PWS1              // bit 6
#define N1PWS2                  NCO1CLKbits.N1PWS2              // bit 7

#define N1PFM                   NCO1CONbits.N1PFM               // bit 0
#define N1POL                   NCO1CONbits.N1POL               // bit 4
#define N1OUT                   NCO1CONbits.N1OUT               // bit 5
#define N1OE                    NCO1CONbits.N1OE                // bit 6
#define N1EN                    NCO1CONbits.N1EN                // bit 7

#define NCO1INC8                NCO1INCHbits.NCO1INC8           // bit 0
#define NCO1INC9                NCO1INCHbits.NCO1INC9           // bit 1
#define NCO1INC10               NCO1INCHbits.NCO1INC10          // bit 2
#define NCO1INC11               NCO1INCHbits.NCO1INC11          // bit 3
#define NCO1INC12               NCO1INCHbits.NCO1INC12          // bit 4
#define NCO1INC13               NCO1INCHbits.NCO1INC13          // bit 5
#define NCO1INC14               NCO1INCHbits.NCO1INC14          // bit 6
#define NCO1INC15               NCO1INCHbits.NCO1INC15          // bit 7

#define NCO1INC0                NCO1INCLbits.NCO1INC0           // bit 0
#define NCO1INC1                NCO1INCLbits.NCO1INC1           // bit 1
#define NCO1INC2                NCO1INCLbits.NCO1INC2           // bit 2
#define NCO1INC3                NCO1INCLbits.NCO1INC3           // bit 3
#define NCO1INC4                NCO1INCLbits.NCO1INC4           // bit 4
#define NCO1INC5                NCO1INCLbits.NCO1INC5           // bit 5
#define NCO1INC6                NCO1INCLbits.NCO1INC6           // bit 6
#define NCO1INC7                NCO1INCLbits.NCO1INC7           // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define T0SE                    OPTION_REGbits.T0SE             // bit 4
#define T0CS                    OPTION_REGbits.T0CS             // bit 5
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define HFIOFS                  OSCCONbits.HFIOFS               // bit 0
#define LFIOFR                  OSCCONbits.LFIOFR               // bit 1
#define HFIOFR                  OSCCONbits.HFIOFR               // bit 3
#define IRCF0                   OSCCONbits.IRCF0                // bit 4
#define IRCF1                   OSCCONbits.IRCF1                // bit 5
#define IRCF2                   OSCCONbits.IRCF2                // bit 6

#define PCLH0                   PCLATHbits.PCLH0                // bit 0

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1

#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CLC1IE                  PIE1bits.CLC1IE                 // bit 3
#define NCO1IE                  PIE1bits.NCO1IE                 // bit 4
#define ADIE                    PIE1bits.ADIE                   // bit 6

#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CLC1IF                  PIR1bits.CLC1IF                 // bit 3
#define NCO1IF                  PIR1bits.NCO1IF                 // bit 4
#define ADIF                    PIR1bits.ADIF                   // bit 6

#define PMADR8                  PMADRHbits.PMADR8               // bit 0

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3

#define PWM1POL                 PWM1CONbits.PWM1POL             // bit 4
#define PWM1OUT                 PWM1CONbits.PWM1OUT             // bit 5
#define PWM1OE                  PWM1CONbits.PWM1OE              // bit 6
#define PWM1EN                  PWM1CONbits.PWM1EN              // bit 7

#define PWM1DCH0                PWM1DCHbits.PWM1DCH0            // bit 0
#define PWM1DCH1                PWM1DCHbits.PWM1DCH1            // bit 1
#define PWM1DCH2                PWM1DCHbits.PWM1DCH2            // bit 2
#define PWM1DCH3                PWM1DCHbits.PWM1DCH3            // bit 3
#define PWM1DCH4                PWM1DCHbits.PWM1DCH4            // bit 4
#define PWM1DCH5                PWM1DCHbits.PWM1DCH5            // bit 5
#define PWM1DCH6                PWM1DCHbits.PWM1DCH6            // bit 6
#define PWM1DCH7                PWM1DCHbits.PWM1DCH7            // bit 7

#define PWM1DCL0                PWM1DCLbits.PWM1DCL0            // bit 6
#define PWM1DCL1                PWM1DCLbits.PWM1DCL1            // bit 7

#define PWM2POL                 PWM2CONbits.PWM2POL             // bit 4
#define PWM2OUT                 PWM2CONbits.PWM2OUT             // bit 5
#define PWM2OE                  PWM2CONbits.PWM2OE              // bit 6
#define PWM2EN                  PWM2CONbits.PWM2EN              // bit 7

#define PWM2DCH0                PWM2DCHbits.PWM2DCH0            // bit 0
#define PWM2DCH1                PWM2DCHbits.PWM2DCH1            // bit 1
#define PWM2DCH2                PWM2DCHbits.PWM2DCH2            // bit 2
#define PWM2DCH3                PWM2DCHbits.PWM2DCH3            // bit 3
#define PWM2DCH4                PWM2DCHbits.PWM2DCH4            // bit 4
#define PWM2DCH5                PWM2DCHbits.PWM2DCH5            // bit 5
#define PWM2DCH6                PWM2DCHbits.PWM2DCH6            // bit 6
#define PWM2DCH7                PWM2DCHbits.PWM2DCH7            // bit 7

#define PWM2DCL0                PWM2DCLbits.PWM2DCL0            // bit 6
#define PWM2DCL1                PWM2DCLbits.PWM2DCL1            // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4
#define RP0                     STATUSbits.RP0                  // bit 5
#define RP1                     STATUSbits.RP1                  // bit 6
#define IRP                     STATUSbits.IRP                  // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define TOUTPS0                 T2CONbits.TOUTPS0               // bit 3
#define TOUTPS1                 T2CONbits.TOUTPS1               // bit 4
#define TOUTPS2                 T2CONbits.TOUTPS2               // bit 5
#define TOUTPS3                 T2CONbits.TOUTPS3               // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2

#define VREGPM0                 VREGCONbits.VREGPM0             // bit 0
#define VREGPM1                 VREGCONbits.VREGPM1             // bit 1

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC10F322_H__
