/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.UnknownHandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnknownHandshakeParser
extends HandshakeMessageParser<UnknownHandshakeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public UnknownHandshakeParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, HandshakeMessageType.UNKNOWN, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(UnknownHandshakeMessage msg) {
        LOGGER.debug("Parsing UnknownHandshakeMessage");
        this.parseData(msg);
        LOGGER.warn("Parsed UnknownHandshake Message: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getData().getValue()), (boolean)false));
    }

    @Override
    protected UnknownHandshakeMessage createHandshakeMessage() {
        return new UnknownHandshakeMessage();
    }

    private void parseData(UnknownHandshakeMessage msg) {
        msg.setData(this.parseByteArrayField((Integer)msg.getLength().getValue()));
        LOGGER.debug("Data: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getData().getValue())));
    }
}

