/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.notes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public class Note {
    public static final Comparator<Note> DEFAULT_COMPARATOR = (n1, n2) -> {
        if (n1.getId() < 0L && n2.getId() > 0L) {
            return 1;
        }
        if (n1.getId() > 0L && n2.getId() < 0L) {
            return -1;
        }
        if (n1.getState() == State.CLOSED && n2.getState() == State.OPEN) {
            return 1;
        }
        if (n1.getState() == State.OPEN && n2.getState() == State.CLOSED) {
            return -1;
        }
        return Long.compare(Math.abs(n1.getId()), Math.abs(n2.getId()));
    };
    public static final Comparator<Note> DATE_COMPARATOR = (n1, n2) -> n1.createdAt.compareTo(n2.createdAt);
    public static final Comparator<Note> USER_COMPARATOR = (n1, n2) -> {
        String n2User;
        String n1User = n1.getFirstComment().getUser().getName();
        return n1User.equals(n2User = n2.getFirstComment().getUser().getName()) ? DATE_COMPARATOR.compare((Note)n1, (Note)n2) : n1User.compareTo(n2User);
    };
    public static final Comparator<Note> LAST_ACTION_COMPARATOR = (n1, n2) -> NoteComment.DATE_COMPARATOR.compare(n1.getLastComment(), n2.getLastComment());
    private long id;
    private LatLon latLon;
    private Date createdAt;
    private Date closedAt;
    private State state;
    private List<NoteComment> comments = new ArrayList<NoteComment>();

    public Note(LatLon latLon) {
        this.latLon = latLon;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public Date getCreatedAt() {
        return DateUtils.cloneDate(this.createdAt);
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = DateUtils.cloneDate(createdAt);
    }

    public Date getClosedAt() {
        return DateUtils.cloneDate(this.closedAt);
    }

    public void setClosedAt(Date closedAt) {
        this.closedAt = DateUtils.cloneDate(closedAt);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public List<NoteComment> getComments() {
        return this.comments;
    }

    public NoteComment getLastComment() {
        return this.comments.isEmpty() ? null : this.comments.get(this.comments.size() - 1);
    }

    public void addComment(NoteComment comment) {
        this.comments.add(comment);
    }

    public NoteComment getFirstComment() {
        return this.comments.isEmpty() ? null : this.comments.get(0);
    }

    public void updateWith(Note note) {
        this.comments = note.comments;
        this.createdAt = DateUtils.cloneDate(note.createdAt);
        this.id = note.id;
        this.state = note.state;
        this.latLon = note.latLon;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Note note = (Note)obj;
        return this.id == note.id;
    }

    public String toString() {
        return I18n.tr("Note", new Object[0]) + ' ' + this.id + ": " + this.getFirstComment();
    }

    public static enum State {
        OPEN,
        CLOSED;

    }
}

