/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import java.awt.Color;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.util.ColorUtil;

public class BorderProps
implements Serializable {
    public static final int SEPARATE = 0;
    public static final int COLLAPSE_INNER = 1;
    public static final int COLLAPSE_OUTER = 2;
    public int style;
    public Color color;
    public int width;
    public int mode;

    public BorderProps(int style, int width, Color color, int mode) {
        this.style = style;
        this.width = width;
        this.color = color;
        this.mode = mode;
    }

    public BorderProps(String style, int width, Color color, int mode) {
        this(BorderProps.getConstantForStyle(style), width, color, mode);
    }

    public static int getClippedWidth(BorderProps bp) {
        if (bp != null && bp.mode != 0) {
            return bp.width / 2;
        }
        return 0;
    }

    private String getStyleString() {
        switch (this.style) {
            case 95: {
                return "none";
            }
            case 57: {
                return "hidden";
            }
            case 36: {
                return "dotted";
            }
            case 31: {
                return "dashed";
            }
            case 133: {
                return "solid";
            }
            case 37: {
                return "double";
            }
            case 55: {
                return "groove";
            }
            case 119: {
                return "ridge";
            }
            case 67: {
                return "inset";
            }
            case 101: {
                return "outset";
            }
        }
        throw new IllegalStateException("Illegal border style: " + this.style);
    }

    private static int getConstantForStyle(String style) {
        if ("none".equalsIgnoreCase(style)) {
            return 95;
        }
        if ("hidden".equalsIgnoreCase(style)) {
            return 57;
        }
        if ("dotted".equalsIgnoreCase(style)) {
            return 36;
        }
        if ("dashed".equalsIgnoreCase(style)) {
            return 31;
        }
        if ("solid".equalsIgnoreCase(style)) {
            return 133;
        }
        if ("double".equalsIgnoreCase(style)) {
            return 37;
        }
        if ("groove".equalsIgnoreCase(style)) {
            return 55;
        }
        if ("ridge".equalsIgnoreCase(style)) {
            return 119;
        }
        if ("inset".equalsIgnoreCase(style)) {
            return 67;
        }
        if ("outset".equalsIgnoreCase(style)) {
            return 101;
        }
        throw new IllegalStateException("Illegal border style: " + style);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BorderProps) {
            BorderProps other = (BorderProps)obj;
            return this.style == other.style && this.color.equals(other.color) && this.width == other.width && this.mode == other.mode;
        }
        return false;
    }

    public static BorderProps valueOf(FOUserAgent foUserAgent, String s) {
        if (s.startsWith("(") && s.endsWith(")")) {
            Color c;
            s = s.substring(1, s.length() - 1);
            StringTokenizer st = new StringTokenizer(s, ",");
            String style = st.nextToken();
            String color = st.nextToken();
            int width = Integer.parseInt(st.nextToken());
            int mode = 0;
            if (st.hasMoreTokens()) {
                String ms = st.nextToken();
                if ("collapse-inner".equalsIgnoreCase(ms)) {
                    mode = 1;
                } else if ("collapse-outer".equalsIgnoreCase(ms)) {
                    mode = 2;
                }
            }
            try {
                c = ColorUtil.parseColorString(foUserAgent, color);
            }
            catch (PropertyException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return new BorderProps(style, width, c, mode);
        }
        throw new IllegalArgumentException("BorderProps must be surrounded by parentheses");
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        sbuf.append(this.getStyleString());
        sbuf.append(',');
        sbuf.append(ColorUtil.colorToString(this.color));
        sbuf.append(',');
        sbuf.append(this.width);
        if (this.mode != 0) {
            sbuf.append(',');
            if (this.mode == 1) {
                sbuf.append("collapse-inner");
            } else {
                sbuf.append("collapse-outer");
            }
        }
        sbuf.append(')');
        return sbuf.toString();
    }
}

