/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.io.File;
import java.io.IOException;

public final class FileHelper {
    public static final void delete(File file) throws IOException {
        if (file != null && !file.delete()) {
            throw new IOException("Failed to delete file");
        }
    }

    public static final void deleteQuietly(File file) {
        if (file != null) {
            File[] fileArray;
            if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (File file2 : fileArray) {
                    FileHelper.deleteQuietly(file2);
                }
            }
            file.delete();
        }
    }

    public static final void mkdirs(File file) throws IOException {
        if (file != null && !file.mkdirs()) {
            throw new IOException("Failed to create directories");
        }
    }

    public static final void mkdirsQuietly(File file) {
        if (file != null) {
            file.mkdirs();
        }
    }

    public static final File createTempDir() throws IOException {
        File file = File.createTempFile("mpxj", "tmp");
        FileHelper.delete(file);
        FileHelper.mkdirs(file);
        return file;
    }

    public static final void createNewFile(File file) throws IOException {
        if (!file.createNewFile()) {
            throw new IOException("Failed to create new file");
        }
    }
}

