/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.internal.Errors;
import com.google.inject.servlet.DefaultFilterPipeline;
import com.google.inject.servlet.FilterPipeline;
import com.google.inject.servlet.ManagedFilterPipeline;
import com.google.inject.servlet.RequestScoper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class GuiceFilter
implements Filter {
    static final ThreadLocal<Context> localContext = new ThreadLocal();
    static volatile FilterPipeline pipeline = new DefaultFilterPipeline();
    private final FilterPipeline injectedPipeline;
    static volatile WeakReference<ServletContext> servletContext = new WeakReference<Object>(null);
    private static final String MULTIPLE_INJECTORS_WARNING = "Multiple Servlet injectors detected. This is a warning indicating that you have more than one " + GuiceFilter.class.getSimpleName() + " running in your web application. If this is deliberate, you may safely ignore this message. If this is NOT deliberate however, your application may not work as expected.";
    private static final Logger LOGGER = Logger.getLogger(GuiceFilter.class.getName());

    public GuiceFilter() {
        this(null);
    }

    @Inject
    GuiceFilter(FilterPipeline filterPipeline) {
        this.injectedPipeline = filterPipeline;
    }

    @Inject
    static void setPipeline(FilterPipeline pipeline) {
        if (GuiceFilter.pipeline instanceof ManagedFilterPipeline) {
            LOGGER.warning(MULTIPLE_INJECTORS_WARNING);
        }
        GuiceFilter.pipeline = pipeline;
    }

    static void reset() {
        pipeline = new DefaultFilterPipeline();
        localContext.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        FilterPipeline filterPipeline = this.getFilterPipeline();
        Context previous = localContext.get();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest originalRequest = previous != null ? previous.getOriginalRequest() : request;
        try (RequestScoper.CloseableScope scope = new Context(originalRequest, request, response).open();){
            filterPipeline.dispatch(servletRequest, servletResponse, filterChain);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    static HttpServletRequest getOriginalRequest(Key<?> key) {
        return GuiceFilter.getContext(key).getOriginalRequest();
    }

    static HttpServletRequest getRequest(Key<?> key) {
        return GuiceFilter.getContext(key).getRequest();
    }

    static HttpServletResponse getResponse(Key<?> key) {
        return GuiceFilter.getContext(key).getResponse();
    }

    static ServletContext getServletContext() {
        return (ServletContext)servletContext.get();
    }

    private static Context getContext(Key<?> key) {
        Context context = localContext.get();
        if (context == null) {
            throw new OutOfScopeException("Cannot access scoped [" + Errors.convert(key) + "]. Either we are not currently inside an HTTP Servlet request, or you may have forgotten to apply " + GuiceFilter.class.getName() + " as a servlet filter for this request.");
        }
        return context;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        GuiceFilter.servletContext = new WeakReference<ServletContext>(servletContext);
        FilterPipeline filterPipeline = this.getFilterPipeline();
        filterPipeline.initPipeline(servletContext);
    }

    public void destroy() {
        try {
            FilterPipeline filterPipeline = this.getFilterPipeline();
            filterPipeline.destroyPipeline();
        }
        finally {
            GuiceFilter.reset();
            servletContext.clear();
        }
    }

    private FilterPipeline getFilterPipeline() {
        return null != this.injectedPipeline ? this.injectedPipeline : pipeline;
    }

    static class Context
    implements RequestScoper {
        final HttpServletRequest originalRequest;
        final HttpServletRequest request;
        final HttpServletResponse response;
        final Lock lock = new ReentrantLock();

        Context(HttpServletRequest originalRequest, HttpServletRequest request, HttpServletResponse response) {
            this.originalRequest = originalRequest;
            this.request = request;
            this.response = response;
        }

        HttpServletRequest getOriginalRequest() {
            return this.originalRequest;
        }

        HttpServletRequest getRequest() {
            return this.request;
        }

        HttpServletResponse getResponse() {
            return this.response;
        }

        @Override
        public RequestScoper.CloseableScope open() {
            this.lock.lock();
            final Context previous = localContext.get();
            localContext.set(this);
            return new RequestScoper.CloseableScope(){

                @Override
                public void close() {
                    localContext.set(previous);
                    lock.unlock();
                }
            };
        }
    }
}

