

#let code-block(code, language, title: none) = {
  v(6pt)

  if (title != none) {
    text(10pt, style: "italic", title) 
    linebreak()
  }
  code(code, lang: language)
  v(6pt)
}

#let remarque(content, bg-color: silver, text-color: black) = {
  v(4pt)
  block(
    fill: bg-color,
    width: 100%,
    inset: 8pt,
    radius: 4pt,
    text(10pt, content, fill: text-color)
  )
}


#let attribute_ref_name(
    parent: "",
    tag: "") = [
#tag in #parent
]

#let attribute(
    parent: "",
    tag: "",
    nature: none,
    required: true,
    content
) = [

#let nature_text= text(font: "Libertinus Serif", style: "italic", weight: "thin")[#nature]
#let if_required= text(font: "Libertinus Serif", style: "italic", fill: teal)[Optional]
#if (required) {if_required=text(font: "Libertinus Serif", style: "italic", fill: red)[Required]}
#figure(kind: "attribute", supplement: attribute_ref_name(parent: parent, tag:tag),[
/ #tag: (#nature_text) #if_required #content
]) #label("attribute-" + parent + "-" + tag)
]



#let to-string(it) = {
  if type(it) == str {
    it
  } else if type(it) != content {
    str(it)
  } else if it.has("text") {
    it.text
  } else if it.has("children") {
    it.children.map(to-string).join()
  } else if it.has("body") {
    to-string(it.body)
  } else if it == [ ] {
    " "
  }
}
