/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt;

import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.lisaac.ldt.builder.LisaacChangeListener;
import org.osgi.framework.BundleContext;

public class LisaacPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.lisaac.ldt";
    private static LisaacPlugin plugin;
    private TemplateStore fStore;
    private ContextTypeRegistry fRegistry;
    private static final String TEMPLATES_KEY = "org.lisaac.ldt.templatepreferences";

    public TemplateStore getTemplateStore() {
        if (this.fStore == null) {
            this.fStore = new ContributionTemplateStore(this.getContextTypeRegistry(), LisaacPlugin.getDefault().getPreferenceStore(), TEMPLATES_KEY);
            try {
                this.fStore.load();
            }
            catch (IOException e) {
                LisaacPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, "", (Throwable)e));
            }
        }
        return this.fStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType("org.lisaac.ldt.contexttype");
            this.fRegistry = registry;
        }
        return this.fRegistry;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new LisaacChangeListener());
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i] != null && projects[i].isOpen() && projects[i].getNature("org.lisaac.ldt.lisaac") != null) {
                    try {
                        IFolder bin = projects[i].getFolder("lib");
                        if (bin.exists()) {
                            bin.delete(true, null);
                        }
                        projects[i].build(6, null);
                    }
                    catch (Exception e) {
                        LisaacPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, "Error loading " + projects[i].getName(), (Throwable)e));
                    }
                }
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static LisaacPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return LisaacPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void log(IStatus status) {
        LisaacPlugin.getDefault().getLog().log(status);
    }
}

