
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_sstruct_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructAxpy_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_SStructVector x, HYPRE_SStructVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructAxpy_flt( alpha, x, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructAxpy_dbl( alpha, x, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructAxpy_long_dbl( alpha, x, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphAddEntries_pre( HYPRE_Precision precision, HYPRE_SStructGraph graph, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, HYPRE_Int to_part, HYPRE_Int *to_index, HYPRE_Int to_var )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGraphAddEntries_flt( graph, part, index, var, to_part, to_index, to_var );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGraphAddEntries_dbl( graph, part, index, var, to_part, to_index, to_var );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGraphAddEntries_long_dbl( graph, part, index, var, to_part, to_index, to_var );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphAssemble_pre( HYPRE_Precision precision, HYPRE_SStructGraph graph )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGraphAssemble_flt( graph );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGraphAssemble_dbl( graph );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGraphAssemble_long_dbl( graph );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_SStructGrid grid, HYPRE_SStructGraph *graph )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGraphCreate_flt( comm, grid, graph );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGraphCreate_dbl( comm, grid, graph );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGraphCreate_long_dbl( comm, grid, graph );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphDestroy_pre( HYPRE_Precision precision, HYPRE_SStructGraph graph )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGraphDestroy_flt( graph );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGraphDestroy_dbl( graph );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGraphDestroy_long_dbl( graph );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphPrint_pre( HYPRE_Precision precision, FILE *file, HYPRE_SStructGraph graph )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGraphPrint_flt( file, graph );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGraphPrint_dbl( file, graph );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGraphPrint_long_dbl( file, graph );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphRead_pre( HYPRE_Precision precision, FILE *file, HYPRE_SStructGrid grid, HYPRE_SStructStencil **stencils, HYPRE_SStructGraph *graph_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGraphRead_flt( file, grid, stencils, graph_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGraphRead_dbl( file, grid, stencils, graph_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGraphRead_long_dbl( file, grid, stencils, graph_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphSetDomainGrid_pre( HYPRE_Precision precision, HYPRE_SStructGraph graph, HYPRE_SStructGrid domain_grid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGraphSetDomainGrid_flt( graph, domain_grid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGraphSetDomainGrid_dbl( graph, domain_grid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGraphSetDomainGrid_long_dbl( graph, domain_grid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphSetFEM_pre( HYPRE_Precision precision, HYPRE_SStructGraph graph, HYPRE_Int part )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGraphSetFEM_flt( graph, part );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGraphSetFEM_dbl( graph, part );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGraphSetFEM_long_dbl( graph, part );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphSetFEMSparsity_pre( HYPRE_Precision precision, HYPRE_SStructGraph graph, HYPRE_Int part, HYPRE_Int nsparse, HYPRE_Int *sparsity )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGraphSetFEMSparsity_flt( graph, part, nsparse, sparsity );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGraphSetFEMSparsity_dbl( graph, part, nsparse, sparsity );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGraphSetFEMSparsity_long_dbl( graph, part, nsparse, sparsity );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphSetObjectType_pre( HYPRE_Precision precision, HYPRE_SStructGraph graph, HYPRE_Int type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGraphSetObjectType_flt( graph, type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGraphSetObjectType_dbl( graph, type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGraphSetObjectType_long_dbl( graph, type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGraphSetStencil_pre( HYPRE_Precision precision, HYPRE_SStructGraph graph, HYPRE_Int part, HYPRE_Int var, HYPRE_SStructStencil stencil )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGraphSetStencil_flt( graph, part, var, stencil );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGraphSetStencil_dbl( graph, part, var, stencil );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGraphSetStencil_long_dbl( graph, part, var, stencil );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridAddVariables_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int nvars, HYPRE_SStructVariable *vartypes )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridAddVariables_flt( grid, part, index, nvars, vartypes );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridAddVariables_dbl( grid, part, index, nvars, vartypes );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridAddVariables_long_dbl( grid, part, index, nvars, vartypes );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridAssemble_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridAssemble_flt( grid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridAssemble_dbl( grid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridAssemble_long_dbl( grid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridCoarsen_pre( HYPRE_Precision precision, HYPRE_SStructGrid fgrid, HYPRE_Index *strides, HYPRE_SStructGrid *cgrid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridCoarsen_flt( fgrid, strides, cgrid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridCoarsen_dbl( fgrid, strides, cgrid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridCoarsen_long_dbl( fgrid, strides, cgrid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Int ndim, HYPRE_Int nparts, HYPRE_SStructGrid *grid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridCreate_flt( comm, ndim, nparts, grid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridCreate_dbl( comm, ndim, nparts, grid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridCreate_long_dbl( comm, ndim, nparts, grid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridDestroy_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridDestroy_flt( grid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridDestroy_dbl( grid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridDestroy_long_dbl( grid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridGetVariableBox_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int var, HYPRE_Int *cell_ilower, HYPRE_Int *cell_iupper, HYPRE_Int *var_ilower, HYPRE_Int *var_iupper )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridGetVariableBox_flt( grid, part, var, cell_ilower, cell_iupper, var_ilower, var_iupper );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridGetVariableBox_dbl( grid, part, var, cell_ilower, cell_iupper, var_ilower, var_iupper );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridGetVariableBox_long_dbl( grid, part, var, cell_ilower, cell_iupper, var_ilower, var_iupper );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridPrintGLVis_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid, const char *meshprefix, void *trans, void *origin )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridPrintGLVis_flt( grid, meshprefix, trans, origin );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridPrintGLVis_dbl( grid, meshprefix, trans, origin );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridPrintGLVis_long_dbl( grid, meshprefix, trans, origin );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridProjectBox_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *origin, HYPRE_Int *stride )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridProjectBox_flt( grid, ilower, iupper, origin, stride );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridProjectBox_dbl( grid, ilower, iupper, origin, stride );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridProjectBox_long_dbl( grid, ilower, iupper, origin, stride );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetExtents_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridSetExtents_flt( grid, part, ilower, iupper );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridSetExtents_dbl( grid, part, ilower, iupper );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridSetExtents_long_dbl( grid, part, ilower, iupper );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetFEMOrdering_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *ordering )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridSetFEMOrdering_flt( grid, part, ordering );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridSetFEMOrdering_dbl( grid, part, ordering );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridSetFEMOrdering_long_dbl( grid, part, ordering );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetNeighborPart_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nbor_part, HYPRE_Int *nbor_ilower, HYPRE_Int *nbor_iupper, HYPRE_Int *index_map, HYPRE_Int *index_dir )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridSetNeighborPart_flt( grid, part, ilower, iupper, nbor_part, nbor_ilower, nbor_iupper, index_map, index_dir );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridSetNeighborPart_dbl( grid, part, ilower, iupper, nbor_part, nbor_ilower, nbor_iupper, index_map, index_dir );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridSetNeighborPart_long_dbl( grid, part, ilower, iupper, nbor_part, nbor_ilower, nbor_iupper, index_map, index_dir );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetNumGhost_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid, HYPRE_Int *num_ghost )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridSetNumGhost_flt( grid, num_ghost );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridSetNumGhost_dbl( grid, num_ghost );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridSetNumGhost_long_dbl( grid, num_ghost );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetPeriodic_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *periodic )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridSetPeriodic_flt( grid, part, periodic );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridSetPeriodic_dbl( grid, part, periodic );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridSetPeriodic_long_dbl( grid, part, periodic );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetSharedPart_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *offset, HYPRE_Int shared_part, HYPRE_Int *shared_ilower, HYPRE_Int *shared_iupper, HYPRE_Int *shared_offset, HYPRE_Int *index_map, HYPRE_Int *index_dir )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridSetSharedPart_flt( grid, part, ilower, iupper, offset, shared_part, shared_ilower, shared_iupper, shared_offset, index_map, index_dir );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridSetSharedPart_dbl( grid, part, ilower, iupper, offset, shared_part, shared_ilower, shared_iupper, shared_offset, index_map, index_dir );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridSetSharedPart_long_dbl( grid, part, ilower, iupper, offset, shared_part, shared_ilower, shared_iupper, shared_offset, index_map, index_dir );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGridSetVariables_pre( HYPRE_Precision precision, HYPRE_SStructGrid grid, HYPRE_Int part, HYPRE_Int nvars, HYPRE_SStructVariable *vartypes )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructGridSetVariables_flt( grid, part, nvars, vartypes );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructGridSetVariables_dbl( grid, part, nvars, vartypes );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructGridSetVariables_long_dbl( grid, part, nvars, vartypes );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructInnerProd_pre( HYPRE_Precision precision, HYPRE_SStructVector x, HYPRE_SStructVector y, void *result )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructInnerProd_flt( x, y, result );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructInnerProd_dbl( x, y, result );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructInnerProd_long_dbl( x, y, result );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAddFEMBoxValues_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixAddFEMBoxValues_flt( matrix, part, ilower, iupper, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixAddFEMBoxValues_dbl( matrix, part, ilower, iupper, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixAddFEMBoxValues_long_dbl( matrix, part, ilower, iupper, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAddFEMValues_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixAddFEMValues_flt( matrix, part, index, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixAddFEMValues_dbl( matrix, part, index, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixAddFEMValues_long_dbl( matrix, part, index, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAddToBoxValues_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixAddToBoxValues_flt( matrix, part, ilower, iupper, var, nentries, entries, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixAddToBoxValues_dbl( matrix, part, ilower, iupper, var, nentries, entries, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixAddToBoxValues_long_dbl( matrix, part, ilower, iupper, var, nentries, entries, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAddToBoxValues2_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixAddToBoxValues2_flt( matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixAddToBoxValues2_dbl( matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixAddToBoxValues2_long_dbl( matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAddToValues_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixAddToValues_flt( matrix, part, index, var, nentries, entries, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixAddToValues_dbl( matrix, part, index, var, nentries, entries, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixAddToValues_long_dbl( matrix, part, index, var, nentries, entries, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixAssemble_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixAssemble_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixAssemble_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixAssemble_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_SStructGraph graph, HYPRE_SStructMatrix *matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixCreate_flt( comm, graph, matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixCreate_dbl( comm, graph, matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixCreate_long_dbl( comm, graph, matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixDestroy_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixDestroy_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixDestroy_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixDestroy_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetBoxValues_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixGetBoxValues_flt( matrix, part, ilower, iupper, var, nentries, entries, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixGetBoxValues_dbl( matrix, part, ilower, iupper, var, nentries, entries, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixGetBoxValues_long_dbl( matrix, part, ilower, iupper, var, nentries, entries, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetBoxValues2_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixGetBoxValues2_flt( matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixGetBoxValues2_dbl( matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixGetBoxValues2_long_dbl( matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetFEMValues_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixGetFEMValues_flt( matrix, part, index, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixGetFEMValues_dbl( matrix, part, index, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixGetFEMValues_long_dbl( matrix, part, index, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetGrid_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_SStructGrid *grid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixGetGrid_flt( matrix, grid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixGetGrid_dbl( matrix, grid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixGetGrid_long_dbl( matrix, grid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetObject_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, void **object )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixGetObject_flt( matrix, object );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixGetObject_dbl( matrix, object );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixGetObject_long_dbl( matrix, object );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixGetValues_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixGetValues_flt( matrix, part, index, var, nentries, entries, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixGetValues_dbl( matrix, part, index, var, nentries, entries, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixGetValues_long_dbl( matrix, part, index, var, nentries, entries, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixInitialize_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixInitialize_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixInitialize_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixInitialize_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixMatmat_pre( HYPRE_Precision precision, HYPRE_SStructMatrix A, HYPRE_SStructMatrix B, HYPRE_SStructMatrix *C )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixMatmat_flt( A, B, C );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixMatmat_dbl( A, B, C );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixMatmat_long_dbl( A, B, C );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixMatvec_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_SStructMatrix A, HYPRE_SStructVector x, hypre_long_double beta, HYPRE_SStructVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixMatvec_flt( alpha, A, x, beta, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixMatvec_dbl( alpha, A, x, beta, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixMatvec_long_dbl( alpha, A, x, beta, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixPrint_pre( HYPRE_Precision precision, const char *filename, HYPRE_SStructMatrix matrix, HYPRE_Int all )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixPrint_flt( filename, matrix, all );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixPrint_dbl( filename, matrix, all );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixPrint_long_dbl( filename, matrix, all );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixRead_pre( HYPRE_Precision precision, MPI_Comm comm, const char *filename, HYPRE_SStructMatrix *matrix_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixRead_flt( comm, filename, matrix_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixRead_dbl( comm, filename, matrix_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixRead_long_dbl( comm, filename, matrix_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetBoxValues_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixSetBoxValues_flt( matrix, part, ilower, iupper, var, nentries, entries, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixSetBoxValues_dbl( matrix, part, ilower, iupper, var, nentries, entries, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixSetBoxValues_long_dbl( matrix, part, ilower, iupper, var, nentries, entries, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetBoxValues2_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixSetBoxValues2_flt( matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixSetBoxValues2_dbl( matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixSetBoxValues2_long_dbl( matrix, part, ilower, iupper, var, nentries, entries, vilower, viupper, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetConstantEntries_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int var, HYPRE_Int to_var, HYPRE_Int nentries, HYPRE_Int *centries )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixSetConstantEntries_flt( matrix, part, var, to_var, nentries, centries );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixSetConstantEntries_dbl( matrix, part, var, to_var, nentries, centries );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixSetConstantEntries_long_dbl( matrix, part, var, to_var, nentries, centries );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetDomainStride_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *dom_stride )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixSetDomainStride_flt( matrix, part, dom_stride );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixSetDomainStride_dbl( matrix, part, dom_stride );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixSetDomainStride_long_dbl( matrix, part, dom_stride );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetEarlyAssemble_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int early_assemble )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixSetEarlyAssemble_flt( matrix, early_assemble );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixSetEarlyAssemble_dbl( matrix, early_assemble );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixSetEarlyAssemble_long_dbl( matrix, early_assemble );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetNSSymmetric_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int symmetric )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixSetNSSymmetric_flt( matrix, symmetric );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixSetNSSymmetric_dbl( matrix, symmetric );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixSetNSSymmetric_long_dbl( matrix, symmetric );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetObjectType_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixSetObjectType_flt( matrix, type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixSetObjectType_dbl( matrix, type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixSetObjectType_long_dbl( matrix, type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetRangeStride_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *ran_stride )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixSetRangeStride_flt( matrix, part, ran_stride );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixSetRangeStride_dbl( matrix, part, ran_stride );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixSetRangeStride_long_dbl( matrix, part, ran_stride );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetSymmetric_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int var, HYPRE_Int to_var, HYPRE_Int symmetric )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixSetSymmetric_flt( matrix, part, var, to_var, symmetric );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixSetSymmetric_dbl( matrix, part, var, to_var, symmetric );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixSetSymmetric_long_dbl( matrix, part, var, to_var, symmetric );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixSetValues_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixSetValues_flt( matrix, part, index, var, nentries, entries, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixSetValues_dbl( matrix, part, index, var, nentries, entries, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixSetValues_long_dbl( matrix, part, index, var, nentries, entries, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructMatrixToIJMatrix_pre( HYPRE_Precision precision, HYPRE_SStructMatrix matrix, HYPRE_Int fill_diagonal, HYPRE_IJMatrix *ijmatrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructMatrixToIJMatrix_flt( matrix, fill_diagonal, ijmatrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructMatrixToIJMatrix_dbl( matrix, fill_diagonal, ijmatrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructMatrixToIJMatrix_long_dbl( matrix, fill_diagonal, ijmatrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructStencilCreate_pre( HYPRE_Precision precision, HYPRE_Int ndim, HYPRE_Int size, HYPRE_SStructStencil *stencil )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructStencilCreate_flt( ndim, size, stencil );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructStencilCreate_dbl( ndim, size, stencil );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructStencilCreate_long_dbl( ndim, size, stencil );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructStencilDestroy_pre( HYPRE_Precision precision, HYPRE_SStructStencil stencil )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructStencilDestroy_flt( stencil );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructStencilDestroy_dbl( stencil );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructStencilDestroy_long_dbl( stencil );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructStencilPrint_pre( HYPRE_Precision precision, FILE *file, HYPRE_SStructStencil stencil )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructStencilPrint_flt( file, stencil );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructStencilPrint_dbl( file, stencil );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructStencilPrint_long_dbl( file, stencil );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructStencilRead_pre( HYPRE_Precision precision, FILE *file, HYPRE_SStructStencil *stencil_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructStencilRead_flt( file, stencil_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructStencilRead_dbl( file, stencil_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructStencilRead_long_dbl( file, stencil_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructStencilSetEntry_pre( HYPRE_Precision precision, HYPRE_SStructStencil stencil, HYPRE_Int entry, HYPRE_Int *offset, HYPRE_Int var )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructStencilSetEntry_flt( stencil, entry, offset, var );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructStencilSetEntry_dbl( stencil, entry, offset, var );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructStencilSetEntry_long_dbl( stencil, entry, offset, var );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAddFEMBoxValues_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorAddFEMBoxValues_flt( vector, part, ilower, iupper, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorAddFEMBoxValues_dbl( vector, part, ilower, iupper, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorAddFEMBoxValues_long_dbl( vector, part, ilower, iupper, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAddFEMValues_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *index, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorAddFEMValues_flt( vector, part, index, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorAddFEMValues_dbl( vector, part, index, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorAddFEMValues_long_dbl( vector, part, index, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAddToBoxValues_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorAddToBoxValues_flt( vector, part, ilower, iupper, var, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorAddToBoxValues_dbl( vector, part, ilower, iupper, var, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorAddToBoxValues_long_dbl( vector, part, ilower, iupper, var, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAddToBoxValues2_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorAddToBoxValues2_flt( vector, part, ilower, iupper, var, vilower, viupper, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorAddToBoxValues2_dbl( vector, part, ilower, iupper, var, vilower, viupper, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorAddToBoxValues2_long_dbl( vector, part, ilower, iupper, var, vilower, viupper, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAddToValues_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, void *value )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorAddToValues_flt( vector, part, index, var, value );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorAddToValues_dbl( vector, part, index, var, value );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorAddToValues_long_dbl( vector, part, index, var, value );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAssemble_pre( HYPRE_Precision precision, HYPRE_SStructVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorAssemble_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorAssemble_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorAssemble_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorAxpy_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_SStructVector x, HYPRE_SStructVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorAxpy_flt( alpha, x, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorAxpy_dbl( alpha, x, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorAxpy_long_dbl( alpha, x, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorCopy_pre( HYPRE_Precision precision, HYPRE_SStructVector x, HYPRE_SStructVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorCopy_flt( x, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorCopy_dbl( x, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorCopy_long_dbl( x, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_SStructGrid grid, HYPRE_SStructVector *vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorCreate_flt( comm, grid, vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorCreate_dbl( comm, grid, vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorCreate_long_dbl( comm, grid, vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorDestroy_pre( HYPRE_Precision precision, HYPRE_SStructVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorDestroy_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorDestroy_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorDestroy_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGather_pre( HYPRE_Precision precision, HYPRE_SStructVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorGather_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorGather_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorGather_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGetBoxValues_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorGetBoxValues_flt( vector, part, ilower, iupper, var, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorGetBoxValues_dbl( vector, part, ilower, iupper, var, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorGetBoxValues_long_dbl( vector, part, ilower, iupper, var, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGetBoxValues2_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorGetBoxValues2_flt( vector, part, ilower, iupper, var, vilower, viupper, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorGetBoxValues2_dbl( vector, part, ilower, iupper, var, vilower, viupper, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorGetBoxValues2_long_dbl( vector, part, ilower, iupper, var, vilower, viupper, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGetFEMValues_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *index, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorGetFEMValues_flt( vector, part, index, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorGetFEMValues_dbl( vector, part, index, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorGetFEMValues_long_dbl( vector, part, index, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGetObject_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, void **object )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorGetObject_flt( vector, object );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorGetObject_dbl( vector, object );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorGetObject_long_dbl( vector, object );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorGetValues_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, void *value )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorGetValues_flt( vector, part, index, var, value );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorGetValues_dbl( vector, part, index, var, value );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorGetValues_long_dbl( vector, part, index, var, value );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorInitialize_pre( HYPRE_Precision precision, HYPRE_SStructVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorInitialize_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorInitialize_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorInitialize_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorInnerProd_pre( HYPRE_Precision precision, HYPRE_SStructVector x, HYPRE_SStructVector y, void *result )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorInnerProd_flt( x, y, result );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorInnerProd_dbl( x, y, result );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorInnerProd_long_dbl( x, y, result );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorPrint_pre( HYPRE_Precision precision, const char *filename, HYPRE_SStructVector vector, HYPRE_Int all )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorPrint_flt( filename, vector, all );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorPrint_dbl( filename, vector, all );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorPrint_long_dbl( filename, vector, all );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorPrintGLVis_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, const char *fileprefix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorPrintGLVis_flt( vector, fileprefix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorPrintGLVis_dbl( vector, fileprefix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorPrintGLVis_long_dbl( vector, fileprefix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorRead_pre( HYPRE_Precision precision, MPI_Comm comm, const char *filename, HYPRE_SStructVector *vector_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorRead_flt( comm, filename, vector_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorRead_dbl( comm, filename, vector_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorRead_long_dbl( comm, filename, vector_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorScale_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_SStructVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorScale_flt( alpha, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorScale_dbl( alpha, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorScale_long_dbl( alpha, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetBoxValues_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorSetBoxValues_flt( vector, part, ilower, iupper, var, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorSetBoxValues_dbl( vector, part, ilower, iupper, var, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorSetBoxValues_long_dbl( vector, part, ilower, iupper, var, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetBoxValues2_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int var, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorSetBoxValues2_flt( vector, part, ilower, iupper, var, vilower, viupper, values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorSetBoxValues2_dbl( vector, part, ilower, iupper, var, vilower, viupper, values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorSetBoxValues2_long_dbl( vector, part, ilower, iupper, var, vilower, viupper, values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetConstantValues_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, hypre_long_double value )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorSetConstantValues_flt( vector, value );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorSetConstantValues_dbl( vector, value );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorSetConstantValues_long_dbl( vector, value );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetObjectType_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorSetObjectType_flt( vector, type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorSetObjectType_dbl( vector, type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorSetObjectType_long_dbl( vector, type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetRandomValues_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int seed )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorSetRandomValues_flt( vector, seed );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorSetRandomValues_dbl( vector, seed );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorSetRandomValues_long_dbl( vector, seed );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructVectorSetValues_pre( HYPRE_Precision precision, HYPRE_SStructVector vector, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, void *value )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SStructVectorSetValues_flt( vector, part, index, var, value );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SStructVectorSetValues_dbl( vector, part, index, var, value );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SStructVectorSetValues_long_dbl( vector, part, index, var, value );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}



#endif

