# GNOME Boxes

A simple GNOME application to access virtual machines.

[![Download on Flathub](https://flathub.org/api/badge?svg&locale=en)](https://flathub.org/apps/details/org.gnome.Boxes)

## Goals

* View, access, and use:
  * local virtual machines
  * When technology permits, set up access for applications on local virtual machines
* View, access, and use virtual machines on removable media
* View, access, and use shared connection / machines
* Share connections?
* Upload / publish virtual machines
* Select favorites
* Search for connections

## Non-Goals

* Enterprise system management / administration
* Asset management
* Software distribution
* Automation

## Use Cases

* Connect to a local virtual machine for testing.

## Runtime Dependencies

* genisoimage (usually provided by genisoimage package)

## Reporting issues

Firstly verify that the issue you are experiencing is not yet reported in [our
issue tracker](https://gitlab.GNOME.org/GNOME/GNOME-boxes/issues)

When reporting issues, please provide as much useful information as you can.
This can include:

* The version of Boxes you are running (Menu -> About, or `gnome-boxes --version` in the command line).
* Steps to reproduce your problem.
* An error message, if there is one (in the UI and on the console)
* If Boxes crashes, attach a [stack trace](https://gitlab.gnome.org/GNOME/gnome-boxes/-/wikis/debugging-crashes)
* If additional information is necessary, [activate debug messages](https://gitlab.gnome.org/GNOME/gnome-boxes/-/wikis/Debugging-Crashes#activating-debug-messages).
* A fix/solution (read the HACKING.md file).

If you forget about something important, we will probably ask.

### References

* [GNOME Boxes](https://gnomeboxes.org)