/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciMethod;
import sun.jvm.hotspot.ci.ciObjectFactory;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.opto.InlineTree;
import sun.jvm.hotspot.opto.Node;
import sun.jvm.hotspot.opto.PhaseCFG;
import sun.jvm.hotspot.opto.RootNode;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class Compile
extends VMObject {
    private static AddressField rootField;
    private static CIntField uniqueField;
    private static CIntField entryBciField;
    private static AddressField topField;
    private static AddressField cfgField;
    private static AddressField regallocField;
    private static AddressField methodField;
    private static AddressField iltField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("Compile");
        rootField = type.getAddressField("_root");
        uniqueField = new CIntField(type.getCIntegerField("_unique"), 0L);
        entryBciField = new CIntField(type.getCIntegerField("_entry_bci"), 0L);
        topField = type.getAddressField("_top");
        cfgField = type.getAddressField("_cfg");
        regallocField = type.getAddressField("_regalloc");
        methodField = type.getAddressField("_method");
        iltField = type.getAddressField("_ilt");
    }

    public Compile(Address addr) {
        super(addr);
    }

    public Node root() {
        return new RootNode(rootField.getValue(this.getAddress()));
    }

    public int entryBci() {
        return (int)entryBciField.getValue(this.getAddress());
    }

    public ciMethod method() {
        return (ciMethod)ciObjectFactory.getMetadata(methodField.getValue(this.getAddress()));
    }

    public PhaseCFG cfg() {
        Address a = cfgField.getValue(this.getAddress());
        if (a != null) {
            return new PhaseCFG(a);
        }
        return null;
    }

    public InlineTree ilt() {
        Address a = iltField.getValue(this.getAddress());
        if (a != null) {
            return new InlineTree(a);
        }
        return null;
    }

    public void dumpInlineData(PrintStream out) {
        InlineTree inlTree = this.ilt();
        if (inlTree != null) {
            out.print(" inline " + inlTree.count());
            inlTree.dumpReplayData(out);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Compile.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

