# SPDX-FileCopyrightText: 2018-2025 Laurent Montel <montel@kde.org>
# SPDX-FileCopyrightText: 2018-2019 Volker Krause <vkrause@kde.org>
# SPDX-License-Identifier: BSD-3-Clause


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KPimItineraryConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)
find_dependency(Qt6Gui "6.7.0")
find_dependency(KPim6Mime "6.4.3")
find_dependency(KF6CalendarCore "6.9.0")
find_dependency(KF6Contacts "6.9.0")
find_dependency(KPim6PkPass "6.4.3")

if (NOT TRUE)
    find_dependency(ZLIB)
    find_dependency(Poppler)
    find_dependency(ZXing)
    if (ON)
        find_dependency(LibXml2)
    endif()
endif()

include("${CMAKE_CURRENT_LIST_DIR}/KPim6ItineraryTargets.cmake")

