'''OpenGL extension IMG.user_clip_plane

This module customises the behaviour of the 
OpenGL.raw.GLES1.IMG.user_clip_plane to provide a more 
Python-friendly API

Overview (from the spec)
	
	The OpenGL ES 1.0 Specification does not support user clip planes. This extension
	adds the support for clip planes. This extension was superceded by OpenGL ES 1.1

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/IMG/user_clip_plane.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES1 import _types, _glgets
from OpenGL.raw.GLES1.IMG.user_clip_plane import *
from OpenGL.raw.GLES1.IMG.user_clip_plane import _EXTENSION_NAME

def glInitUserClipPlaneIMG():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

glClipPlanefIMG=wrapper.wrapper(glClipPlanefIMG).setInputArraySize(
    'eqn', 4
)
glClipPlanexIMG=wrapper.wrapper(glClipPlanexIMG).setInputArraySize(
    'eqn', 4
)
### END AUTOGENERATED SECTION