untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFuq9hHY4oe8RtnuPHEfrCpxFXFFyKVBA0EFBKxTRTBfWCORmJVgSFRE2aVSi9EfbQE/YncK3Y9SW0KDXk1GRFA0=

OpenBSD 7.3 errata 011, July 24, 2023:

Workaround for Zenbleed AMD cpu problem. For i386 and amd64 platforms.

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 011_amdcpu.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/i386/i386/machdep.c
===================================================================
RCS file: /cvs/src/sys/arch/i386/i386/machdep.c,v
diff -u -p -u -r1.663 machdep.c
--- sys/arch/i386/i386/machdep.c	30 Jan 2023 10:49:05 -0000	1.663
+++ sys/arch/i386/i386/machdep.c	24 Jul 2023 16:53:52 -0000
@@ -1639,6 +1639,7 @@ identifycpu(struct cpu_info *ci)
 	char *cpu_device = ci->ci_dev->dv_xname;
 	int skipspace;
 	extern uint32_t cpu_meltdown;
+	uint64_t msr, nmsr;
 
 	if (cpuid_level == -1) {
 		name = "486DX";
@@ -1987,13 +1988,17 @@ identifycpu(struct cpu_info *ci)
 	 */
 	if (!strcmp(cpu_vendor, "AuthenticAMD")) {
 		if (ci->ci_family >= 0x10 && ci->ci_family != 0x11) {
-			uint64_t msr;
-
-			msr = rdmsr(MSR_DE_CFG);
-			if ((msr & DE_CFG_SERIALIZE_LFENCE) == 0) {
-				msr |= DE_CFG_SERIALIZE_LFENCE;
-				wrmsr(MSR_DE_CFG, msr);
-			}
+			nmsr = msr = rdmsr(MSR_DE_CFG);
+			nmsr |= DE_CFG_SERIALIZE_LFENCE;
+			if (msr != nmsr)
+				wrmsr(MSR_DE_CFG, nmsr);
+		}
+		if (family == 0x17 && ci->ci_model >= 0x31) {
+			nmsr = msr = rdmsr(MSR_DE_CFG);
+#define DE_CFG_SERIALIZE_9 (1 << 9)		/* Zenbleed chickenbit */
+			nmsr |= DE_CFG_SERIALIZE_9;
+			if (msr != nmsr)
+				wrmsr(MSR_DE_CFG, nmsr);
 		}
 	}
 
Index: sys/arch/amd64/amd64/cpu.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/cpu.c,v
diff -u -p -u -r1.165 cpu.c
--- sys/arch/amd64/amd64/cpu.c	9 Mar 2023 13:17:28 -0000	1.165
+++ sys/arch/amd64/amd64/cpu.c	24 Jul 2023 16:53:42 -0000
@@ -1139,7 +1139,7 @@ void
 cpu_fix_msrs(struct cpu_info *ci)
 {
 	int family = ci->ci_family;
-	uint64_t msr;
+	uint64_t msr, nmsr;
 
 	if (!strcmp(cpu_vendor, "GenuineIntel")) {
 		if ((family > 6 || (family == 6 && ci->ci_model >= 0xd)) &&
@@ -1182,11 +1182,17 @@ cpu_fix_msrs(struct cpu_info *ci)
 		 * where LFENCE is always serializing.
 		 */
 		if (family >= 0x10 && family != 0x11) {
-			msr = rdmsr(MSR_DE_CFG);
-			if ((msr & DE_CFG_SERIALIZE_LFENCE) == 0) {
-				msr |= DE_CFG_SERIALIZE_LFENCE;
-				wrmsr(MSR_DE_CFG, msr);
-			}
+			nmsr = msr = rdmsr(MSR_DE_CFG);
+			nmsr |= DE_CFG_SERIALIZE_LFENCE;
+			if (msr != nmsr)
+				wrmsr(MSR_DE_CFG, nmsr);
+		}
+		if (family == 0x17 && ci->ci_model >= 0x31) {
+			nmsr = msr = rdmsr(MSR_DE_CFG);
+#define DE_CFG_SERIALIZE_9 (1 << 9)	/* Zenbleed chickenbit */
+			nmsr |= DE_CFG_SERIALIZE_9;
+			if (msr != nmsr)
+				wrmsr(MSR_DE_CFG, nmsr);
 		}
 	}
 }
