untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFh+9JTTZzJapAglwCzqNR6cUONf1CZZnOHV/6NwCSUZAfUwPDAxmtL+I8KK78fX83HCJ/7+yYURHpxIufrHWPAY=

OpenBSD 7.3 errata 009, July 12, 2023:

When tracking nexthops over IPv6 multipath routes, or when receiving
a NOTIFICATION while reaching an internal limit, bgpd(8) could crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 009_bgpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install bgpd(8):
    cd /usr/src/usr.sbin/bgpd
    make obj
    make
    make install

Index: usr.sbin/bgpd/kroute.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/kroute.c,v
diff -u -p -u -r1.304 kroute.c
--- usr.sbin/bgpd/kroute.c	7 Mar 2023 10:30:38 -0000	1.304
+++ usr.sbin/bgpd/kroute.c	10 Jul 2023 12:42:37 -0000
@@ -1864,7 +1864,7 @@ kroute6_remove(struct ktable *kt, struct
 	}
 
 	/* check whether a nexthop depends on this kroute */
-	if (kr->flags & F_NEXTHOP) {
+	if (krm->flags & F_NEXTHOP) {
 		RB_FOREACH(n, knexthop_tree, KT2KNT(kt)) {
 			if (n->kroute == krm)
 				knexthop_validate(kt, n);
Index: usr.sbin/bgpd/session.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/session.c,v
diff -u -p -u -r1.442 session.c
--- usr.sbin/bgpd/session.c	9 Mar 2023 13:12:19 -0000	1.442
+++ usr.sbin/bgpd/session.c	10 Jul 2023 12:42:37 -0000
@@ -2003,6 +2003,8 @@ session_process_msg(struct peer *p)
 		}
 	}
 
+	if (p->rbuf == NULL)
+		return;
 	if (rpos < av) {
 		left = av - rpos;
 		memmove(&p->rbuf->buf, p->rbuf->buf + rpos, left);
