/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Counted;
import clojure.lang.IPersistentVector;
import clojure.lang.IReduceInit;
import clojure.lang.ISeq;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import java.util.Collection;

public class LazilyPersistentVector {
    public static IPersistentVector createOwning(Object ... items) {
        if (items.length <= 32) {
            return new PersistentVector(items.length, 5, PersistentVector.EMPTY_NODE, items);
        }
        return PersistentVector.create(items);
    }

    static int fcount(Object c) {
        if (c instanceof Counted) {
            return ((Counted)c).count();
        }
        return ((Collection)c).size();
    }

    public static IPersistentVector create(Object obj) {
        if (obj instanceof IReduceInit) {
            return PersistentVector.create((IReduceInit)obj);
        }
        if (obj instanceof ISeq) {
            return PersistentVector.create(RT.seq(obj));
        }
        if (obj instanceof Iterable) {
            return PersistentVector.create((Iterable)obj);
        }
        return LazilyPersistentVector.createOwning(RT.toArray(obj));
    }
}

