/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssFontFeatureSettings
extends org.w3c.css.properties.css.CssFontFeatureSettings {
    public static final CssIdent on = CssIdent.getIdent("on");
    public static final CssIdent off = CssIdent.getIdent("off");
    public static final CssIdent normal = CssIdent.getIdent("normal");

    public static final CssIdent getAllowedValue(CssIdent ident) {
        if (on.equals(ident)) {
            return on;
        }
        if (off.equals(ident)) {
            return off;
        }
        return null;
    }

    public CssFontFeatureSettings() {
        this.value = initial;
    }

    public CssFontFeatureSettings(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        this.value = CssFontFeatureSettings.parseFontFeatureSettings(ac, expression, this.getPropertyName());
    }

    public static final CssValue parseFontFeatureSettings(ApplContext ac, CssExpression expression, String caller) throws InvalidParamException {
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        ArrayList<CssValue> layervalues = new ArrayList<CssValue>();
        while (!expression.end()) {
            val = expression.getValue();
            op = expression.getOperator();
            switch (val.getType()) {
                case 0: {
                    CssIdent id = val.getIdent();
                    if (CssIdent.isCssWide(id) || normal.equals(id)) {
                        if (expression.getCount() != 1) {
                            throw new InvalidParamException("value", val.toString(), caller, ac);
                        }
                        return val;
                    }
                    if (layervalues.size() == 1 && CssFontFeatureSettings.getAllowedValue(id) != null) {
                        layervalues.add(val);
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), caller, ac);
                }
                case 5: {
                    if (layervalues.size() != 1) {
                        throw new InvalidParamException("value", val.toString(), caller, ac);
                    }
                    layervalues.add(val);
                    break;
                }
                case 1: {
                    CssString s = val.getString();
                    int l = s.toString().length();
                    if (s.toString().length() != 6) {
                        throw new InvalidParamException("value", expression.getValue().toString(), caller, ac);
                    }
                    layervalues.add(val);
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller, ac);
                }
            }
            expression.next();
            if (layervalues.isEmpty()) continue;
            if (layervalues.size() == 2 || layervalues.size() == 1 && op == ',') {
                if (layervalues.size() == 1) {
                    values.add(val);
                    layervalues.clear();
                } else {
                    values.add(new CssValueList(layervalues));
                    layervalues = new ArrayList();
                }
                if (expression.end() || op == ',') continue;
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (layervalues.size() == 1) {
            values.add((CssValue)layervalues.get(0));
        }
        if (!values.isEmpty()) {
            return values.size() == 1 ? (CssValue)values.get(0) : new CssLayerList(values);
        }
        return null;
    }

    public CssFontFeatureSettings(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

