/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.cm.json.ConfigurationReader;
import org.apache.felix.cm.json.ConfigurationResource;
import org.apache.felix.cm.json.Configurations;
import org.apache.felix.configurator.impl.json.BinUtil;
import org.apache.felix.configurator.impl.json.BinaryManager;
import org.apache.felix.configurator.impl.model.BundleState;
import org.apache.felix.configurator.impl.model.Config;
import org.apache.felix.configurator.impl.model.ConfigPolicy;
import org.apache.felix.configurator.impl.model.ConfigurationFile;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;

public class JSONUtil {
    private static final String PROP_RANKING = "ranking";
    private static final String PROP_POLICY = "policy";

    public static BundleState readConfigurationsFromBundle(BinUtil.ResourceProvider provider, Set<String> paths, Report report) {
        BundleState config = new BundleState();
        ArrayList<ConfigurationFile> allFiles = new ArrayList<ConfigurationFile>();
        for (String path : paths) {
            List<ConfigurationFile> files = JSONUtil.readJSON(provider, path, report);
            allFiles.addAll(files);
        }
        Collections.sort(allFiles);
        config.addFiles(allFiles);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ConfigurationFile> readJSON(BinUtil.ResourceProvider provider, String path, Report report) {
        ArrayList<ConfigurationFile> result = new ArrayList<ConfigurationFile>();
        Enumeration<URL> urls = provider.findEntries(path, "*.json");
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String filePath = url.getPath();
                int pos = filePath.lastIndexOf(47);
                String name = path + filePath.substring(pos);
                try {
                    String contents = JSONUtil.getResource(name, url);
                    boolean done = false;
                    BinaryManager binaryManager = new BinaryManager(provider, report);
                    try {
                        ConfigurationFile file = JSONUtil.readJSON(binaryManager, name, url, provider.getBundleId(), contents, report);
                        if (file == null) continue;
                        result.add(file);
                        done = true;
                    }
                    finally {
                        if (done) continue;
                        binaryManager.cleanupFiles();
                    }
                }
                catch (IOException ioe) {
                    report.errors.add("Unable to read " + name + " : " + ioe.getMessage());
                }
            }
            Collections.sort(result);
        } else {
            report.errors.add("No configurations found at path " + path);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfigurationFile readJSON(BinaryManager binaryManager, String name, URL url, long bundleId, String contents, Report report) {
        String identifier = url == null ? name : url.toString();
        try (StringReader reader = new StringReader(contents);){
            ConfigurationFile file;
            HashMap<String, Integer> rankingMap = new HashMap<String, Integer>();
            HashMap<String, ConfigPolicy> policyMap = new HashMap<String, ConfigPolicy>();
            ConfigurationReader cfgReader = Configurations.buildReader().verifyAsBundleResource(url != null).withIdentifier(identifier).withBinaryHandler((ConfigurationReader.BinaryHandler)binaryManager).withConfiguratorPropertyHandler((pid, key, value) -> {
                if (key.equals(PROP_RANKING)) {
                    Integer intObj = (Integer)((Converting)Converters.standardConverter().convert(value).defaultValue(null)).to(Integer.class);
                    if (intObj == null) {
                        report.warnings.add(identifier.concat(" : PID ").concat(pid).concat(" : Invalid ranking ").concat(value.toString()));
                    } else {
                        rankingMap.put(pid, intObj);
                    }
                } else if (key.equals(PROP_POLICY)) {
                    String stringVal = (String)((Converting)Converters.standardConverter().convert(value).defaultValue(null)).to(String.class);
                    if (stringVal == null) {
                        report.errors.add(identifier.concat(" : PID ").concat(pid).concat(" : Invalid policy for configuration : ").concat(value.toString()));
                    } else if (value.equals("default") || value.equals("force")) {
                        policyMap.put(pid, ConfigPolicy.valueOf(stringVal.toUpperCase()));
                    } else {
                        report.errors.add(identifier.concat(" : PID ").concat(pid).concat(" : Invalid policy for configuration : ").concat(value.toString()));
                    }
                }
            }).build((Reader)reader);
            ConfigurationResource rsrc = cfgReader.readConfigurationResource();
            report.errors.addAll(cfgReader.getIgnoredErrors());
            List<Config> list = JSONUtil.createModel(binaryManager, bundleId, rsrc, rankingMap, policyMap);
            if (list.isEmpty()) return null;
            ConfigurationFile configurationFile = file = new ConfigurationFile(url, list);
            return configurationFile;
        }
        catch (IOException ioe) {
            report.errors.add("Invalid JSON from " + identifier);
        }
        return null;
    }

    public static List<Config> createModel(BinaryManager binaryManager, long bundleId, ConfigurationResource rsrc, Map<String, Integer> rankingMap, Map<String, ConfigPolicy> policyMap) {
        ArrayList<Config> configurations = new ArrayList<Config>();
        for (Map.Entry entry : rsrc.getConfigurations().entrySet()) {
            String pid = (String)entry.getKey();
            Hashtable properties = (Hashtable)entry.getValue();
            Config c = new Config(pid, properties, bundleId, rankingMap.computeIfAbsent(pid, id -> 0), policyMap.computeIfAbsent(pid, id -> ConfigPolicy.DEFAULT));
            c.setFiles(binaryManager.flushFiles(pid));
            configurations.add(c);
        }
        return configurations;
    }

    public static String getResource(String name, URL url) throws IOException {
        URLConnection connection = url.openConnection();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
    }

    public static final class Report {
        public final List<String> warnings = new ArrayList<String>();
        public final List<String> errors = new ArrayList<String>();
    }
}

