/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.aesh.readline.terminal.impl.AbstractPosixTerminal;
import org.aesh.readline.terminal.impl.Pty;
import org.aesh.readline.terminal.utils.ShutdownHooks;
import org.aesh.readline.terminal.utils.Signals;
import org.aesh.terminal.tty.Signal;

public class PosixSysTerminal
extends AbstractPosixTerminal {
    protected final InputStream input;
    protected final OutputStream output;
    protected final Map<Signal, Object> nativeHandlers = new HashMap<Signal, Object>();
    protected final ShutdownHooks.Task closer;

    public PosixSysTerminal(String name, String type, Pty pty, boolean nativeSignals) throws IOException {
        super(name, type, pty);
        this.input = pty.getSlaveInput();
        this.output = pty.getSlaveOutput();
        if (nativeSignals) {
            for (Signal signal : Signal.values()) {
                this.nativeHandlers.put(signal, Signals.register(signal.name(), () -> this.raise(signal)));
            }
        }
        this.closer = this::close;
        ShutdownHooks.add(this.closer);
    }

    @Override
    public InputStream input() {
        return this.input;
    }

    @Override
    public OutputStream output() {
        return this.output;
    }

    @Override
    public void close() throws IOException {
        ShutdownHooks.remove(this.closer);
        for (Map.Entry<Signal, Object> entry : this.nativeHandlers.entrySet()) {
            Signals.unregister(entry.getKey().name(), entry.getValue());
        }
        super.close();
    }
}

