/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SQLObjectUtils {
    private static final Logger logger = Logger.getLogger(SQLObjectUtils.class);

    private SQLObjectUtils() {
    }

    public static boolean isInSameSession(SQLObject o1, SQLObject o2) {
        SQLObject o1Parent = o1;
        while (o1Parent.getParent() != null && o1Parent.getParent() instanceof SQLObject) {
            o1Parent = (SQLObject)o1Parent.getParent();
        }
        SQLObject o2Parent = o2;
        while (o2Parent.getParent() != null && o2Parent.getParent() instanceof SQLObject) {
            o2Parent = (SQLObject)o2Parent.getParent();
        }
        logger.debug((Object)("Parent of " + o1 + " is " + o1Parent + ", parent of " + o2 + " is " + o2Parent));
        return o1Parent == o2Parent;
    }

    public static String toQualifiedName(SQLObject obj, Class<? extends SQLObject> stopAt) {
        return SQLObjectUtils.toQualifiedName(obj, stopAt, "");
    }

    public static String toQualifiedName(SQLObject obj, Class<? extends SQLObject> stopAt, String quote) {
        ArrayList<SQLObject> ancestors = new ArrayList<SQLObject>();
        while (obj != null && obj.getClass() != stopAt) {
            ancestors.add(obj);
            if (!(obj.getParent() instanceof SQLObject)) break;
            obj = (SQLObject)obj.getParent();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            String ancestorName = quote + ((SQLObject)ancestors.get(i)).getName() + quote;
            sb.append(ancestorName);
            if (i == 0) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public static String toQualifiedName(SQLObject obj) {
        return SQLObjectUtils.toQualifiedName(obj, null);
    }

    public static <T extends SQLObject> void refreshChildren(SQLObject parent, List<T> newChildren, Class<T> childType) throws SQLObjectException {
        Set<String> oldChildNames = parent.getChildNames(childType);
        HashSet<String> newChildNames = new HashSet<String>();
        for (SQLObject newChild : newChildren) {
            newChildNames.add(newChild.getName());
            if (oldChildNames.contains(newChild.getName())) {
                ((SQLObject)parent.getChildByName(newChild.getName(), childType)).updateToMatch(newChild);
                continue;
            }
            if (newChild instanceof SQLRelationship) {
                SQLRelationship r = (SQLRelationship)newChild;
                r.attachRelationship(r.getPkTable(), r.getFkTable(), false);
                continue;
            }
            parent.addChild(newChild);
        }
        oldChildNames.removeAll(newChildNames);
        for (String removedColName : oldChildNames) {
            T removeMe = parent.getChildByName(removedColName, childType);
            try {
                parent.removeChild((SPObject)removeMe);
            }
            catch (IllegalArgumentException e) {
                throw new SQLObjectException(e);
            }
            catch (ObjectDependentException e) {
                throw new SQLObjectException(e);
            }
        }
    }

    public static SQLTable addSimulatedTable(SQLDatabase db, String catalog, String schema, String name) throws SQLObjectException {
        SQLObject tableContainer;
        SQLObject schemaContainer;
        if (db.getTableByName(catalog, schema, name) != null) {
            throw new SQLObjectException("The table " + catalog + "." + schema + "." + name + " already exists");
        }
        if (catalog != null) {
            if (!db.isCatalogContainer()) {
                throw new SQLObjectException("You tried to add a table with a catalog ancestor to a database that doesn't support catalogs.");
            }
            schemaContainer = db.getCatalogByName(catalog);
            if (schemaContainer == null) {
                schemaContainer = new SQLCatalog(db, catalog, true);
                db.addChild(schemaContainer);
            }
        } else {
            schemaContainer = db;
        }
        if (schema != null) {
            if (!schemaContainer.allowsChildType(SQLSchema.class)) {
                throw new SQLObjectException("The schema container (" + schemaContainer + ") can't actually contain children of type SQLSchema.");
            }
            tableContainer = schemaContainer.getChildByName(schema, SQLSchema.class);
            if (tableContainer == null) {
                tableContainer = new SQLSchema(schemaContainer, schema, true);
                schemaContainer.addChild(tableContainer);
            }
        } else {
            tableContainer = schemaContainer;
        }
        SQLTable newTable = new SQLTable(tableContainer, name, null, "TABLE", true);
        tableContainer.addChild(newTable);
        return newTable;
    }

    public static int countTables(SQLObject so) throws SQLObjectException {
        if (so instanceof SQLTable) {
            return 1;
        }
        if (!so.allowsChildren() || !so.isPopulated() || so.getChildren() == null) {
            return 0;
        }
        int myCount = 0;
        for (SQLObject sQLObject : so.getChildren()) {
            myCount += SQLObjectUtils.countTables(sQLObject);
        }
        return myCount;
    }

    public static int countTablesSnapshot(SQLObject so) throws SQLObjectException {
        if (so instanceof SQLTable) {
            return 1;
        }
        int count = 0;
        for (SQLObject sQLObject : so.getChildren()) {
            count += SQLObjectUtils.countTablesSnapshot(sQLObject);
        }
        return count;
    }

    public static <T extends SQLObject> List<T> findDescendentsByClass(SQLObject so, Class<T> clazz, List<T> addTo) throws SQLObjectException {
        if (clazz == so.getClass()) {
            addTo.add(clazz.cast(so));
        } else {
            for (SQLObject sQLObject : so.getChildren()) {
                SQLObjectUtils.findDescendentsByClass(sQLObject, clazz, addTo);
            }
        }
        return addTo;
    }

    public static List<SQLColumn> findColumnsSourcedFromDatabase(SQLDatabase target, SQLDatabase source) throws SQLObjectException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for dependencies on " + source + " in " + target));
        }
        ArrayList<SQLColumn> matches = new ArrayList<SQLColumn>();
        for (SQLObject sQLObject : target.getChildren()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("-->Next target item is " + sQLObject.getClass().getName() + ": " + sQLObject + " (" + sQLObject.getChildCount() + " children)"));
            }
            if (!(sQLObject instanceof SQLTable)) continue;
            SQLTable t = (SQLTable)sQLObject;
            for (SQLColumn col : t.getColumns()) {
                if (col.getSourceColumn() == null || !source.equals(col.getSourceColumn().getParent().getParentDatabase())) continue;
                matches.add(col);
            }
        }
        return matches;
    }

    public static SQLObject findCommonAncestor(Collection<? extends SQLObject> items) {
        List<SQLObject> commonAncestors = SQLObjectUtils.ancestorList(items.iterator().next());
        logger.debug((Object)("Initial ancestor list: " + commonAncestors));
        for (SQLObject sQLObject : items) {
            List<SQLObject> itemAncestors = SQLObjectUtils.ancestorList(sQLObject);
            logger.debug((Object)("       Comparing with: " + itemAncestors));
            Iterator<SQLObject> cit = commonAncestors.iterator();
            Iterator<SQLObject> iit = itemAncestors.iterator();
            while (cit.hasNext() && iit.hasNext()) {
                if (cit.next() == iit.next()) continue;
                cit.remove();
                break;
            }
            while (cit.hasNext()) {
                cit.next();
                cit.remove();
            }
            logger.debug((Object)("     After this prune: " + commonAncestors));
        }
        SQLObject commonAncestor = commonAncestors.get(commonAncestors.size() - 1);
        logger.debug((Object)("Returning: " + commonAncestor));
        return commonAncestor;
    }

    public static List<SQLObject> ancestorList(SQLObject so) {
        LinkedList<SQLObject> ancestors = new LinkedList<SQLObject>();
        while (so != null) {
            ancestors.add(0, so);
            if (!(so.getParent() instanceof SQLObject)) break;
            so = (SQLObject)so.getParent();
        }
        return ancestors;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCompatibleWithHierarchy(SQLDatabase db, String catalog, String schema, String name) throws SQLObjectException {
        void var5_7;
        SQLObject schemaContainer;
        if (catalog != null) {
            if (!db.isCatalogContainer()) return false;
            schemaContainer = db.getCatalogByName(catalog);
            if (schemaContainer == null) {
                return true;
            }
        } else {
            schemaContainer = db;
        }
        if (schema != null) {
            if (!schemaContainer.allowsChildType(SQLSchema.class)) return false;
            SQLSchema sQLSchema = schemaContainer.getChildByName(schema, SQLSchema.class);
            if (sQLSchema == null) {
                return true;
            }
        } else {
            SQLDatabase sQLDatabase = schemaContainer;
        }
        if (name == null) return false;
        return var5_7.allowsChildType(SQLTable.class);
    }

    public static SQLObject getTableContainer(SQLDatabase db, String catName, String schemaName) throws SQLObjectException {
        db.populate();
        logger.debug((Object)("Looking for catalog=" + catName + ", schema=" + schemaName + " in db " + db));
        if (db.isTableContainer()) {
            if (catName != null || schemaName != null) {
                throw new IllegalArgumentException("Catalog or Schema name was given but neither is necessary.");
            }
            return db;
        }
        if (db.isSchemaContainer()) {
            if (catName != null) {
                throw new IllegalArgumentException("Catalog name was given but is not necessary.");
            }
            if (schemaName == null) {
                throw new IllegalArgumentException("Schema name was expected but none was given.");
            }
            return db.getChildByNameIgnoreCase(schemaName, SQLSchema.class);
        }
        if (db.isCatalogContainer()) {
            if (catName == null) {
                throw new IllegalArgumentException("Catalog name was expected but none was given.");
            }
            SQLCatalog tempCat = db.getCatalogByName(catName);
            if (tempCat == null) {
                return null;
            }
            tempCat.populate();
            logger.debug((Object)("Found catalog " + catName + ". Child Type=" + tempCat.getChildrenWithoutPopulating().get(0).getClass()));
            if (tempCat.isSchemaContainer()) {
                if (schemaName == null) {
                    throw new IllegalArgumentException("Schema name was expected but none was given.");
                }
                return tempCat.getChildByNameIgnoreCase(schemaName, SQLSchema.class);
            }
            if (schemaName != null) {
                throw new IllegalArgumentException("Schema name was given but is not necessary.");
            }
            return tempCat;
        }
        if (db.getChildrenWithoutPopulating().isEmpty()) {
            logger.debug((Object)("Database " + db + " has no children"));
            return null;
        }
        throw new IllegalStateException("Unknown database child type: " + db.getChildrenWithoutPopulating().get(0).getClass());
    }

    public static void populateChildrenWithList(SQLObject objectToPopulate, List<SQLObject> children) {
        if (objectToPopulate instanceof SQLTable) {
            ArrayList<SQLColumn> columnChildren = new ArrayList<SQLColumn>();
            ArrayList<SQLIndex> indexChildren = new ArrayList<SQLIndex>();
            ArrayList<SQLRelationship> relationshipChildren = new ArrayList<SQLRelationship>();
            ArrayList<SQLRelationship.SQLImportedKey> importedKeyChildren = new ArrayList<SQLRelationship.SQLImportedKey>();
            for (SQLObject o : children) {
                if (o instanceof SQLColumn) {
                    columnChildren.add((SQLColumn)o);
                    continue;
                }
                if (o instanceof SQLIndex) {
                    indexChildren.add((SQLIndex)o);
                    continue;
                }
                if (o instanceof SQLRelationship) {
                    relationshipChildren.add((SQLRelationship)o);
                    continue;
                }
                if (o instanceof SQLRelationship.SQLImportedKey) {
                    importedKeyChildren.add((SQLRelationship.SQLImportedKey)o);
                    continue;
                }
                throw new IllegalArgumentException("Unknown child type " + o.getClass() + " for table " + objectToPopulate + ". Cannot add " + o + " as a child.");
            }
            if (!columnChildren.isEmpty()) {
                SQLTable.populateColumnsWithList((SQLTable)objectToPopulate, columnChildren);
            }
            if (!indexChildren.isEmpty()) {
                SQLTable.populateIndicesWithList((SQLTable)objectToPopulate, indexChildren);
            }
            if (!relationshipChildren.isEmpty()) {
                SQLTable.populateRelationshipsWithList((SQLTable)objectToPopulate, relationshipChildren);
            }
            if (!importedKeyChildren.isEmpty()) {
                for (SQLRelationship.SQLImportedKey child : importedKeyChildren) {
                    ((SQLTable)objectToPopulate).addImportedKey(child);
                }
                ((SQLTable)objectToPopulate).setImportedKeysPopulated(true);
            }
        } else if (objectToPopulate instanceof SQLDatabase) {
            SQLDatabase.populateDatabaseWithList((SQLDatabase)objectToPopulate, children);
        } else if (objectToPopulate instanceof SQLCatalog) {
            SQLCatalog.populateCatalogWithList((SQLCatalog)objectToPopulate, children);
        } else if (objectToPopulate instanceof SQLSchema) {
            ArrayList<SQLTable> tables = new ArrayList<SQLTable>();
            for (SQLObject child : children) {
                tables.add((SQLTable)child);
            }
            SQLSchema.populateSchemaWithList((SQLSchema)objectToPopulate, tables);
        } else {
            throw new IllegalArgumentException("Object " + objectToPopulate + " does not " + "allow children and cannot be populated.");
        }
    }
}

