/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.dtdvalidator;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.dtdvalidator.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryDTDValidator
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String xmlfilename;
    private String dtdfilename;
    private boolean dtdintern;

    public JobEntryDTDValidator(String n) {
        super(n, "");
        this.xmlfilename = null;
        this.dtdfilename = null;
        this.dtdintern = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.DTD_VALIDATOR);
    }

    public JobEntryDTDValidator() {
        this("");
    }

    public JobEntryDTDValidator(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryDTDValidator je = (JobEntryDTDValidator)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"xmlfilename", (String)this.xmlfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"dtdfilename", (String)this.dtdfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"dtdintern", (boolean)this.dtdintern));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.xmlfilename = XMLHandler.getTagValue((Node)entrynode, (String)"xmlfilename");
            this.dtdfilename = XMLHandler.getTagValue((Node)entrynode, (String)"dtdfilename");
            this.dtdintern = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"dtdintern"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'DTDvalidator' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.xmlfilename = rep.getJobEntryAttributeString(id_jobentry, "xmlfilename");
            this.dtdfilename = rep.getJobEntryAttributeString(id_jobentry, "dtdfilename");
            this.dtdintern = rep.getJobEntryAttributeBoolean(id_jobentry, "dtdintern");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'DTDvalidator' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "xmlfilename", this.xmlfilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "DTDfilename", this.dtdfilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "dtdintern", this.dtdintern);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'DTDvalidator' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getRealxmlfilename() {
        return this.environmentSubstitute(this.xmlfilename);
    }

    public String getRealDTDfilename() {
        return this.environmentSubstitute(this.dtdfilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        Result result;
        block32: {
            FileObject DTDfile;
            FileObject xmlfile;
            String realDTDfilename;
            String realxmlfilename;
            LogWriter log;
            block31: {
                log = LogWriter.getInstance();
                result = previousResult;
                result.setResult(false);
                realxmlfilename = this.getRealxmlfilename();
                realDTDfilename = this.getRealDTDfilename();
                xmlfile = null;
                DTDfile = null;
                if (this.xmlfilename != null && (this.dtdfilename != null && !this.dtdintern || this.dtdintern)) {
                    xmlfile = KettleVFS.getFileObject((String)realxmlfilename);
                    if (xmlfile.exists()) {
                        URL xmlFile = new File(KettleVFS.getFilename((FileObject)xmlfile)).toURI().toURL();
                        BufferedReader xmlBufferedReader = new BufferedReader(new InputStreamReader(xmlFile.openStream()));
                        StringBuffer xmlStringbuffer = new StringBuffer("");
                        char[] buffertXML = new char[1024];
                        int LenXML = -1;
                        while ((LenXML = xmlBufferedReader.read(buffertXML)) != -1) {
                            xmlStringbuffer.append(buffertXML, 0, LenXML);
                        }
                        DocumentBuilderFactory DocBuilderFactory = DocumentBuilderFactory.newInstance();
                        Document xmlDocDTD = null;
                        DocumentBuilder DocBuilder = DocBuilderFactory.newDocumentBuilder();
                        DocBuilderFactory.setValidating(false);
                        xmlDocDTD = DocBuilder.parse(new ByteArrayInputStream(xmlStringbuffer.toString().getBytes("UTF-8")));
                        String encoding = null;
                        encoding = xmlDocDTD.getXmlEncoding() == null ? "UTF-8" : xmlDocDTD.getXmlEncoding();
                        int xmlStartDTD = xmlStringbuffer.indexOf("<!DOCTYPE");
                        if (this.dtdintern) {
                            if (xmlStartDTD != -1) {
                                if (log.isBasic()) {
                                    log.logBasic(this.toString(), Messages.getString("JobEntryDTDValidator.ERRORDTDFound.Label", realxmlfilename), new Object[0]);
                                }
                            } else if (log.isBasic()) {
                                log.logBasic(this.toString(), Messages.getString("JobEntryDTDValidator.ERRORDTDNotFound.Label", realxmlfilename), new Object[0]);
                            }
                        } else {
                            DTDfile = KettleVFS.getFileObject((String)realDTDfilename);
                            if (DTDfile.exists()) {
                                if (xmlStartDTD != -1) {
                                    int EndDTD = xmlStringbuffer.indexOf(">", xmlStartDTD);
                                    xmlStringbuffer.replace(xmlStartDTD, EndDTD + 1, "");
                                }
                                String xmlRootnodeDTD = xmlDocDTD.getDocumentElement().getNodeName();
                                String RefDTD = "<?xml version='" + xmlDocDTD.getXmlVersion() + "' encoding='" + encoding + "'?>\n<!DOCTYPE " + xmlRootnodeDTD + " SYSTEM '" + KettleVFS.getFilename((FileObject)DTDfile) + "'>\n";
                                int xmloffsetDTD = xmlStringbuffer.indexOf("<" + xmlRootnodeDTD);
                                xmlStringbuffer.replace(0, xmloffsetDTD, RefDTD);
                            } else {
                                log.logError(Messages.getString("JobEntryDTDValidator.ERRORDTDFileNotExists.Subject"), Messages.getString("JobEntryDTDValidator.ERRORDTDFileNotExists.Msg", realDTDfilename), new Object[0]);
                            }
                        }
                        if (this.dtdintern && xmlStartDTD == -1 || !this.dtdintern && !DTDfile.exists()) {
                            result.setResult(false);
                            result.setNrErrors(1L);
                        } else {
                            DocBuilderFactory.setValidating(true);
                            xmlDocDTD = DocBuilder.parse(new ByteArrayInputStream(xmlStringbuffer.toString().getBytes(encoding)));
                            if (log.isDetailed()) {
                                log.logDetailed(Messages.getString("JobEntryDTDValidator.DTDValidatorOK.Subject"), Messages.getString("JobEntryDTDValidator.DTDValidatorOK.Label", realxmlfilename), new Object[0]);
                            }
                            result.setResult(true);
                        }
                    } else {
                        if (!xmlfile.exists()) {
                            log.logError(this.toString(), Messages.getString("JobEntryDTDValidator.FileDoesNotExist.Label", realxmlfilename), new Object[0]);
                        }
                        result.setResult(false);
                        result.setNrErrors(1L);
                    }
                    break block31;
                }
                log.logError(this.toString(), Messages.getString("JobEntryDTDValidator.AllFilesNotNull.Label"), new Object[0]);
                result.setResult(false);
                result.setNrErrors(1L);
            }
            Object var25_26 = null;
            try {
                if (xmlfile != null) {
                    xmlfile.close();
                }
                if (DTDfile != null) {
                    DTDfile.close();
                }
                break block32;
            }
            catch (IOException e2) {}
            break block32;
            {
                catch (Exception e) {
                    log.logError(Messages.getString("JobEntryDTDValidator.ErrorDTDValidator.Subject"), Messages.getString("JobEntryDTDValidator.ErrorDTDValidator.Label", realxmlfilename, realDTDfilename, e.getMessage()), new Object[0]);
                    result.setResult(false);
                    result.setNrErrors(1L);
                    Object var25_27 = null;
                    try {
                        if (xmlfile != null) {
                            xmlfile.close();
                        }
                        if (DTDfile != null) {
                            DTDfile.close();
                        }
                        break block32;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var25_28 = null;
                try {
                    if (xmlfile != null) {
                        xmlfile.close();
                    }
                    if (DTDfile != null) {
                        DTDfile.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setxmlFilename(String filename) {
        this.xmlfilename = filename;
    }

    public String getxmlFilename() {
        return this.xmlfilename;
    }

    public void setdtdFilename(String filename) {
        this.dtdfilename = filename;
    }

    public String getdtdFilename() {
        return this.dtdfilename;
    }

    public boolean getDTDIntern() {
        return this.dtdintern;
    }

    public void setDTDIntern(boolean dtdinternin) {
        this.dtdintern = dtdinternin;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.dtdfilename) && !Const.isEmpty((String)this.xmlfilename)) {
            String realXmlFileName = jobMeta.environmentSubstitute(this.xmlfilename);
            String realXsdFileName = jobMeta.environmentSubstitute(this.dtdfilename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realXmlFileName, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realXsdFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "dtdfilename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "xmlFilename", remarks, ctx);
    }
}

